/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cutlass.line.LineProtoTimestampAdapter;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineTcpEventBuffer;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;

class LineTcpMeasurementEvent
implements Closeable {
    private static final Log LOG = LogFactory.getLog(LineTcpMeasurementEvent.class);
    private final boolean autoCreateNewColumns;
    private final LineTcpEventBuffer buffer;
    private final MicrosecondClock clock;
    private final DefaultColumnTypes defaultColumnTypes;
    private final int maxColumnNameLength;
    private final boolean stringToCharCastAllowed;
    private final LineProtoTimestampAdapter timestampAdapter;
    private boolean commitOnWriterClose;
    private TableUpdateDetails tableUpdateDetails;
    private int writerWorkerId;

    LineTcpMeasurementEvent(long bufLo, long bufSize, MicrosecondClock clock, LineProtoTimestampAdapter timestampAdapter, DefaultColumnTypes defaultColumnTypes, boolean stringToCharCastAllowed, int maxColumnNameLength, boolean autoCreateNewColumns) {
        this.maxColumnNameLength = maxColumnNameLength;
        this.autoCreateNewColumns = autoCreateNewColumns;
        this.buffer = new LineTcpEventBuffer(bufLo, bufSize);
        this.clock = clock;
        this.timestampAdapter = timestampAdapter;
        this.defaultColumnTypes = defaultColumnTypes;
        this.stringToCharCastAllowed = stringToCharCastAllowed;
    }

    public static CairoException boundsError(long entityValue, int columnIndex, int colType) {
        return CairoException.critical(0).put("line protocol integer is out of ").put(ColumnType.nameOf(colType)).put(" bounds [columnIndex=").put(columnIndex).put(", value=").put(entityValue).put(']');
    }

    public static CairoException castError(String ilpType, int columnWriterIndex, int colType, CharSequence name) {
        return CairoException.critical(0).put("cast error for line protocol ").put(ilpType).put(" [columnWriterIndex=").put(columnWriterIndex).put(", columnType=").put(ColumnType.nameOf(colType)).put(":").put(colType).put(", name=").put(name).put(']');
    }

    public static CairoException invalidColNameError(TableUpdateDetails tud, CharSequence colName) {
        return CairoException.critical(0).put("invalid column name [table=").put(tud.getTableNameUtf16()).put(", columnName=").put(colName).put(']');
    }

    public static CairoException newColumnsNotAllowed(TableUpdateDetails tud, String colName) {
        return CairoException.critical(0).put("column does not exist, creating new columns is disabled [table=").put(tud.getTableNameUtf16()).put(", columnName=").put(colName).put(']');
    }

    @Override
    public void close() {
        this.tableUpdateDetails = Misc.free(this.tableUpdateDetails);
    }

    public TableUpdateDetails getTableUpdateDetails() {
        return this.tableUpdateDetails;
    }

    public int getWriterWorkerId() {
        return this.writerWorkerId;
    }

    public void releaseWriter() {
        this.tableUpdateDetails.releaseWriter(this.commitOnWriterClose);
    }

    void append() throws CommitFailedException {
        block31: {
            TableWriter.Row row = null;
            try {
                TableWriterAPI writer = this.tableUpdateDetails.getWriter();
                long offset = this.buffer.getAddress();
                long metadataVersion = this.buffer.readLong(offset);
                offset += 8L;
                if (metadataVersion > writer.getMetadataVersion()) {
                    writer.commit();
                }
                long timestamp = this.buffer.readLong(offset);
                offset += 8L;
                if (timestamp == Long.MIN_VALUE) {
                    timestamp = this.clock.getTicks();
                }
                row = writer.newRow(timestamp);
                int nEntities = this.buffer.readInt(offset);
                offset += 4L;
                long writerMetadataVersion = writer.getMetadataVersion();
                block23: for (int nEntity = 0; nEntity < nEntities; ++nEntity) {
                    byte entityType;
                    int colIndex = this.buffer.readInt(offset);
                    offset += 4L;
                    if (colIndex > -1) {
                        entityType = this.buffer.readByte(offset);
                        ++offset;
                        if (metadataVersion < writerMetadataVersion && !writer.getMetadata().hasColumn(colIndex)) {
                            offset += this.buffer.columnValueLength(entityType, offset);
                            continue;
                        }
                    } else {
                        CharSequence columnName = this.buffer.readUtf16Chars(offset, -colIndex);
                        entityType = this.buffer.readByte(offset += (long)(-colIndex) * 2L);
                        ++offset;
                        colIndex = writer.getMetadata().getColumnIndexQuiet(columnName);
                        if (colIndex < 0) {
                            block30: {
                                row.cancel();
                                row = null;
                                int colType = this.defaultColumnTypes.MAPPED_COLUMN_TYPES[entityType];
                                writer.commit();
                                try {
                                    writer.addColumn(columnName, colType);
                                }
                                catch (CairoException e) {
                                    colIndex = writer.getMetadata().getColumnIndexQuiet(columnName);
                                    if (colIndex >= 0) break block30;
                                    throw e;
                                }
                            }
                            offset = this.buffer.getAddressAfterHeader();
                            nEntity = -1;
                            row = writer.newRow(timestamp);
                            continue;
                        }
                    }
                    switch (entityType) {
                        case 1: {
                            CharSequence cs = this.buffer.readUtf16Chars(offset);
                            row.putSym(colIndex, cs);
                            offset += (long)cs.length() * 2L + 4L;
                            continue block23;
                        }
                        case 8: {
                            row.putSymIndex(colIndex, this.buffer.readInt(offset));
                            offset += 4L;
                            continue block23;
                        }
                        case 12: 
                        case 14: {
                            row.putLong(colIndex, this.buffer.readLong(offset));
                            offset += 8L;
                            continue block23;
                        }
                        case 3: 
                        case 11: {
                            row.putInt(colIndex, this.buffer.readInt(offset));
                            offset += 4L;
                            continue block23;
                        }
                        case 10: 
                        case 16: {
                            row.putShort(colIndex, this.buffer.readShort(offset));
                            offset += 2L;
                            continue block23;
                        }
                        case 9: 
                        case 17: {
                            row.putByte(colIndex, this.buffer.readByte(offset));
                            ++offset;
                            continue block23;
                        }
                        case 18: {
                            row.putDate(colIndex, this.buffer.readLong(offset));
                            offset += 8L;
                            continue block23;
                        }
                        case 15: {
                            row.putDouble(colIndex, this.buffer.readDouble(offset));
                            offset += 8L;
                            continue block23;
                        }
                        case 2: {
                            row.putFloat(colIndex, this.buffer.readFloat(offset));
                            offset += 4L;
                            continue block23;
                        }
                        case 6: {
                            row.putBool(colIndex, this.buffer.readByte(offset) == 1);
                            ++offset;
                            continue block23;
                        }
                        case 4: {
                            CharSequence cs = this.buffer.readUtf16Chars(offset);
                            row.putStr(colIndex, cs);
                            offset += (long)cs.length() * 2L + 4L;
                            continue block23;
                        }
                        case 19: {
                            row.putChar(colIndex, this.buffer.readChar(offset));
                            offset += 2L;
                            continue block23;
                        }
                        case 7: {
                            CharSequence cs = this.buffer.readUtf16Chars(offset);
                            row.putLong256(colIndex, cs);
                            offset += (long)cs.length() * 2L + 4L;
                            continue block23;
                        }
                        case 13: {
                            row.putTimestamp(colIndex, this.buffer.readLong(offset));
                            offset += 8L;
                            continue block23;
                        }
                        case 20: {
                            row.putLong128(colIndex, this.buffer.readLong(offset), this.buffer.readLong(offset + 8L));
                            offset += 16L;
                            continue block23;
                        }
                        case 0: {
                            continue block23;
                        }
                        default: {
                            throw new UnsupportedOperationException("entityType " + entityType + " is not implemented!");
                        }
                    }
                }
                row.append();
                this.tableUpdateDetails.commitIfMaxUncommittedRowsCountReached();
            }
            catch (CommitFailedException commitFailedException) {
                throw commitFailedException;
            }
            catch (Throwable th) {
                LOG.error().$("could not write line protocol measurement [tableName=").$(this.tableUpdateDetails.getTableToken()).$(", message=").$(th.getMessage()).$(th).I$();
                if (row == null) break block31;
                row.cancel();
            }
        }
    }

    void createMeasurementEvent(SecurityContext securityContext, TableUpdateDetails tud, LineTcpParser parser, int workerId) {
        this.writerWorkerId = -2;
        TableUpdateDetails.ThreadLocalDetails localDetails = tud.getThreadLocalDetails(workerId);
        localDetails.resetStateIfNecessary();
        this.tableUpdateDetails = tud;
        long timestamp = parser.getTimestamp();
        if (timestamp != Long.MIN_VALUE) {
            timestamp = this.timestampAdapter.getMicros(timestamp);
        }
        this.buffer.addStructureVersion(this.buffer.getAddress(), localDetails.getMetadataVersion());
        long offset = this.buffer.getAddressAfterHeader();
        int entitiesWritten = 0;
        int n = parser.getEntityCount();
        block54: for (int nEntity = 0; nEntity < n; ++nEntity) {
            int colType;
            LineTcpParser.ProtoEntity entity = parser.getEntity(nEntity);
            byte entityType = entity.getType();
            int columnWriterIndex = localDetails.getColumnIndex(entity.getName(), parser.hasNonAsciiChars());
            if (columnWriterIndex > -1) {
                if (columnWriterIndex == tud.getTimestampIndex()) {
                    timestamp = this.timestampAdapter.getMicros(entity.getLongValue());
                    continue;
                }
                offset = this.buffer.addColumnIndex(offset, columnWriterIndex);
                colType = localDetails.getColumnType(columnWriterIndex);
            } else {
                if (columnWriterIndex != -1) continue;
                String colNameUtf16 = localDetails.getColNameUtf16();
                if (this.autoCreateNewColumns && TableUtils.isValidColumnName(colNameUtf16, this.maxColumnNameLength)) {
                    securityContext.authorizeAlterTableAddColumn(tud.getTableToken());
                    offset = this.buffer.addColumnName(offset, colNameUtf16);
                    colType = localDetails.getColumnType(localDetails.getColNameUtf8(), entityType);
                } else {
                    if (!this.autoCreateNewColumns) {
                        throw LineTcpMeasurementEvent.newColumnsNotAllowed(this.tableUpdateDetails, colNameUtf16);
                    }
                    throw LineTcpMeasurementEvent.invalidColNameError(this.tableUpdateDetails, colNameUtf16);
                }
            }
            ++entitiesWritten;
            switch (entityType) {
                case 1: {
                    if (ColumnType.tagOf(colType) == 12) {
                        offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                        continue block54;
                    }
                    throw LineTcpMeasurementEvent.castError("tag", columnWriterIndex, colType, entity.getName());
                }
                case 3: {
                    switch (ColumnType.tagOf(colType)) {
                        case 6: {
                            offset = this.buffer.addLong(offset, entity.getLongValue());
                            continue block54;
                        }
                        case 5: {
                            long entityValue = entity.getLongValue();
                            if (entityValue >= Integer.MIN_VALUE && entityValue <= Integer.MAX_VALUE) {
                                offset = this.buffer.addInt(offset, (int)entityValue);
                                continue block54;
                            }
                            if (entityValue == Long.MIN_VALUE) {
                                offset = this.buffer.addInt(offset, Integer.MIN_VALUE);
                                continue block54;
                            }
                            throw LineTcpMeasurementEvent.boundsError(entityValue, nEntity, 5);
                        }
                        case 3: {
                            long entityValue = entity.getLongValue();
                            if (entityValue >= -32768L && entityValue <= 32767L) {
                                offset = this.buffer.addShort(offset, (short)entityValue);
                                continue block54;
                            }
                            if (entityValue == Long.MIN_VALUE) {
                                offset = this.buffer.addShort(offset, (short)0);
                                continue block54;
                            }
                            throw LineTcpMeasurementEvent.boundsError(entityValue, nEntity, 3);
                        }
                        case 2: {
                            long entityValue = entity.getLongValue();
                            if (entityValue >= -128L && entityValue <= 127L) {
                                offset = this.buffer.addByte(offset, (byte)entityValue);
                                continue block54;
                            }
                            if (entityValue == Long.MIN_VALUE) {
                                offset = this.buffer.addByte(offset, (byte)0);
                                continue block54;
                            }
                            throw LineTcpMeasurementEvent.boundsError(entityValue, nEntity, 2);
                        }
                        case 8: {
                            offset = this.buffer.addTimestamp(offset, entity.getLongValue());
                            continue block54;
                        }
                        case 7: {
                            offset = this.buffer.addDate(offset, entity.getLongValue());
                            continue block54;
                        }
                        case 10: {
                            offset = this.buffer.addDouble(offset, entity.getLongValue());
                            continue block54;
                        }
                        case 9: {
                            offset = this.buffer.addFloat(offset, entity.getLongValue());
                            continue block54;
                        }
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block54;
                        }
                    }
                    throw LineTcpMeasurementEvent.castError("integer", columnWriterIndex, colType, entity.getName());
                }
                case 2: {
                    switch (ColumnType.tagOf(colType)) {
                        case 10: {
                            offset = this.buffer.addDouble(offset, entity.getFloatValue());
                            continue block54;
                        }
                        case 9: {
                            offset = this.buffer.addFloat(offset, (float)entity.getFloatValue());
                            continue block54;
                        }
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block54;
                        }
                    }
                    throw LineTcpMeasurementEvent.castError("float", columnWriterIndex, colType, entity.getName());
                }
                case 4: {
                    int colTypeMeta = localDetails.getColumnTypeMeta(columnWriterIndex);
                    DirectByteCharSequence entityValue = entity.getValue();
                    if (colTypeMeta == 0) {
                        switch (ColumnType.tagOf(colType)) {
                            case 11: {
                                offset = this.buffer.addString(offset, entityValue, parser.hasNonAsciiChars());
                                continue block54;
                            }
                            case 4: {
                                if (entityValue.length() == 1 && entityValue.byteAt(0) > -1) {
                                    offset = this.buffer.addChar(offset, entityValue.charAt(0));
                                    continue block54;
                                }
                                if (this.stringToCharCastAllowed) {
                                    int encodedResult = Chars.utf8CharDecode(entityValue.getLo(), entityValue.getHi());
                                    if (Numbers.decodeLowShort(encodedResult) > 0) {
                                        offset = this.buffer.addChar(offset, (char)Numbers.decodeHighShort(encodedResult));
                                        continue block54;
                                    }
                                    throw LineTcpMeasurementEvent.castError("string", columnWriterIndex, colType, entity.getName());
                                }
                            }
                            throw LineTcpMeasurementEvent.castError("string", columnWriterIndex, colType, entity.getName());
                            case 12: {
                                offset = this.buffer.addSymbol(offset, entityValue, parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                                continue block54;
                            }
                            case 19: {
                                try {
                                    offset = this.buffer.addUuid(offset, entityValue);
                                    continue block54;
                                }
                                catch (NumericException e) {
                                    throw LineTcpMeasurementEvent.castError("string", columnWriterIndex, colType, entity.getName());
                                }
                            }
                        }
                        throw LineTcpMeasurementEvent.castError("string", columnWriterIndex, colType, entity.getName());
                    }
                    offset = this.buffer.addGeoHash(offset, entityValue, colTypeMeta);
                    continue block54;
                }
                case 7: {
                    switch (ColumnType.tagOf(colType)) {
                        case 13: {
                            offset = this.buffer.addLong256(offset, entity.getValue(), parser.hasNonAsciiChars());
                            continue block54;
                        }
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block54;
                        }
                    }
                    throw LineTcpMeasurementEvent.castError("long256", columnWriterIndex, colType, entity.getName());
                }
                case 6: {
                    byte entityValue = (byte)(entity.getBooleanValue() ? 1 : 0);
                    switch (ColumnType.tagOf(colType)) {
                        case 1: {
                            offset = this.buffer.addBoolean(offset, entityValue);
                            continue block54;
                        }
                        case 2: {
                            offset = this.buffer.addByte(offset, entityValue);
                            continue block54;
                        }
                        case 3: {
                            offset = this.buffer.addShort(offset, entityValue);
                            continue block54;
                        }
                        case 5: {
                            offset = this.buffer.addInt(offset, entityValue);
                            continue block54;
                        }
                        case 6: {
                            offset = this.buffer.addLong(offset, entityValue);
                            continue block54;
                        }
                        case 9: {
                            offset = this.buffer.addFloat(offset, entityValue);
                            continue block54;
                        }
                        case 10: {
                            offset = this.buffer.addDouble(offset, entityValue);
                            continue block54;
                        }
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block54;
                        }
                    }
                    throw LineTcpMeasurementEvent.castError("boolean", columnWriterIndex, colType, entity.getName());
                }
                case 13: {
                    switch (ColumnType.tagOf(colType)) {
                        case 8: {
                            offset = this.buffer.addTimestamp(offset, entity.getLongValue());
                            continue block54;
                        }
                        case 7: {
                            offset = this.buffer.addDate(offset, entity.getLongValue() / 1000L);
                            continue block54;
                        }
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block54;
                        }
                    }
                    throw LineTcpMeasurementEvent.castError("timestamp", columnWriterIndex, colType, entity.getName());
                }
                case 5: {
                    if (ColumnType.tagOf(colType) == 12) {
                        offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                        continue block54;
                    }
                    throw LineTcpMeasurementEvent.castError("symbol", columnWriterIndex, colType, entity.getName());
                }
                case 0: {
                    offset = this.buffer.addNull(offset);
                    continue block54;
                }
            }
        }
        this.buffer.addDesignatedTimestamp(this.buffer.getAddress() + 8L, timestamp);
        this.buffer.addNumOfColumns(this.buffer.getAddress() + 16L, entitiesWritten);
        this.writerWorkerId = tud.getWriterThreadId();
    }

    void createWriterReleaseEvent(TableUpdateDetails tableUpdateDetails, boolean commitOnWriterClose) {
        this.writerWorkerId = -3;
        this.tableUpdateDetails = tableUpdateDetails;
        this.commitOnWriterClose = commitOnWriterClose;
    }
}

