/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.Metrics;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.security.DenyAllSecurityContext;
import io.questdb.cutlass.auth.Authenticator;
import io.questdb.cutlass.auth.AuthenticatorException;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.IOContext;
import io.questdb.network.IODispatcher;
import io.questdb.network.NetworkFacade;
import io.questdb.std.ByteCharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.ByteCharSequence;
import io.questdb.std.str.DirectByteCharSequence;

public class LineTcpConnectionContext
extends IOContext<LineTcpConnectionContext> {
    private static final Log LOG = LogFactory.getLog(LineTcpConnectionContext.class);
    private static final long QUEUE_FULL_LOG_HYSTERESIS_IN_MS = 10000L;
    protected final NetworkFacade nf;
    private final Authenticator authenticator;
    private final DirectByteCharSequence byteCharSequence = new DirectByteCharSequence();
    private final long checkIdleInterval;
    private final long commitInterval;
    private final LineTcpReceiverConfiguration configuration;
    private final boolean disconnectOnError;
    private final long idleTimeout;
    private final Metrics metrics;
    private final MillisecondClock milliClock;
    private final LineTcpParser parser;
    private final LineTcpMeasurementScheduler scheduler;
    private final ByteCharSequenceObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf8 = new ByteCharSequenceObjHashMap();
    protected boolean peerDisconnected;
    protected long recvBufEnd;
    protected long recvBufPos;
    protected long recvBufStart;
    protected long recvBufStartOfMeasurement;
    protected SecurityContext securityContext = DenyAllSecurityContext.INSTANCE;
    private boolean goodMeasurement;
    private long lastQueueFullLogMillis = 0L;
    private long nextCheckIdleTime;
    private long nextCommitTime;

    public LineTcpConnectionContext(LineTcpReceiverConfiguration configuration, LineTcpMeasurementScheduler scheduler, Metrics metrics) {
        this.configuration = configuration;
        this.nf = configuration.getNetworkFacade();
        this.disconnectOnError = configuration.getDisconnectOnError();
        this.scheduler = scheduler;
        this.metrics = metrics;
        this.milliClock = configuration.getMillisecondClock();
        this.parser = new LineTcpParser(configuration.isStringAsTagSupported(), configuration.isSymbolAsFieldSupported());
        this.recvBufStart = Unsafe.malloc(configuration.getNetMsgBufferSize(), 46);
        this.recvBufEnd = this.recvBufStart + (long)configuration.getNetMsgBufferSize();
        this.authenticator = configuration.getFactoryProvider().getLineAuthenticatorFactory().getLineTCPAuthenticator();
        this.clear();
        this.checkIdleInterval = configuration.getMaintenanceInterval();
        this.commitInterval = configuration.getCommitInterval();
        long now = this.milliClock.getTicks();
        this.nextCheckIdleTime = now + this.checkIdleInterval;
        this.nextCommitTime = now + this.commitInterval;
        this.idleTimeout = configuration.getWriterIdleTimeout();
    }

    public void checkIdle(long millis) {
        for (int n = this.tableUpdateDetailsUtf8.size() - 1; n >= 0; --n) {
            ByteCharSequence tableNameUtf8 = this.tableUpdateDetailsUtf8.keys().get(n);
            TableUpdateDetails tud = this.tableUpdateDetailsUtf8.get(tableNameUtf8);
            if (millis - tud.getLastMeasurementMillis() < this.idleTimeout) continue;
            this.tableUpdateDetailsUtf8.remove(tableNameUtf8);
            tud.close();
        }
    }

    @Override
    public void clear() {
        this.securityContext = DenyAllSecurityContext.INSTANCE;
        this.authenticator.clear();
        this.recvBufPos = this.recvBufStart;
        this.peerDisconnected = false;
        this.resetParser();
        ObjList<ByteCharSequence> keys = this.tableUpdateDetailsUtf8.keys();
        for (int n = keys.size() - 1; n >= 0; --n) {
            ByteCharSequence tableNameUtf8 = keys.get(n);
            TableUpdateDetails tud = this.tableUpdateDetailsUtf8.get(tableNameUtf8);
            tud.close();
            this.tableUpdateDetailsUtf8.remove(tableNameUtf8);
        }
    }

    @Override
    public void close() {
        this.fd = -1;
        this.recvBufEnd = this.recvBufPos = Unsafe.free(this.recvBufStart, this.recvBufEnd - this.recvBufStart, 46);
        this.recvBufStart = this.recvBufPos;
        Misc.free(this.authenticator);
        this.clear();
    }

    public long commitWalTables(long wallClockMillis) {
        long minTableNextCommitTime = Long.MAX_VALUE;
        int sz = this.tableUpdateDetailsUtf8.size();
        for (int n = 0; n < sz; ++n) {
            ByteCharSequence tableNameUtf8 = this.tableUpdateDetailsUtf8.keys().get(n);
            TableUpdateDetails tud = this.tableUpdateDetailsUtf8.get(tableNameUtf8);
            if (!tud.isWal()) continue;
            MillisecondClock millisecondClock = tud.getMillisecondClock();
            try {
                long tableNextCommitTime = tud.commitIfIntervalElapsed(wallClockMillis);
                wallClockMillis = millisecondClock.getTicks();
                if (tableNextCommitTime >= minTableNextCommitTime) continue;
                minTableNextCommitTime = tableNextCommitTime;
                continue;
            }
            catch (CommitFailedException ex) {
                if (ex.isTableDropped()) {
                    LOG.info().$("closing writer because table has been dropped (2) [table=").$(tud.getTableNameUtf16()).I$();
                    tud.setWriterInError();
                    tud.releaseWriter(false);
                    continue;
                }
                LOG.critical().$("commit failed [table=").$(tud.getTableNameUtf16()).$(",ex=").$(ex).I$();
                continue;
            }
            catch (Throwable ex) {
                LOG.critical().$("commit failed [table=").$(tud.getTableNameUtf16()).$(",ex=").$(ex).I$();
            }
        }
        return minTableNextCommitTime != Long.MAX_VALUE ? minTableNextCommitTime : wallClockMillis + this.commitInterval;
    }

    public void doMaintenance(long now) {
        if (now > this.nextCommitTime) {
            this.nextCommitTime = this.commitWalTables(now);
        }
        if (now > this.nextCheckIdleTime) {
            this.checkIdle(now);
            this.nextCheckIdleTime = now + this.checkIdleInterval;
        }
    }

    public TableUpdateDetails getTableUpdateDetails(DirectByteCharSequence tableName) {
        return this.tableUpdateDetailsUtf8.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOContextResult handleIO(NetworkIOJob netIoJob) {
        if (this.authenticator.isAuthenticated()) {
            this.read();
            try {
                IOContextResult parasResult = this.parseMeasurements(netIoJob);
                this.doMaintenance(this.milliClock.getTicks());
                IOContextResult iOContextResult = parasResult;
                return iOContextResult;
            }
            finally {
                netIoJob.releaseWalTableDetails();
            }
        }
        return this.handleAuthentication(netIoJob);
    }

    @Override
    public LineTcpConnectionContext of(int fd, IODispatcher<LineTcpConnectionContext> dispatcher) {
        this.authenticator.init(fd, this.recvBufStart, this.recvBufEnd, 0L, 0L);
        if (this.authenticator.isAuthenticated() && this.securityContext == DenyAllSecurityContext.INSTANCE) {
            this.securityContext = this.configuration.getFactoryProvider().getSecurityContextFactory().getInstance(null, 2);
        }
        return super.of(fd, dispatcher);
    }

    private boolean checkQueueFullLogHysteresis() {
        long millis = this.milliClock.getTicks();
        if (millis - this.lastQueueFullLogMillis >= 10000L) {
            this.lastQueueFullLogMillis = millis;
            return true;
        }
        return false;
    }

    private void doHandleDisconnectEvent() {
        if (this.parser.getBufferAddress() == this.recvBufEnd) {
            LOG.error().$('[').$(this.fd).$("] buffer overflow [line.tcp.msg.buffer.size=").$(this.recvBufEnd - this.recvBufStart).$(']').$();
            return;
        }
        if (this.peerDisconnected) {
            if (this.recvBufPos != this.recvBufStart) {
                LOG.info().$('[').$(this.fd).$("] peer disconnected with partial measurement, ").$(this.recvBufPos - this.recvBufStart).$(" unprocessed bytes").$();
            } else {
                LOG.info().$('[').$(this.fd).$("] peer disconnected").$();
            }
        }
    }

    private IOContextResult handleAuthentication(NetworkIOJob netIoJob) {
        try {
            int result = this.authenticator.handleIO();
            switch (result) {
                case 1: {
                    return IOContextResult.NEEDS_WRITE;
                }
                case -1: {
                    assert (this.authenticator.isAuthenticated());
                    assert (this.securityContext == DenyAllSecurityContext.INSTANCE);
                    this.securityContext = this.configuration.getFactoryProvider().getSecurityContextFactory().getInstance(this.authenticator.getPrincipal(), 2);
                    this.recvBufPos = this.authenticator.getRecvBufPos();
                    this.resetParser(this.authenticator.getRecvBufPseudoStart());
                    return this.parseMeasurements(netIoJob);
                }
                case 0: {
                    return IOContextResult.NEEDS_READ;
                }
                case 3: {
                    return IOContextResult.NEEDS_DISCONNECT;
                }
                case 2: {
                    return IOContextResult.QUEUE_FULL;
                }
            }
            LOG.error().$("unexpected authenticator result [result=").$(result).I$();
            return IOContextResult.NEEDS_DISCONNECT;
        }
        catch (AuthenticatorException e) {
            return IOContextResult.NEEDS_DISCONNECT;
        }
    }

    private void logParseError() {
        int position = (int)(this.parser.getBufferAddress() - this.recvBufStartOfMeasurement);
        assert (position >= 0);
        LOG.error().$('[').$(this.fd).$("] could not parse measurement, ").$((Object)this.parser.getErrorCode()).$(" at ").$(position).$(", line (may be mangled due to partial parsing): '").$(this.byteCharSequence.of(this.recvBufStartOfMeasurement, this.parser.getBufferAddress())).$("'").$();
    }

    private void startNewMeasurement() {
        this.parser.startNextMeasurement();
        this.recvBufStartOfMeasurement = this.parser.getBufferAddress();
        if (this.recvBufStartOfMeasurement == this.recvBufPos) {
            this.recvBufPos = this.recvBufStart;
            this.parser.of(this.recvBufStart);
            this.recvBufStartOfMeasurement = this.recvBufStart;
        }
    }

    void addTableUpdateDetails(ByteCharSequence tableNameUtf8, TableUpdateDetails tableUpdateDetails) {
        this.tableUpdateDetailsUtf8.put(tableNameUtf8, tableUpdateDetails);
    }

    protected final boolean compactBuffer(long recvBufStartOfMeasurement) {
        assert (recvBufStartOfMeasurement <= this.recvBufPos);
        if (recvBufStartOfMeasurement > this.recvBufStart) {
            long len = this.recvBufPos - recvBufStartOfMeasurement;
            if (len > 0L) {
                Vect.memmove(this.recvBufStart, recvBufStartOfMeasurement, len);
                long shl = recvBufStartOfMeasurement - this.recvBufStart;
                this.parser.shl(shl);
                this.recvBufStartOfMeasurement -= shl;
            } else {
                assert (len == 0L);
                this.resetParser();
            }
            this.recvBufPos = this.recvBufStart + len;
            return true;
        }
        return false;
    }

    protected SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    protected final IOContextResult parseMeasurements(NetworkIOJob netIoJob) {
        while (true) {
            try {
                block9: while (true) {
                    LineTcpParser.ParseResult rc = this.goodMeasurement ? this.parser.parseMeasurement(this.recvBufPos) : this.parser.skipMeasurement(this.recvBufPos);
                    switch (rc) {
                        case MEASUREMENT_COMPLETE: {
                            if (this.goodMeasurement) {
                                if (this.scheduler.scheduleEvent(this.getSecurityContext(), netIoJob, this, this.parser)) {
                                    if (this.checkQueueFullLogHysteresis()) {
                                        LOG.debug().$('[').$(this.fd).$("] queue full").$();
                                    }
                                    return IOContextResult.QUEUE_FULL;
                                }
                            } else {
                                this.logParseError();
                                this.goodMeasurement = true;
                            }
                            this.startNewMeasurement();
                            continue block9;
                        }
                        case ERROR: {
                            if (this.disconnectOnError) {
                                this.logParseError();
                                return IOContextResult.NEEDS_DISCONNECT;
                            }
                            this.goodMeasurement = false;
                            continue block9;
                        }
                        case BUFFER_UNDERFLOW: {
                            if (this.recvBufPos == this.recvBufEnd && !this.compactBuffer(this.recvBufStartOfMeasurement)) {
                                this.doHandleDisconnectEvent();
                                return IOContextResult.NEEDS_DISCONNECT;
                            }
                            if (this.peerDisconnected) {
                                return IOContextResult.NEEDS_DISCONNECT;
                            }
                            return IOContextResult.NEEDS_READ;
                        }
                    }
                }
            }
            catch (CairoException ex) {
                LOG.error().$('[').$(this.fd).$("] could not process line data [table=").$(this.parser.getMeasurementName()).$(", msg=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
                if (this.disconnectOnError) {
                    this.logParseError();
                    return IOContextResult.NEEDS_DISCONNECT;
                }
                this.goodMeasurement = false;
                continue;
            }
            catch (Throwable ex) {
                LOG.critical().$('[').$(this.fd).$("] could not process line data [table=").$(this.parser.getMeasurementName()).$(", ex=").$(ex).I$();
                this.metrics.health().incrementUnhandledErrors();
                return IOContextResult.NEEDS_DISCONNECT;
            }
            break;
        }
    }

    protected boolean read() {
        int bufferRemaining;
        int orig = bufferRemaining = (int)(this.recvBufEnd - this.recvBufPos);
        if (bufferRemaining > 0 && !this.peerDisconnected) {
            int bytesRead = this.nf.recv(this.fd, this.recvBufPos, bufferRemaining);
            if (bytesRead > 0) {
                this.recvBufPos += (long)bytesRead;
                bufferRemaining -= bytesRead;
            } else {
                this.peerDisconnected = bytesRead < 0;
            }
            return bufferRemaining < orig;
        }
        return !this.peerDisconnected;
    }

    TableUpdateDetails removeTableUpdateDetails(DirectByteCharSequence tableNameUtf8) {
        int keyIndex = this.tableUpdateDetailsUtf8.keyIndex(tableNameUtf8);
        if (keyIndex < 0) {
            TableUpdateDetails tud = this.tableUpdateDetailsUtf8.valueAtQuick(keyIndex);
            this.tableUpdateDetailsUtf8.removeAt(keyIndex);
            return tud;
        }
        return null;
    }

    protected void resetParser() {
        this.resetParser(this.recvBufStart);
    }

    protected void resetParser(long pos) {
        this.parser.of(pos);
        this.goodMeasurement = true;
        this.recvBufStartOfMeasurement = pos;
    }

    public static enum IOContextResult {
        NEEDS_READ,
        NEEDS_WRITE,
        QUEUE_FULL,
        NEEDS_DISCONNECT;

    }
}

