/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpMultipartContentListener;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.ex.RetryOperationException;
import io.questdb.cutlass.http.processors.TextImportProcessorState;
import io.questdb.cutlass.http.processors.TextLoaderCompletedState;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextLoadWarning;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class TextImportProcessor
implements HttpRequestProcessor,
HttpMultipartContentListener,
Closeable {
    static final int MESSAGE_UNKNOWN = 3;
    static final int RESPONSE_PREFIX = 1;
    private static final CharSequence CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    private static final CharSequence CONTENT_TYPE_TEXT = "text/plain; charset=utf-8";
    private static final Log LOG = LogFactory.getLog(TextImportProcessor.class);
    private static final LocalValue<TextImportProcessorState> LV = new LocalValue();
    private static final int MESSAGE_DATA = 2;
    private static final int MESSAGE_SCHEMA = 1;
    private static final String OVERRIDDEN_FROM_TABLE = "From Table";
    private static final int RESPONSE_COLUMN = 2;
    private static final int RESPONSE_COMPLETE = 6;
    private static final int RESPONSE_DONE = 5;
    private static final int RESPONSE_ERROR = 4;
    private static final int RESPONSE_SUFFIX = 3;
    private static final int TO_STRING_COL1_PAD = 15;
    private static final int TO_STRING_COL2_PAD = 50;
    private static final int TO_STRING_COL3_PAD = 15;
    private static final int TO_STRING_COL4_PAD = 7;
    private static final int TO_STRING_COL5_PAD = 12;
    private static final CharSequenceIntHashMap atomicityParamMap = new CharSequenceIntHashMap();
    private final CairoEngine engine;
    private HttpConnectionContext transientContext;
    private TextImportProcessorState transientState;

    public TextImportProcessor(CairoEngine cairoEngine) {
        this.engine = cairoEngine;
    }

    @Override
    public void close() {
    }

    @Override
    public void failRequest(HttpConnectionContext context, HttpException e) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        this.sendErrorAndThrowDisconnect(e.getFlyweightMessage());
    }

    @Override
    public void onChunk(long lo, long hi) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        if (hi > lo) {
            try {
                this.transientState.lo = lo;
                this.transientState.hi = hi;
                this.transientState.textLoader.parse(lo, hi, this.transientContext.getSecurityContext());
                if (this.transientState.messagePart == 2 && !this.transientState.analysed) {
                    this.transientState.analysed = true;
                    this.transientState.textLoader.setState(2);
                }
            }
            catch (EntryUnavailableException e) {
                throw RetryOperationException.INSTANCE;
            }
            catch (CairoError | CairoException | TextException e) {
                this.sendErrorAndThrowDisconnect(((FlyweightMessageContainer)((Object)e)).getFlyweightMessage());
            }
        }
    }

    @Override
    public void onPartBegin(HttpRequestHeader partHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        CharSequence contentDisposition = partHeader.getContentDispositionName();
        LOG.debug().$("part begin [name=").$(contentDisposition).$(']').$();
        if (Chars.equalsNc((CharSequence)"data", contentDisposition)) {
            DirectByteCharSequence maxUncommittedRowsChars;
            int partitionBy;
            CharSequence partitionedBy;
            HttpRequestHeader rh = this.transientContext.getRequestHeader();
            CharSequence name = rh.getUrlParam("name");
            if (name == null) {
                name = partHeader.getContentDispositionFilename();
            }
            if (name == null) {
                this.sendErrorAndThrowDisconnect("no file name given");
            }
            if ((partitionedBy = rh.getUrlParam("partitionBy")) == null) {
                partitionedBy = "NONE";
            }
            if ((partitionBy = PartitionBy.fromString(partitionedBy)) == -1) {
                this.sendErrorAndThrowDisconnect("invalid partitionBy");
            }
            DirectByteCharSequence timestampColumn = rh.getUrlParam("timestamp");
            if (PartitionBy.isPartitioned(partitionBy) && timestampColumn == null) {
                this.sendErrorAndThrowDisconnect("when specifying partitionBy you must also specify timestamp");
            }
            this.transientState.analysed = false;
            this.transientState.textLoader.configureDestination(name, Chars.equalsNc((CharSequence)"true", rh.getUrlParam("overwrite")), TextImportProcessor.getAtomicity(rh.getUrlParam("atomicity")), partitionBy, timestampColumn, null);
            DirectByteCharSequence o3MaxLagChars = rh.getUrlParam("o3MaxLag");
            if (o3MaxLagChars != null) {
                try {
                    long o3MaxLag = Numbers.parseLong(o3MaxLagChars);
                    if (o3MaxLag >= 0L) {
                        this.transientState.textLoader.setO3MaxLag(o3MaxLag);
                    }
                }
                catch (NumericException e) {
                    this.sendErrorAndThrowDisconnect("invalid o3MaxLag value, must be a long");
                }
            }
            if ((maxUncommittedRowsChars = rh.getUrlParam("maxUncommittedRows")) != null) {
                try {
                    int maxUncommittedRows = Numbers.parseInt(maxUncommittedRowsChars);
                    if (maxUncommittedRows >= 0) {
                        this.transientState.textLoader.setMaxUncommittedRows(maxUncommittedRows);
                    }
                }
                catch (NumericException e) {
                    this.sendErrorAndThrowDisconnect("invalid maxUncommittedRows, must be an int");
                }
            }
            this.transientState.textLoader.setForceHeaders(Chars.equalsNc((CharSequence)"true", rh.getUrlParam("forceHeader")));
            this.transientState.textLoader.setSkipLinesWithExtraValues(Chars.equalsNc((CharSequence)"true", rh.getUrlParam("skipLev")));
            DirectByteCharSequence delimiter = rh.getUrlParam("delimiter");
            if (delimiter != null && delimiter.length() == 1) {
                this.transientState.textLoader.configureColumnDelimiter((byte)delimiter.charAt(0));
            }
            this.transientState.textLoader.setState(1);
            this.transientState.forceHeader = Chars.equalsNc((CharSequence)"true", rh.getUrlParam("forceHeader"));
            this.transientState.messagePart = 2;
        } else if (Chars.equalsNc((CharSequence)"schema", contentDisposition)) {
            this.transientState.textLoader.setState(0);
            this.transientState.messagePart = 1;
        } else if (partHeader.getContentDisposition() == null) {
            this.sendErrorAndThrowDisconnect("'Content-Disposition' multipart header missing'");
        } else {
            this.sendErrorAndThrowDisconnect("invalid value in 'Content-Disposition' multipart header");
        }
    }

    @Override
    public void onPartEnd() throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        try {
            LOG.debug().$("part end").$();
            this.transientState.textLoader.wrapUp();
            if (this.transientState.messagePart == 2) {
                this.sendResponse(this.transientContext);
            }
        }
        catch (CairoError | CairoException | TextException e) {
            this.sendErrorAndThrowDisconnect(((FlyweightMessageContainer)((Object)e)).getFlyweightMessage());
        }
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) {
        this.transientState.clear();
    }

    @Override
    public void onRequestRetry(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        this.transientContext = context;
        this.transientState = LV.get(context);
        this.onChunk(this.transientState.lo, this.transientState.hi);
    }

    @Override
    public void resumeRecv(HttpConnectionContext context) {
        this.transientContext = context;
        this.transientState = LV.get(context);
        if (this.transientState == null) {
            LOG.debug().$("new text state").$();
            this.transientState = new TextImportProcessorState(this.engine);
            LV.set(context, this.transientState);
        }
        this.transientState.json = this.isJson(context);
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        context.resumeResponseSend();
        this.doResumeSend(LV.get(context), context.getChunkedResponseSocket());
    }

    private static int getAtomicity(CharSequence name) {
        if (name == null) {
            return 2;
        }
        int atomicity = atomicityParamMap.get(name);
        return atomicity == -1 ? 2 : atomicity;
    }

    private static void pad(CharSink b, int w, long value) {
        int len = (int)Math.log10(value);
        if (len < 0) {
            len = 0;
        }
        TextImportProcessor.replicate(b, ' ', w - len - 1);
        b.put(value);
        b.put("  |");
    }

    private static CharSink pad(CharSink b, int w, CharSequence value) {
        int pad = value == null ? w : w - value.length();
        TextImportProcessor.replicate(b, ' ', pad);
        if (value != null) {
            if (pad < 0) {
                b.put("...").put(value.subSequence(-pad + 3, value.length()));
            } else {
                b.put(value);
            }
        }
        b.put("  |");
        return b;
    }

    private static void replicate(CharSink b, char c, int times) {
        for (int i = 0; i < times; ++i) {
            b.put(c);
        }
    }

    private static void resumeJson(TextImportProcessorState state, HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException {
        TextLoaderCompletedState completeState = state.completeState;
        RecordMetadata metadata = completeState.getMetadata();
        LongList errors = completeState.getColumnErrorCounts();
        switch (state.responseState) {
            case 1: {
                long totalRows = completeState.getParsedLineCount();
                long importedRows = completeState.getWrittenLineCount();
                socket.put('{').putQuoted("status").put(':').putQuoted("OK").put(',').putQuoted("location").put(':').encodeUtf8AndQuote(completeState.getTableName()).put(',').putQuoted("rowsRejected").put(':').put(totalRows - importedRows + completeState.getErrorLineCount()).put(',').putQuoted("rowsImported").put(':').put(importedRows).put(',').putQuoted("header").put(':').put(completeState.isHeaderDetected()).put(',').putQuoted("partitionBy").put(':').putQuoted(PartitionBy.toString(completeState.getPartitionBy())).put(',');
                int tsIdx = metadata.getTimestampIndex();
                if (tsIdx != -1) {
                    socket.putQuoted("timestamp").put(':').encodeUtf8AndQuote(metadata.getColumnName(tsIdx)).put(',');
                }
                if (completeState.getWarnings() != 0) {
                    int warningFlags = completeState.getWarnings();
                    socket.putQuoted("warnings").put(':').put('[');
                    boolean isFirst = true;
                    if ((warningFlags & 1) != 0) {
                        isFirst = false;
                        socket.putQuoted("Existing table timestamp column is used");
                    }
                    if ((warningFlags & 2) != 0) {
                        if (!isFirst) {
                            socket.put(',');
                        }
                        socket.putQuoted("Existing table PartitionBy is used");
                    }
                    socket.put(']').put(',');
                }
                socket.putQuoted("columns").put(':').put('[');
                state.responseState = 2;
            }
            case 2: {
                if (metadata != null) {
                    int columnCount = metadata.getColumnCount();
                    while (state.columnIndex < columnCount) {
                        socket.bookmark();
                        if (state.columnIndex > 0) {
                            socket.put(',');
                        }
                        socket.put('{').putQuoted("name").put(':').putQuoted(metadata.getColumnName(state.columnIndex)).put(',').putQuoted("type").put(':').putQuoted(ColumnType.nameOf(metadata.getColumnType(state.columnIndex))).put(',').putQuoted("size").put(':').put(ColumnType.sizeOf(metadata.getColumnType(state.columnIndex))).put(',').putQuoted("errors").put(':').put(errors.getQuick(state.columnIndex));
                        socket.put('}');
                        ++state.columnIndex;
                    }
                }
                state.responseState = 3;
            }
            case 3: {
                socket.bookmark();
                socket.put(']').put('}');
                state.responseState = 6;
                socket.sendChunk(true);
                break;
            }
            case 5: {
                state.responseState = 6;
                socket.done();
                break;
            }
        }
    }

    private static void resumeText(TextImportProcessorState state, HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException {
        TextLoaderCompletedState textLoaderCompletedState = state.completeState;
        RecordMetadata metadata = textLoaderCompletedState.getMetadata();
        LongList errors = textLoaderCompletedState.getColumnErrorCounts();
        switch (state.responseState) {
            case 1: {
                TextImportProcessor.sep(socket);
                socket.put('|');
                TextImportProcessor.pad((CharSink)socket, 15, "Location:");
                TextImportProcessor.pad((CharSink)socket, 50, textLoaderCompletedState.getTableName());
                TextImportProcessor.pad((CharSink)socket, 15, "Pattern");
                TextImportProcessor.pad((CharSink)socket, 7, "Locale");
                TextImportProcessor.pad((CharSink)socket, 12, "Errors").put("\r\n");
                socket.put('|');
                TextImportProcessor.pad((CharSink)socket, 15, "Partition by");
                TextImportProcessor.pad((CharSink)socket, 50, PartitionBy.toString(textLoaderCompletedState.getPartitionBy()));
                TextImportProcessor.pad((CharSink)socket, 15, "");
                TextImportProcessor.pad((CharSink)socket, 7, "");
                if (TextLoadWarning.hasFlag(textLoaderCompletedState.getWarnings(), 2)) {
                    TextImportProcessor.pad((CharSink)socket, 12, OVERRIDDEN_FROM_TABLE);
                } else {
                    TextImportProcessor.pad((CharSink)socket, 12, "");
                }
                socket.put("\r\n");
                socket.put('|');
                TextImportProcessor.pad((CharSink)socket, 15, "Timestamp");
                TextImportProcessor.pad((CharSink)socket, 50, textLoaderCompletedState.getTimestampCol() == null ? "NONE" : textLoaderCompletedState.getTimestampCol());
                TextImportProcessor.pad((CharSink)socket, 15, "");
                TextImportProcessor.pad((CharSink)socket, 7, "");
                if (TextLoadWarning.hasFlag(textLoaderCompletedState.getWarnings(), 1)) {
                    TextImportProcessor.pad((CharSink)socket, 12, OVERRIDDEN_FROM_TABLE);
                } else {
                    TextImportProcessor.pad((CharSink)socket, 12, "");
                }
                socket.put("\r\n");
                TextImportProcessor.sep(socket);
                socket.put('|');
                TextImportProcessor.pad((CharSink)socket, 15, "Rows handled");
                TextImportProcessor.pad((CharSink)socket, 50, textLoaderCompletedState.getParsedLineCount() + textLoaderCompletedState.getErrorLineCount());
                TextImportProcessor.pad((CharSink)socket, 15, "");
                TextImportProcessor.pad((CharSink)socket, 7, "");
                TextImportProcessor.pad((CharSink)socket, 12, "").put("\r\n");
                socket.put('|');
                TextImportProcessor.pad((CharSink)socket, 15, "Rows imported");
                TextImportProcessor.pad((CharSink)socket, 50, textLoaderCompletedState.getWrittenLineCount());
                TextImportProcessor.pad((CharSink)socket, 15, "");
                TextImportProcessor.pad((CharSink)socket, 7, "");
                TextImportProcessor.pad((CharSink)socket, 12, "").put("\r\n");
                TextImportProcessor.sep(socket);
                state.responseState = 2;
            }
            case 2: {
                if (metadata != null) {
                    int columnCount = metadata.getColumnCount();
                    while (state.columnIndex < columnCount) {
                        socket.bookmark();
                        socket.put('|');
                        TextImportProcessor.pad((CharSink)socket, 15, state.columnIndex);
                        TextImportProcessor.pad((CharSink)socket, 50, metadata.getColumnName(state.columnIndex));
                        if (!metadata.isColumnIndexed(state.columnIndex)) {
                            TextImportProcessor.pad((CharSink)socket, 25, ColumnType.nameOf(metadata.getColumnType(state.columnIndex)));
                        } else {
                            StringSink sink = Misc.getThreadLocalBuilder();
                            sink.put("(idx/").put(metadata.getIndexValueBlockCapacity(state.columnIndex)).put(") ");
                            sink.put(ColumnType.nameOf(metadata.getColumnType(state.columnIndex)));
                            TextImportProcessor.pad((CharSink)socket, 25, sink);
                        }
                        TextImportProcessor.pad((CharSink)socket, 12, errors.getQuick(state.columnIndex));
                        socket.put("\r\n");
                        ++state.columnIndex;
                    }
                }
                state.responseState = 3;
            }
            case 3: {
                socket.bookmark();
                TextImportProcessor.sep(socket);
                state.responseState = 6;
                socket.sendChunk(true);
                break;
            }
            case 5: {
                state.responseState = 6;
                socket.done();
                break;
            }
        }
    }

    private static void sep(CharSink b) {
        b.put('+');
        TextImportProcessor.replicate(b, '-', 113);
        b.put("+\r\n");
    }

    private void doResumeSend(TextImportProcessorState state, HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        try {
            if (state.errorMessage != null) {
                this.resumeError(state, socket);
            } else if (state.json) {
                TextImportProcessor.resumeJson(state, socket);
            } else {
                TextImportProcessor.resumeText(state, socket);
            }
        }
        catch (NoSpaceLeftInResponseBufferException ignored) {
            if (socket.resetToBookmark()) {
                socket.sendChunk(false);
            }
            socket.shutdownWrite();
            throw ServerDisconnectException.INSTANCE;
        }
        state.clear();
    }

    private boolean isJson(HttpConnectionContext transientContext) {
        return Chars.equalsNc((CharSequence)"json", transientContext.getRequestHeader().getUrlParam("fmt"));
    }

    private void resumeError(TextImportProcessorState state, HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        if (state.responseState == 4) {
            socket.bookmark();
            if (state.json) {
                socket.put('{').putQuoted("status").put(':').encodeUtf8AndQuote(state.errorMessage).put('}');
            } else {
                socket.encodeUtf8(state.errorMessage);
            }
            state.responseState = 5;
            socket.sendChunk(true);
        }
        socket.shutdownWrite();
        throw ServerDisconnectException.INSTANCE;
    }

    private void sendErr(HttpConnectionContext context, CharSequence message, HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        TextImportProcessorState state = LV.get(context);
        state.responseState = 4;
        state.errorMessage = message;
        if (state.json) {
            socket.status(200, CONTENT_TYPE_JSON);
        } else {
            socket.status(200, CONTENT_TYPE_TEXT);
        }
        socket.sendHeader();
        socket.sendChunk(false);
        this.resumeError(state, socket);
    }

    private void sendErrorAndThrowDisconnect(CharSequence message) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        this.transientState.snapshotStateAndCloseWriter();
        HttpChunkedResponseSocket socket = this.transientContext.getChunkedResponseSocket();
        this.sendErr(this.transientContext, message, socket);
    }

    private void sendResponse(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        TextImportProcessorState state = LV.get(context);
        HttpChunkedResponseSocket socket = context.getChunkedResponseSocket();
        state.snapshotStateAndCloseWriter();
        if (state.state == 0) {
            if (state.json) {
                socket.status(200, CONTENT_TYPE_JSON);
            } else {
                socket.status(200, CONTENT_TYPE_TEXT);
            }
            socket.sendHeader();
            this.doResumeSend(state, socket);
        } else {
            this.sendErr(context, state.stateMessage, context.getChunkedResponseSocket());
        }
    }

    static {
        atomicityParamMap.put("skipRow", 1);
        atomicityParamMap.put("abort", 0);
    }
}

