/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.processors.JsonQueryProcessor;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.cutlass.text.TextUtil;
import io.questdb.cutlass.text.Utf8Exception;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.SCSequence;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.Chars;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.NanosecondClock;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import io.questdb.std.Uuid;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class JsonQueryProcessorState
implements Mutable,
Closeable {
    static final int QUERY_METADATA = 2;
    static final int QUERY_METADATA_SUFFIX = 3;
    static final int QUERY_PREFIX = 1;
    static final int QUERY_RECORD = 5;
    static final int QUERY_RECORD_PREFIX = 9;
    static final int QUERY_RECORD_START = 4;
    static final int QUERY_RECORD_SUFFIX = 6;
    static final int QUERY_SETUP_FIRST_RECORD = 8;
    static final int QUERY_SUFFIX = 7;
    private static final Log LOG = LogFactory.getLog(JsonQueryProcessorState.class);
    private final ObjList<String> columnNames = new ObjList();
    private int queryTimestampIndex;
    private final IntList columnSkewList = new IntList();
    private final IntList columnTypesAndFlags = new IntList();
    private final StringSink columnsQueryParameter = new StringSink();
    private final int doubleScale;
    private final SCSequence eventSubSequence = new SCSequence();
    private final int floatScale;
    private final HttpConnectionContext httpConnectionContext;
    private final NanosecondClock nanosecondClock;
    private final StringSink query = new StringSink();
    private final ObjList<StateResumeAction> resumeActions = new ObjList();
    private final long statementTimeout;
    private int columnCount;
    private int columnIndex;
    private long compilerNanos;
    private long count;
    private boolean countRows = false;
    private RecordCursor cursor;
    private long executeStartNanos;
    private boolean explain = false;
    private boolean noMeta = false;
    private OperationFuture operationFuture;
    private boolean pausedQuery = false;
    private boolean queryCacheable = false;
    private boolean queryJitCompiled = false;
    private int queryState = 1;
    private short queryType;
    private boolean quoteLargeNum = false;
    private Record record;
    private long recordCountNanos;
    private RecordCursorFactory recordCursorFactory;
    private Rnd rnd;
    private long skip;
    private long stop;
    private boolean timings = false;

    public JsonQueryProcessorState(HttpConnectionContext httpConnectionContext, NanosecondClock nanosecondClock, int floatScale, int doubleScale) {
        this.httpConnectionContext = httpConnectionContext;
        this.resumeActions.extendAndSet(1, this::onQueryPrefix);
        this.resumeActions.extendAndSet(2, this::onQueryMetadata);
        this.resumeActions.extendAndSet(3, this::onQueryMetadataSuffix);
        this.resumeActions.extendAndSet(8, this::doFirstRecordLoop);
        this.resumeActions.extendAndSet(9, this::onQueryRecordPrefix);
        this.resumeActions.extendAndSet(5, this::onQueryRecord);
        this.resumeActions.extendAndSet(6, this::onQueryRecordSuffix);
        this.resumeActions.extendAndSet(7, this::doQuerySuffix);
        this.nanosecondClock = nanosecondClock;
        this.floatScale = floatScale;
        this.doubleScale = doubleScale;
        this.statementTimeout = httpConnectionContext.getRequestHeader().getStatementTimeout();
    }

    @Override
    public void clear() {
        this.columnCount = 0;
        this.columnSkewList.clear();
        this.columnTypesAndFlags.clear();
        this.columnNames.clear();
        this.queryTimestampIndex = -1;
        this.cursor = Misc.free(this.cursor);
        this.record = null;
        if (this.recordCursorFactory != null) {
            if (this.queryCacheable) {
                QueryCache.getThreadLocalInstance().push(this.query, this.recordCursorFactory);
            } else {
                this.recordCursorFactory.close();
            }
            this.recordCursorFactory = null;
        }
        this.query.clear();
        this.columnsQueryParameter.clear();
        this.queryState = 1;
        this.columnIndex = 0;
        this.countRows = false;
        this.explain = false;
        this.noMeta = false;
        this.timings = false;
        this.pausedQuery = false;
        this.quoteLargeNum = false;
        this.queryJitCompiled = false;
        this.operationFuture = Misc.free(this.operationFuture);
        this.skip = 0L;
        this.count = 0L;
        this.stop = 0L;
    }

    @Override
    public void close() {
        this.cursor = Misc.free(this.cursor);
        this.recordCursorFactory = Misc.free(this.recordCursorFactory);
        this.freeAsyncOperation();
    }

    public void configure(HttpRequestHeader request, DirectByteCharSequence query, long skip, long stop) throws Utf8Exception {
        this.query.clear();
        TextUtil.utf8ToUtf16(query.getLo(), query.getHi(), this.query);
        this.skip = skip;
        this.stop = stop;
        this.count = 0L;
        this.noMeta = Chars.equalsNc((CharSequence)"true", request.getUrlParam("nm"));
        this.countRows = Chars.equalsNc((CharSequence)"true", request.getUrlParam("count"));
        this.timings = Chars.equalsNc((CharSequence)"true", request.getUrlParam("timings"));
        this.explain = Chars.equalsNc((CharSequence)"true", request.getUrlParam("explain"));
        this.quoteLargeNum = Chars.equalsNc((CharSequence)"true", request.getUrlParam("quoteLargeNum")) || Chars.equalsNc((CharSequence)"con", request.getUrlParam("src"));
    }

    public LogRecord critical() {
        return LOG.critical().$('[').$(this.getFd()).$("] ");
    }

    public LogRecord error() {
        return LOG.error().$('[').$(this.getFd()).$("] ");
    }

    public void freeAsyncOperation() {
        this.operationFuture = Misc.free(this.operationFuture);
    }

    public SCSequence getEventSubSequence() {
        return this.eventSubSequence;
    }

    public long getExecutionTimeNanos() {
        return this.nanosecondClock.getTicks() - this.executeStartNanos;
    }

    public HttpConnectionContext getHttpConnectionContext() {
        return this.httpConnectionContext;
    }

    public OperationFuture getOperationFuture() {
        return this.operationFuture;
    }

    public CharSequence getQuery() {
        return this.query;
    }

    public short getQueryType() {
        return this.queryType;
    }

    public Rnd getRnd() {
        return this.rnd;
    }

    public long getStatementTimeout() {
        return this.statementTimeout;
    }

    public LogRecord info() {
        return LOG.info().$('[').$(this.getFd()).$("] ");
    }

    public boolean isPausedQuery() {
        return this.pausedQuery;
    }

    public void logBufferTooSmall() {
        this.info().$("Response buffer is too small, state=").$(this.queryState).$();
    }

    public void logExecuteCached() {
        this.info().$("execute-cached [skip: ").$(this.skip).$(", stop: ").$(this.stop).I$();
    }

    public void logExecuteNew() {
        this.info().$("execute-new [skip: ").$(this.skip).$(", stop: ").$(this.stop).I$();
    }

    public void logSqlError(FlyweightMessageContainer container) {
        this.info().$("sql error [q=`").utf8(this.query).$("`, at=").$(container.getPosition()).$(", message=`").utf8(container.getFlyweightMessage()).$('`').$(']').$();
    }

    public void logTimings() {
        this.info().$("timings ").$("[compiler: ").$(this.compilerNanos).$(", count: ").$(this.recordCountNanos).$(", execute: ").$(this.nanosecondClock.getTicks() - this.executeStartNanos).$(", q=`").utf8(this.query).$("`]").$();
    }

    public void setCompilerNanos(long compilerNanos) {
        this.compilerNanos = compilerNanos;
    }

    public void setOperationFuture(OperationFuture fut) {
        this.operationFuture = fut;
    }

    public void setPausedQuery(boolean pausedQuery) {
        this.pausedQuery = pausedQuery;
    }

    public void setQueryType(short type) {
        this.queryType = type;
    }

    public void setRnd(Rnd rnd) {
        this.rnd = rnd;
    }

    public void startExecutionTimer() {
        this.executeStartNanos = this.nanosecondClock.getTicks();
    }

    private static void putBooleanValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put(rec.getBool(col));
    }

    private static void putByteValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put(rec.getByte(col));
    }

    private static void putCharValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        char c = rec.getChar(col);
        if (c == '\u0000') {
            socket.put("\"\"");
        } else {
            socket.put('\"').putUtf8(c).put('\"');
        }
    }

    private static void putDateValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        long d = rec.getDate(col);
        if (d == Long.MIN_VALUE) {
            socket.put("null");
            return;
        }
        socket.put('\"').putISODateMillis(d).put('\"');
    }

    private static void putGeoHashStringByteValue(HttpChunkedResponseSocket socket, Record rec, int col, int bitFlags) {
        byte l = rec.getGeoByte(col);
        JsonQueryProcessorState.putGeoHashStringValue(socket, l, bitFlags);
    }

    private static void putGeoHashStringIntValue(HttpChunkedResponseSocket socket, Record rec, int col, int bitFlags) {
        int l = rec.getGeoInt(col);
        JsonQueryProcessorState.putGeoHashStringValue(socket, l, bitFlags);
    }

    private static void putGeoHashStringLongValue(HttpChunkedResponseSocket socket, Record rec, int col, int bitFlags) {
        long l = rec.getGeoLong(col);
        JsonQueryProcessorState.putGeoHashStringValue(socket, l, bitFlags);
    }

    private static void putGeoHashStringShortValue(HttpChunkedResponseSocket socket, Record rec, int col, int bitFlags) {
        short l = rec.getGeoShort(col);
        JsonQueryProcessorState.putGeoHashStringValue(socket, l, bitFlags);
    }

    private static void putGeoHashStringValue(HttpChunkedResponseSocket socket, long value, int bitFlags) {
        if (value == -1L) {
            socket.put("null");
        } else {
            socket.put('\"');
            if (bitFlags < 0) {
                GeoHashes.appendCharsUnsafe(value, -bitFlags, socket);
            } else {
                GeoHashes.appendBinaryStringUnsafe(value, bitFlags, socket);
            }
            socket.put('\"');
        }
    }

    private static void putIntValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        int i = rec.getInt(col);
        if (i == Integer.MIN_VALUE) {
            socket.put("null");
        } else {
            Numbers.append((CharSink)socket, i);
        }
    }

    private static void putLong256Value(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put('\"');
        rec.getLong256(col, socket);
        socket.put('\"');
    }

    private static void putLongValue(HttpChunkedResponseSocket socket, Record rec, int col, boolean quoteLargeNum) {
        long l = rec.getLong(col);
        if (l == Long.MIN_VALUE) {
            socket.put("null");
        } else if (quoteLargeNum) {
            socket.put('\"').put(l).put('\"');
        } else {
            socket.put(l);
        }
    }

    private static void putRecValue(HttpChunkedResponseSocket socket) {
        JsonQueryProcessorState.putStringOrNull(socket, null);
    }

    private static void putShortValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put(rec.getShort(col));
    }

    private static void putStrValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putStringOrNull(socket, rec.getStr(col));
    }

    private static void putStringOrNull(CharSink r, CharSequence str) {
        if (str == null) {
            r.put("null");
        } else {
            r.encodeUtf8AndQuote(str);
        }
    }

    private static void putSymValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putStringOrNull(socket, rec.getSym(col));
    }

    private static void putTimestampValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        long t = rec.getTimestamp(col);
        if (t == Long.MIN_VALUE) {
            socket.put("null");
            return;
        }
        socket.put('\"').putISODate(t).put('\"');
    }

    private static void putUuidValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        long hi;
        long lo = rec.getLong128Lo(col);
        if (Uuid.isNull(lo, hi = rec.getLong128Hi(col))) {
            socket.put("null");
            return;
        }
        socket.put('\"');
        Numbers.appendUuid(lo, hi, socket);
        socket.put('\"');
    }

    private boolean addColumnToOutput(RecordMetadata metadata, CharSequence columnNames, int start, int hi) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (start == hi) {
            this.info().$("empty column in list '").$(columnNames).$('\'').$();
            HttpChunkedResponseSocket socket = this.getHttpConnectionContext().getChunkedResponseSocket();
            JsonQueryProcessor.header(socket, "", 400);
            socket.put('{').putQuoted("query").put(':').encodeUtf8AndQuote(this.query).put(',').putQuoted("error").put(':').putQuoted("empty column in list").put('}');
            socket.sendChunk(true);
            return true;
        }
        int columnIndex = metadata.getColumnIndexQuiet(columnNames, start, hi);
        if (columnIndex == -1) {
            this.info().$("invalid column in list: '").$(columnNames, start, hi).$('\'').$();
            HttpChunkedResponseSocket socket = this.getHttpConnectionContext().getChunkedResponseSocket();
            JsonQueryProcessor.header(socket, "", 400);
            socket.put('{').putQuoted("query").put(':').encodeUtf8AndQuote(this.query).put(',').putQuoted("error").put(':').put('\'').put("invalid column in list: ").put(columnNames, start, hi).put('\'').put('}');
            socket.sendChunk(true);
            return true;
        }
        this.addColumnTypeAndName(metadata, columnIndex);
        this.columnSkewList.add(columnIndex);
        return false;
    }

    private void addColumnTypeAndName(RecordMetadata metadata, int i) {
        int columnType = metadata.getColumnType(i);
        int flags = GeoHashes.getBitFlags(columnType);
        this.columnTypesAndFlags.add(columnType);
        this.columnTypesAndFlags.add(flags);
        this.columnNames.add(metadata.getColumnName(i));
    }

    private void doFirstRecordLoop(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.onQuerySetupFirstRecord()) {
            this.doRecordFetchLoop(socket, columnCount);
        } else {
            this.doQuerySuffix(socket, columnCount);
        }
    }

    private void doNextRecordLoop(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.doQueryNextRecord()) {
            this.doRecordFetchLoop(socket, columnCount);
        } else {
            this.doQuerySuffix(socket, columnCount);
        }
    }

    private void doQueryMetadata(HttpChunkedResponseSocket socket, int columnCount) {
        this.queryState = 2;
        while (this.columnIndex < columnCount) {
            socket.bookmark();
            if (this.columnIndex > 0) {
                socket.put(',');
            }
            int columnType = this.columnTypesAndFlags.getQuick(2 * this.columnIndex);
            socket.put('{').putQuoted("name").put(':').encodeUtf8AndQuote(this.columnNames.getQuick(this.columnIndex)).put(',').putQuoted("type").put(':').putQuoted(ColumnType.nameOf(columnType == 29 ? 11 : columnType)).put('}');
            ++this.columnIndex;
        }
    }

    private void doQueryMetadataSuffix(HttpChunkedResponseSocket socket) {
        this.queryState = 3;
        socket.bookmark();
        socket.put("],\"dataset\":[");
    }

    private boolean doQueryNextRecord() {
        if (this.cursor.hasNext()) {
            if (this.count < this.stop) {
                return true;
            }
            this.onNoMoreData();
        }
        return false;
    }

    private boolean doQueryPrefix(HttpChunkedResponseSocket socket) {
        if (this.noMeta) {
            socket.bookmark();
            socket.put('{').putQuoted("dataset").put(":[");
            return false;
        }
        socket.bookmark();
        socket.put('{').putQuoted("query").put(':').encodeUtf8AndQuote(this.query).put(',').putQuoted("columns").put(':').put('[');
        this.columnIndex = 0;
        return true;
    }

    private void doQueryRecord(HttpChunkedResponseSocket socket, int columnCount) {
        this.queryState = 5;
        while (this.columnIndex < columnCount) {
            socket.bookmark();
            if (this.columnIndex > 0) {
                socket.put(',');
            }
            int columnIdx = this.columnSkewList.size() > 0 ? this.columnSkewList.getQuick(this.columnIndex) : this.columnIndex;
            int columnType = this.columnTypesAndFlags.getQuick(2 * this.columnIndex);
            switch (ColumnType.tagOf(columnType)) {
                case 1: {
                    JsonQueryProcessorState.putBooleanValue(socket, this.record, columnIdx);
                    break;
                }
                case 2: {
                    JsonQueryProcessorState.putByteValue(socket, this.record, columnIdx);
                    break;
                }
                case 10: {
                    this.putDoubleValue(socket, this.record, columnIdx);
                    break;
                }
                case 9: {
                    this.putFloatValue(socket, this.record, columnIdx);
                    break;
                }
                case 5: {
                    JsonQueryProcessorState.putIntValue(socket, this.record, columnIdx);
                    break;
                }
                case 6: {
                    JsonQueryProcessorState.putLongValue(socket, this.record, columnIdx, this.quoteLargeNum);
                    break;
                }
                case 7: {
                    JsonQueryProcessorState.putDateValue(socket, this.record, columnIdx);
                    break;
                }
                case 8: {
                    JsonQueryProcessorState.putTimestampValue(socket, this.record, columnIdx);
                    break;
                }
                case 3: {
                    JsonQueryProcessorState.putShortValue(socket, this.record, columnIdx);
                    break;
                }
                case 4: {
                    JsonQueryProcessorState.putCharValue(socket, this.record, columnIdx);
                    break;
                }
                case 11: {
                    JsonQueryProcessorState.putStrValue(socket, this.record, columnIdx);
                    break;
                }
                case 12: {
                    JsonQueryProcessorState.putSymValue(socket, this.record, columnIdx);
                    break;
                }
                case 18: {
                    this.putBinValue(socket);
                    break;
                }
                case 13: {
                    JsonQueryProcessorState.putLong256Value(socket, this.record, columnIdx);
                    break;
                }
                case 14: {
                    JsonQueryProcessorState.putGeoHashStringByteValue(socket, this.record, columnIdx, this.columnTypesAndFlags.getQuick(2 * this.columnIndex + 1));
                    break;
                }
                case 15: {
                    JsonQueryProcessorState.putGeoHashStringShortValue(socket, this.record, columnIdx, this.columnTypesAndFlags.getQuick(2 * this.columnIndex + 1));
                    break;
                }
                case 16: {
                    JsonQueryProcessorState.putGeoHashStringIntValue(socket, this.record, columnIdx, this.columnTypesAndFlags.getQuick(2 * this.columnIndex + 1));
                    break;
                }
                case 17: {
                    JsonQueryProcessorState.putGeoHashStringLongValue(socket, this.record, columnIdx, this.columnTypesAndFlags.getQuick(2 * this.columnIndex + 1));
                    break;
                }
                case 22: {
                    JsonQueryProcessorState.putRecValue(socket);
                    break;
                }
                case 29: {
                    socket.put("null");
                    break;
                }
                case 24: {
                    throw new UnsupportedOperationException();
                }
                case 19: {
                    JsonQueryProcessorState.putUuidValue(socket, this.record, columnIdx);
                    break;
                }
                default: {
                    assert (false) : "Not supported type in output " + ColumnType.nameOf(columnType);
                    socket.put("null");
                }
            }
            ++this.columnIndex;
        }
    }

    private void doQueryRecordPrefix(HttpChunkedResponseSocket socket) {
        this.queryState = 9;
        socket.bookmark();
        if (this.count > this.skip) {
            socket.put(',');
        }
        socket.put('[');
        this.columnIndex = 0;
        ++this.count;
    }

    private void doQueryRecordSuffix(HttpChunkedResponseSocket socket) {
        this.queryState = 6;
        socket.bookmark();
        socket.put(']');
    }

    private void doQuerySuffix(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.queryState = 7;
        if (this.count > -1L) {
            this.logTimings();
            socket.bookmark();
            socket.put(']');
            socket.put(',').putQuoted("timestamp").put(':').put(this.queryTimestampIndex);
            socket.put(',').putQuoted("count").put(':').put(this.count);
            if (this.timings) {
                socket.put(',').putQuoted("timings").put(':').put('{').putQuoted("compiler").put(':').put(this.compilerNanos).put(',').putQuoted("execute").put(':').put(this.nanosecondClock.getTicks() - this.executeStartNanos).put(',').putQuoted("count").put(':').put(this.recordCountNanos).put('}');
            }
            if (this.explain) {
                socket.put(',').putQuoted("explain").put(':').put('{').putQuoted("jitCompiled").put(':').put(this.queryJitCompiled ? "true" : "false").put('}');
            }
            socket.put('}');
            this.count = -1L;
            socket.sendChunk(true);
            return;
        }
        socket.done();
    }

    private void doRecordFetchLoop(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        do {
            this.doQueryRecordPrefix(socket);
            this.doQueryRecord(socket, columnCount);
            this.doQueryRecordSuffix(socket);
        } while (this.doQueryNextRecord());
        this.doQuerySuffix(socket, columnCount);
    }

    private int getFd() {
        return this.httpConnectionContext.getFd();
    }

    private void onNoMoreData() {
        long nanos = this.nanosecondClock.getTicks();
        if (this.countRows) {
            RecordCursor cursor = this.cursor;
            long size = cursor.size();
            if (size < 0L) {
                LOG.info().$("counting").$();
                long count = 1L;
                while (cursor.hasNext()) {
                    ++count;
                }
                this.count += count;
            } else {
                this.count = size;
            }
        }
        this.recordCountNanos = this.nanosecondClock.getTicks() - nanos;
    }

    private void onQueryMetadata(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryMetadata(socket, columnCount);
        this.onQueryMetadataSuffix(socket, columnCount);
    }

    private void onQueryMetadataSuffix(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryMetadataSuffix(socket);
        this.doFirstRecordLoop(socket, columnCount);
    }

    private void onQueryPrefix(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.doQueryPrefix(socket)) {
            this.doQueryMetadata(socket, columnCount);
            this.doQueryMetadataSuffix(socket);
        }
        this.doFirstRecordLoop(socket, columnCount);
    }

    private void onQueryRecord(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryRecord(socket, columnCount);
        this.onQueryRecordSuffix(socket, columnCount);
    }

    private void onQueryRecordPrefix(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryRecordPrefix(socket);
        this.onQueryRecord(socket, columnCount);
    }

    private void onQueryRecordSuffix(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryRecordSuffix(socket);
        this.doNextRecordLoop(socket, columnCount);
    }

    private boolean onQuerySetupFirstRecord() {
        if (this.skip > 0L) {
            long target;
            RecordCursor cursor = this.cursor;
            for (target = this.skip + 1L; target > 0L && cursor.hasNext(); --target) {
            }
            if (target > 0L) {
                return false;
            }
            this.count = this.skip;
        } else if (!this.cursor.hasNext()) {
            return false;
        }
        this.columnIndex = 0;
        this.record = this.cursor.getRecord();
        return true;
    }

    private void putBinValue(HttpChunkedResponseSocket socket) {
        socket.put('[');
        socket.put(']');
    }

    private void putDoubleValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put(rec.getDouble(col), this.doubleScale);
    }

    private void putFloatValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put(rec.getFloat(col), this.floatScale);
    }

    static void prepareExceptionJson(HttpChunkedResponseSocket socket, int position, CharSequence message, CharSequence query) throws PeerDisconnectedException, PeerIsSlowToReadException {
        socket.put('{').putQuoted("query").put(':').encodeUtf8AndQuote(query == null ? "" : query).put(',').putQuoted("error").put(':').encodeUtf8AndQuote(message).put(',').putQuoted("position").put(':').put(position).put('}');
        socket.sendChunk(true);
    }

    boolean noCursor() {
        return this.cursor == null;
    }

    boolean of(RecordCursorFactory factory, SqlExecutionContextImpl sqlExecutionContext) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        return this.of(factory, true, sqlExecutionContext);
    }

    boolean of(RecordCursorFactory factory, boolean queryCacheable, SqlExecutionContextImpl sqlExecutionContext) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        int columnCount;
        this.recordCursorFactory = factory;
        this.queryCacheable = queryCacheable;
        this.queryJitCompiled = factory.usesCompiledFilter();
        sqlExecutionContext.setColumnPreTouchEnabled(this.stop == Long.MAX_VALUE);
        this.cursor = factory.getCursor(sqlExecutionContext);
        RecordMetadata metadata = factory.getMetadata();
        this.queryTimestampIndex = metadata.getTimestampIndex();
        HttpRequestHeader header = this.httpConnectionContext.getRequestHeader();
        DirectByteCharSequence columnNames = header.getUrlParam("cols");
        this.columnSkewList.clear();
        if (columnNames != null) {
            this.columnsQueryParameter.clear();
            try {
                TextUtil.utf8ToUtf16(columnNames.getLo(), columnNames.getHi(), this.columnsQueryParameter);
            }
            catch (Utf8Exception e) {
                this.info().$("utf8 error when decoding column list '").$(columnNames).$('\'').$();
                HttpChunkedResponseSocket socket = this.getHttpConnectionContext().getChunkedResponseSocket();
                JsonQueryProcessor.header(socket, "", 400);
                socket.put('{').putQuoted("error").put(':').putQuoted("utf8 error in column list").put('}');
                socket.sendChunk(true);
                return false;
            }
            columnCount = 1;
            int start = 0;
            int comma = 0;
            while (comma > -1) {
                comma = Chars.indexOf(this.columnsQueryParameter, start, ',');
                if (comma > -1) {
                    if (this.addColumnToOutput(metadata, this.columnsQueryParameter, start, comma)) {
                        return false;
                    }
                    start = comma + 1;
                    ++columnCount;
                    continue;
                }
                int hi = this.columnsQueryParameter.length();
                if (!this.addColumnToOutput(metadata, this.columnsQueryParameter, start, hi)) continue;
                return false;
            }
        } else {
            columnCount = metadata.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                this.addColumnTypeAndName(metadata, i);
            }
        }
        this.columnCount = columnCount;
        return true;
    }

    void resume(HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.resumeActions.getQuick(this.queryState).onResume(socket, this.columnCount);
    }

    void setQueryCacheable(boolean queryCacheable) {
        this.queryCacheable = queryCacheable;
    }

    @FunctionalInterface
    static interface StateResumeAction {
        public void onResume(HttpChunkedResponseSocket var1, int var2) throws PeerDisconnectedException, PeerIsSlowToReadException;
    }
}

