/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.DefaultFactoryProvider;
import io.questdb.FactoryProvider;
import io.questdb.cutlass.http.DefaultHttpContextConfiguration;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.MimeTypesCache;
import io.questdb.cutlass.http.WaitProcessorConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.StaticContentProcessorConfiguration;
import io.questdb.network.DefaultIODispatcherConfiguration;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.datetime.millitime.MillisecondClockImpl;
import java.io.IOException;
import java.io.InputStream;

public class DefaultHttpServerConfiguration
implements HttpServerConfiguration {
    protected final MimeTypesCache mimeTypesCache;
    private final IODispatcherConfiguration dispatcherConfiguration;
    private final HttpContextConfiguration httpContextConfiguration;
    private final JsonQueryProcessorConfiguration jsonQueryProcessorConfiguration = new JsonQueryProcessorConfiguration(){

        @Override
        public MillisecondClock getClock() {
            return DefaultHttpServerConfiguration.this.httpContextConfiguration.getClock();
        }

        @Override
        public int getConnectionCheckFrequency() {
            return 1000000;
        }

        @Override
        public int getDoubleScale() {
            return 19;
        }

        @Override
        public FactoryProvider getFactoryProvider() {
            return DefaultFactoryProvider.INSTANCE;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public int getFloatScale() {
            return 10;
        }

        @Override
        public CharSequence getKeepAliveHeader() {
            return "Keep-Alive: timeout=5, max=10000\r\n";
        }

        @Override
        public long getMaxQueryResponseRowLimit() {
            return Long.MAX_VALUE;
        }
    };
    private final StaticContentProcessorConfiguration staticContentProcessorConfiguration = new StaticContentProcessorConfiguration(){

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public CharSequence getIndexFileName() {
            return "index.html";
        }

        @Override
        public String getKeepAliveHeader() {
            return null;
        }

        @Override
        public MimeTypesCache getMimeTypesCache() {
            return DefaultHttpServerConfiguration.this.mimeTypesCache;
        }

        @Override
        public CharSequence getPublicDirectory() {
            return ".";
        }

        @Override
        public boolean isAuthenticationRequired() {
            return true;
        }
    };

    public DefaultHttpServerConfiguration() {
        this(new DefaultHttpContextConfiguration());
    }

    public DefaultHttpServerConfiguration(HttpContextConfiguration httpContextConfiguration) {
        this(httpContextConfiguration, new DefaultIODispatcherConfiguration());
    }

    public DefaultHttpServerConfiguration(HttpContextConfiguration httpContextConfiguration, IODispatcherConfiguration dispatcherConfiguration) {
        try (InputStream inputStream = DefaultHttpServerConfiguration.class.getResourceAsStream("/io/questdb/site/conf/mime.types");){
            this.mimeTypesCache = new MimeTypesCache(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.httpContextConfiguration = httpContextConfiguration;
        this.dispatcherConfiguration = dispatcherConfiguration;
    }

    @Override
    public IODispatcherConfiguration getDispatcherConfiguration() {
        return this.dispatcherConfiguration;
    }

    @Override
    public HttpContextConfiguration getHttpContextConfiguration() {
        return this.httpContextConfiguration;
    }

    @Override
    public JsonQueryProcessorConfiguration getJsonQueryProcessorConfiguration() {
        return this.jsonQueryProcessorConfiguration;
    }

    @Override
    public String getPoolName() {
        return "http";
    }

    @Override
    public int getQueryCacheBlockCount() {
        return 4;
    }

    @Override
    public int getQueryCacheRowCount() {
        return 4;
    }

    @Override
    public StaticContentProcessorConfiguration getStaticContentProcessorConfiguration() {
        return this.staticContentProcessorConfiguration;
    }

    @Override
    public WaitProcessorConfiguration getWaitProcessorConfiguration() {
        return new WaitProcessorConfiguration(){

            @Override
            public MillisecondClock getClock() {
                return MillisecondClockImpl.INSTANCE;
            }

            @Override
            public double getExponentialWaitMultiplier() {
                return 2.0;
            }

            @Override
            public int getInitialWaitQueueSize() {
                return 64;
            }

            @Override
            public int getMaxProcessingQueueSize() {
                return 4096;
            }

            @Override
            public long getMaxWaitCapMs() {
                return 1000L;
            }
        };
    }

    @Override
    public int getWorkerCount() {
        return 2;
    }

    @Override
    public boolean isHealthCheckAuthenticationRequired() {
        return true;
    }

    @Override
    public boolean isPessimisticHealthCheckEnabled() {
        return false;
    }

    @Override
    public boolean isQueryCacheEnabled() {
        return true;
    }
}

