/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass;

import io.questdb.Metrics;
import io.questdb.WorkerPoolManager;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.HttpMinServerConfiguration;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpRequestProcessorFactory;
import io.questdb.cutlass.http.HttpServer;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.processors.HealthCheckProcessor;
import io.questdb.cutlass.http.processors.JsonQueryProcessor;
import io.questdb.cutlass.http.processors.PrometheusMetricsProcessor;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.cutlass.line.tcp.LineTcpReceiver;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.udp.AbstractLineProtoUdpReceiver;
import io.questdb.cutlass.line.udp.LineUdpReceiver;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.cutlass.line.udp.LinuxMMLineUdpReceiver;
import io.questdb.cutlass.pgwire.CircuitBreakerRegistry;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.pgwire.PGWireServer;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.mp.WorkerPool;
import io.questdb.std.Os;
import org.jetbrains.annotations.Nullable;

public final class Services {
    private Services() {
        throw new UnsupportedOperationException("not instantiatable");
    }

    @Nullable
    public static HttpServer createHttpServer(HttpServerConfiguration configuration, CairoEngine cairoEngine, WorkerPoolManager workerPoolManager, @Nullable FunctionFactoryCache functionFactoryCache, @Nullable DatabaseSnapshotAgent snapshotAgent, Metrics metrics) {
        if (!configuration.isEnabled()) {
            return null;
        }
        return Services.createHttpServer(configuration, cairoEngine, workerPoolManager.getInstance(configuration, metrics.health(), WorkerPoolManager.Requester.HTTP_SERVER), workerPoolManager.getSharedWorkerCount(), functionFactoryCache, snapshotAgent, metrics);
    }

    @Nullable
    public static HttpServer createHttpServer(HttpServerConfiguration configuration, CairoEngine cairoEngine, WorkerPool workerPool, int sharedWorkerCount, @Nullable FunctionFactoryCache functionFactoryCache, @Nullable DatabaseSnapshotAgent snapshotAgent, Metrics metrics) {
        if (!configuration.isEnabled()) {
            return null;
        }
        HttpServer server = new HttpServer(configuration, cairoEngine.getMessageBus(), metrics, workerPool);
        QueryCache.configure(configuration, metrics);
        HttpServer.HttpRequestProcessorBuilder jsonQueryProcessorBuilder = () -> new JsonQueryProcessor(configuration.getJsonQueryProcessorConfiguration(), cairoEngine, workerPool.getWorkerCount(), sharedWorkerCount, functionFactoryCache, snapshotAgent);
        HttpServer.addDefaultEndpoints(server, configuration, cairoEngine, workerPool, sharedWorkerCount, jsonQueryProcessorBuilder, functionFactoryCache, snapshotAgent);
        return server;
    }

    @Nullable
    public static LineTcpReceiver createLineTcpReceiver(LineTcpReceiverConfiguration config, CairoEngine cairoEngine, WorkerPoolManager workerPoolManager, Metrics metrics) {
        if (!config.isEnabled()) {
            return null;
        }
        WorkerPool ioPool = workerPoolManager.getInstance(config.getIOWorkerPoolConfiguration(), metrics.health(), WorkerPoolManager.Requester.LINE_TCP_IO);
        WorkerPool writerPool = workerPoolManager.getInstance(config.getWriterWorkerPoolConfiguration(), metrics.health(), WorkerPoolManager.Requester.LINE_TCP_WRITER);
        return new LineTcpReceiver(config, cairoEngine, ioPool, writerPool);
    }

    @Nullable
    public static AbstractLineProtoUdpReceiver createLineUdpReceiver(LineUdpReceiverConfiguration config, CairoEngine cairoEngine, WorkerPoolManager workerPoolManager) {
        if (!config.isEnabled()) {
            return null;
        }
        if (Os.isLinux()) {
            return new LinuxMMLineUdpReceiver(config, cairoEngine, workerPoolManager.getSharedPool());
        }
        return new LineUdpReceiver(config, cairoEngine, workerPoolManager.getSharedPool());
    }

    @Nullable
    public static HttpServer createMinHttpServer(HttpMinServerConfiguration configuration, CairoEngine cairoEngine, WorkerPoolManager workerPoolManager, Metrics metrics) {
        if (!configuration.isEnabled()) {
            return null;
        }
        WorkerPool workerPool = workerPoolManager.getInstance(configuration, metrics.health(), WorkerPoolManager.Requester.HTTP_MIN_SERVER);
        return Services.createMinHttpServer(configuration, cairoEngine, workerPool, metrics);
    }

    @Nullable
    public static HttpServer createMinHttpServer(final HttpMinServerConfiguration configuration, CairoEngine cairoEngine, WorkerPool workerPool, final Metrics metrics) {
        if (!configuration.isEnabled()) {
            return null;
        }
        HttpServer server = new HttpServer(configuration, cairoEngine.getMessageBus(), metrics, workerPool);
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public String getUrl() {
                return metrics.isEnabled() ? "/status" : "*";
            }

            @Override
            public HttpRequestProcessor newInstance() {
                return new HealthCheckProcessor(configuration);
            }
        }, true);
        if (metrics.isEnabled()) {
            server.bind(new HttpRequestProcessorFactory(){

                @Override
                public String getUrl() {
                    return "/metrics";
                }

                @Override
                public HttpRequestProcessor newInstance() {
                    return new PrometheusMetricsProcessor(metrics, configuration);
                }
            });
        }
        return server;
    }

    @Nullable
    public static PGWireServer createPGWireServer(PGWireConfiguration configuration, CairoEngine cairoEngine, WorkerPoolManager workerPoolManager, FunctionFactoryCache functionFactoryCache, DatabaseSnapshotAgent snapshotAgent, Metrics metrics) {
        if (!configuration.isEnabled()) {
            return null;
        }
        WorkerPool workerPool = workerPoolManager.getInstance(configuration, metrics.health(), WorkerPoolManager.Requester.PG_WIRE_SERVER);
        CircuitBreakerRegistry registry = new CircuitBreakerRegistry(configuration, cairoEngine.getConfiguration());
        return new PGWireServer(configuration, cairoEngine, workerPool, functionFactoryCache, snapshotAgent, new PGWireServer.PGConnectionContextFactory(cairoEngine, configuration, registry, () -> new SqlExecutionContextImpl(cairoEngine, workerPool.getWorkerCount(), workerPoolManager.getSharedWorkerCount())), registry);
    }
}

