/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableDescriptor;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;

public class SequencerMetadata
extends AbstractRecordMetadata
implements TableRecordMetadata,
Closeable,
TableDescriptor {
    private final FilesFacade ff;
    private final MemoryMARW metaMem;
    private final boolean readonly;
    private final MemoryMR roMetaMem;
    private final AtomicLong structureVersion = new AtomicLong(-1L);
    private volatile boolean suspended;
    private int tableId;
    private TableToken tableToken;

    public SequencerMetadata(FilesFacade ff) {
        this(ff, false);
    }

    public SequencerMetadata(FilesFacade ff, boolean readonly) {
        this.ff = ff;
        this.readonly = readonly;
        if (!readonly) {
            this.metaMem = Vm.getMARWInstance();
            this.roMetaMem = this.metaMem;
        } else {
            this.metaMem = null;
            this.roMetaMem = Vm.getMRInstance();
        }
    }

    public void addColumn(CharSequence columnName, int columnType) {
        this.addColumn0(columnName, columnType);
        this.structureVersion.incrementAndGet();
    }

    @Override
    public void close() {
        this.reset();
        if (this.metaMem != null) {
            this.metaMem.close(false);
        }
        Misc.free(this.roMetaMem);
    }

    public void copyFrom(TableDescriptor model, TableToken tableToken, int tableId, long structureVersion, boolean suspended) {
        this.reset();
        this.tableToken = tableToken;
        this.timestampIndex = model.getTimestampIndex();
        this.tableId = tableId;
        this.suspended = suspended;
        int n = model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            CharSequence name = model.getColumnName(i);
            int type = model.getColumnType(i);
            this.addColumn0(name, type);
        }
        this.structureVersion.set(structureVersion);
        this.columnCount = this.columnMetadata.size();
    }

    public void create(TableDescriptor model, TableToken tableToken, Path path, int pathLen, int tableId) {
        this.copyFrom(model, tableToken, tableId, 0L, false);
        this.switchTo(path, pathLen);
    }

    public void dropTable() {
        this.structureVersion.set(-2L);
        this.syncToMetaFile();
    }

    @Override
    public long getMetadataVersion() {
        return this.structureVersion.get();
    }

    public int getRealColumnCount() {
        return this.columnNameIndexMap.size();
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    public boolean isDropped() {
        return this.structureVersion.get() == -2L;
    }

    @Override
    public boolean isWalEnabled() {
        return true;
    }

    public void open(Path path, int pathLen) {
        this.reset();
        TableUtils.openSmallFile(this.ff, path, pathLen, this.roMetaMem, "_meta", 38);
        if (!this.readonly) {
            this.metaMem.jumpTo(4L);
            int size = this.metaMem.getInt(0L);
            this.metaMem.jumpTo(size);
        }
        this.loadSequencerMetadata(this.roMetaMem);
        this.structureVersion.set(this.roMetaMem.getLong(8L));
        this.columnCount = this.columnMetadata.size();
        this.timestampIndex = this.roMetaMem.getInt(20L);
        this.tableId = this.roMetaMem.getInt(24L);
        this.suspended = this.roMetaMem.getBool(28L);
        if (this.readonly) {
            this.roMetaMem.close();
        }
    }

    public void removeColumn(CharSequence columnName) {
        TableUtils.removeColumnFromMetadata(columnName, this.columnNameIndexMap, this.columnMetadata);
        this.structureVersion.incrementAndGet();
    }

    public void renameColumn(CharSequence columnName, CharSequence newName) {
        TableUtils.renameColumnInMetadata(columnName, newName, this.columnNameIndexMap, this.columnMetadata);
        this.structureVersion.incrementAndGet();
    }

    public void switchTo(Path path, int pathLen) {
        assert (this.metaMem.getFd() == -1);
        TableUtils.openSmallFile(this.ff, path, pathLen, this.metaMem, "_meta", 38);
        this.syncToMetaFile();
    }

    public void syncToDisk() {
        this.metaMem.sync(false);
    }

    public void updateTableToken(TableToken newTableToken) {
        this.tableToken = newTableToken;
    }

    private void addColumn0(CharSequence columnName, int columnType) {
        String name = columnName.toString();
        if (columnType > 0) {
            this.columnNameIndexMap.put(name, this.columnMetadata.size());
        }
        this.columnMetadata.add(new TableColumnMetadata(name, columnType, false, 0, false, null, this.columnMetadata.size()));
        ++this.columnCount;
    }

    private void loadSequencerMetadata(MemoryMR metaMem) {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        try {
            int timestampType;
            long memSize = TableUtils.checkMemSize(metaMem, 29L);
            TableUtils.validateMetaVersion(metaMem, 4L, 0);
            int columnCount = TableUtils.getColumnCount(metaMem, 16L);
            int timestampIndex = TableUtils.getTimestampIndex(metaMem, 20L, columnCount);
            long offset = 29L;
            for (int i = 0; i < columnCount; ++i) {
                int type = TableUtils.getColumnType(metaMem, memSize, offset, i);
                String name = TableUtils.getColumnName(metaMem, memSize, offset += 4L, i).toString();
                offset += (long)Vm.getStorageLength(name);
                if (type > 0) {
                    this.columnNameIndexMap.put(name, i);
                }
                if (ColumnType.isSymbol(Math.abs(type))) {
                    this.columnMetadata.add(new TableColumnMetadata(name, type, true, 1024, true, null));
                    continue;
                }
                this.columnMetadata.add(new TableColumnMetadata(name, type));
            }
            if (timestampIndex != -1 && !ColumnType.isTimestamp(timestampType = ((TableColumnMetadata)this.columnMetadata.getQuick(timestampIndex)).getType())) {
                throw TableUtils.validationException(metaMem).put("Timestamp column must be TIMESTAMP, but found ").put(ColumnType.nameOf(timestampType));
            }
        }
        catch (Throwable e) {
            this.columnNameIndexMap.clear();
            this.columnMetadata.clear();
            throw e;
        }
    }

    private void reset() {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        this.columnCount = 0;
        this.timestampIndex = -1;
        this.tableToken = null;
        this.tableId = -1;
        this.suspended = false;
    }

    boolean isSuspended() {
        return this.suspended;
    }

    void resumeTable() {
        this.suspended = false;
        this.syncToMetaFile();
    }

    void suspendTable() {
        this.suspended = true;
        this.syncToMetaFile();
    }

    void syncToMetaFile() {
        this.metaMem.jumpTo(0L);
        this.metaMem.putInt(0);
        this.metaMem.putInt(0);
        this.metaMem.putLong(this.structureVersion.get());
        this.metaMem.putInt(this.columnCount);
        this.metaMem.putInt(this.timestampIndex);
        this.metaMem.putInt(this.tableId);
        this.metaMem.putBool(this.suspended);
        for (int i = 0; i < this.columnCount; ++i) {
            int columnType = this.getColumnType(i);
            this.metaMem.putInt(columnType);
            this.metaMem.putStr(this.getColumnName(i));
        }
        this.metaMem.putInt(0L, (int)this.metaMem.getAppendOffset());
        this.metaMem.sync(false);
    }
}

