/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.cairo.wal.WalEventReader;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.str.Path;

public class WalTxnDetails {
    public static final long FORCE_FULL_COMMIT = Long.MAX_VALUE;
    public static final long LAST_ROW_COMMIT = 0x7FFFFFFFFFFFFFFEL;
    public static final int TXN_METADATA_LONGS_SIZE = 3;
    private static final int MAX_TIMESTAMP_OFFSET = 2;
    private static final int MIN_TIMESTAMP_OFFSET = 1;
    private final LongList transactionMeta = new LongList();
    private final WalEventReader walEventReader;
    private long startSeqTxn = 0L;

    public WalTxnDetails(FilesFacade ff) {
        this.walEventReader = new WalEventReader(ff);
    }

    public long getCommitToTimestamp(long seqTxn) {
        long value = this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 3L));
        return value == 0x7FFFFFFFFFFFFFFEL ? Long.MAX_VALUE : value;
    }

    public long getFullyCommittedTxn(long fromSeqTxn, long toSeqTxn, long maxCommittedTimestamp) {
        for (long seqTxn = fromSeqTxn + 1L; seqTxn <= toSeqTxn; ++seqTxn) {
            long maxTimestamp = this.getCommitMaxTimestamp(seqTxn);
            if (maxTimestamp <= maxCommittedTimestamp) continue;
            return seqTxn - 1L;
        }
        return toSeqTxn;
    }

    public long getLastSeqTxn() {
        return this.startSeqTxn + (long)(this.transactionMeta.size() / 3) - 1L;
    }

    public boolean hasRecord(long seqTxn) {
        return (seqTxn - this.startSeqTxn) * 3L < (long)this.transactionMeta.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readObservableTxnMeta(Path tempPath, TransactionLogCursor transactionLogCursor, int rootLen, long committedSeqTxn, long maxCommittedTimestamp) {
        int i;
        if (committedSeqTxn <= this.getLastSeqTxn()) {
            int shift = (int)(committedSeqTxn - this.startSeqTxn + 1L);
            this.transactionMeta.removeIndexBlock(0, shift * 3);
            this.startSeqTxn = committedSeqTxn + 1L;
            if (this.transactionMeta.size() > 0) {
                this.transactionMeta.set(0, -1L);
            }
        } else {
            this.transactionMeta.clear();
            this.startSeqTxn = -1L;
        }
        try (WalEventReader eventReader = this.walEventReader;){
            int prevWalId = Integer.MIN_VALUE;
            int prevSegmentId = Integer.MIN_VALUE;
            int prevSegmentTxn = Integer.MIN_VALUE;
            WalEventCursor walEventCursor = null;
            long runningMaxTimestamp = maxCommittedTimestamp;
            while (transactionLogCursor.hasNext()) {
                int walId = transactionLogCursor.getWalId();
                int segmentId = transactionLogCursor.getSegmentId();
                int segmentTxn = transactionLogCursor.getSegmentTxn();
                if (this.startSeqTxn == -1L) {
                    this.startSeqTxn = transactionLogCursor.getTxn();
                }
                assert (this.startSeqTxn + (long)(this.transactionMeta.size() / 3) == transactionLogCursor.getTxn());
                if (walId > 0) {
                    tempPath.trimTo(rootLen).concat("wal").put(walId).slash().put(segmentId);
                    if (prevWalId != walId || prevSegmentId != segmentId || prevSegmentTxn + 1 != segmentTxn) {
                        walEventCursor = eventReader.of(tempPath, 0, segmentTxn);
                        prevWalId = walId;
                        prevSegmentId = segmentId;
                        prevSegmentTxn = segmentTxn;
                    } else if (!walEventCursor.hasNext()) {
                        walEventCursor = eventReader.of(tempPath, 0, segmentTxn);
                    }
                    byte walTxnType = walEventCursor.getType();
                    if (walTxnType == 0) {
                        WalEventCursor.DataInfo commitInfo = walEventCursor.getDataInfo();
                        this.transactionMeta.add(-1L);
                        this.transactionMeta.add(commitInfo.getMinTimestamp());
                        this.transactionMeta.add(commitInfo.getMaxTimestamp());
                        runningMaxTimestamp = Math.max(commitInfo.getMaxTimestamp(), runningMaxTimestamp);
                        continue;
                    }
                }
                this.transactionMeta.add(Long.MAX_VALUE);
                this.transactionMeta.add(runningMaxTimestamp);
                this.transactionMeta.add(runningMaxTimestamp);
            }
        }
        finally {
            tempPath.trimTo(rootLen);
        }
        long runningMinTimestamp = 0x7FFFFFFFFFFFFFFEL;
        for (i = this.transactionMeta.size() - 3; i > -1; i -= 3) {
            long commitToTimestamp = runningMinTimestamp;
            long currentMinTimestamp = this.transactionMeta.getQuick(i + 1);
            runningMinTimestamp = Math.min(runningMinTimestamp, currentMinTimestamp);
            if (this.transactionMeta.get(i) != Long.MAX_VALUE) {
                this.transactionMeta.set(i, commitToTimestamp);
                continue;
            }
            runningMinTimestamp = Long.MAX_VALUE;
        }
        int n = this.transactionMeta.size();
        for (i = 0; i < n; i += 3) {
            long commitToTimestamp = this.transactionMeta.get(i);
            if (commitToTimestamp >= maxCommittedTimestamp) continue;
            this.transactionMeta.set(i, Long.MIN_VALUE);
        }
    }

    private long getCommitMaxTimestamp(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 3L + 2L));
    }
}

