/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.metrics.Counter;
import io.questdb.metrics.LongGauge;
import io.questdb.metrics.MetricsRegistry;
import java.util.concurrent.atomic.AtomicLong;

public class WalMetrics {
    private final Counter applyPhysicallyWrittenRowsCounter;
    private final LongGauge applyRowsWriteRateGauge;
    private final Counter applyRowsWrittenCounter;
    private final Counter rowsWrittenCounter;
    private final AtomicLong totalRowsWritten = new AtomicLong();
    private final AtomicLong totalRowsWrittenTotalTime = new AtomicLong();

    public WalMetrics(MetricsRegistry metricsRegistry) {
        this.applyPhysicallyWrittenRowsCounter = metricsRegistry.newCounter("wal_apply_physically_written_rows");
        this.applyRowsWrittenCounter = metricsRegistry.newCounter("wal_apply_written_rows");
        this.applyRowsWriteRateGauge = metricsRegistry.newLongGauge("wal_apply_rows_per_second");
        this.rowsWrittenCounter = metricsRegistry.newCounter("wal_written_rows");
    }

    public void addApplyRowsWritten(long rows, long physicallyWrittenRows, long timeMicros) {
        this.applyRowsWrittenCounter.add(rows);
        this.applyPhysicallyWrittenRowsCounter.add(physicallyWrittenRows);
        long totalRows = this.totalRowsWritten.addAndGet(rows);
        long rowsAppendRate = totalRows * 1000000L / Math.max(1L, this.totalRowsWrittenTotalTime.addAndGet(timeMicros));
        this.applyRowsWriteRateGauge.setValue(rowsAppendRate);
    }

    public void addRowsWritten(long rows) {
        this.rowsWrittenCounter.add(rows);
    }
}

