/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoKeywords;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.wal.OperationCompiler;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.cairo.wal.WalEventReader;
import io.questdb.cairo.wal.WalMetrics;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Job;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntLongHashMap;
import io.questdb.std.Misc;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.tasks.TelemetryTask;
import io.questdb.tasks.TelemetryWalTask;
import io.questdb.tasks.WalTxnNotificationTask;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class ApplyWal2TableJob
extends AbstractQueueConsumerJob<WalTxnNotificationTask>
implements Closeable {
    public static final String WAL_2_TABLE_RESUME_REASON = "Resume WAL Data Application";
    private static final Log LOG = LogFactory.getLog(ApplyWal2TableJob.class);
    private static final String WAL_2_TABLE_WRITE_REASON = "WAL Data Application";
    private static final int WAL_APPLY_FAILED = -2;
    private static final int WAL_APPLY_IGNORE_ERROR = -1;
    private final CairoEngine engine;
    private final IntLongHashMap lastAppliedSeqTxns = new IntLongHashMap();
    private final int lookAheadTransactionCount;
    private final WalMetrics metrics;
    private final MicrosecondClock microClock;
    private final OperationCompiler operationCompiler;
    private final long tableTimeQuotaMicros;
    private final Telemetry<TelemetryTask> telemetry;
    private final TelemetryFacade telemetryFacade;
    private final WalEventReader walEventReader;
    private final Telemetry<TelemetryWalTask> walTelemetry;
    private final WalTelemetryFacade walTelemetryFacade;

    public ApplyWal2TableJob(CairoEngine engine, int workerCount, int sharedWorkerCount, @Nullable FunctionFactoryCache ffCache) {
        super(engine.getMessageBus().getWalTxnNotificationQueue(), engine.getMessageBus().getWalTxnNotificationSubSequence());
        this.engine = engine;
        this.walTelemetry = engine.getTelemetryWal();
        this.walTelemetryFacade = this.walTelemetry.isEnabled() ? this::doStoreWalTelemetry : this::storeWalTelemetryNoop;
        this.telemetry = engine.getTelemetry();
        this.telemetryFacade = this.telemetry.isEnabled() ? this::doStoreTelemetry : this::storeTelemetryNoop;
        this.operationCompiler = new OperationCompiler(engine, workerCount, sharedWorkerCount, ffCache);
        CairoConfiguration configuration = engine.getConfiguration();
        this.microClock = configuration.getMicrosecondClock();
        this.walEventReader = new WalEventReader(configuration.getFilesFacade());
        this.metrics = engine.getMetrics().getWalMetrics();
        this.lookAheadTransactionCount = configuration.getWalApplyLookAheadTransactionCount();
        this.tableTimeQuotaMicros = configuration.getWalApplyTableTimeQuota() >= 0L ? configuration.getWalApplyTableTimeQuota() * 1000L : 86400000000L;
    }

    @Override
    public void close() {
        Misc.free(this.operationCompiler);
        Misc.free(this.walEventReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cleanDroppedTableDirectory(CairoEngine engine, Path tempPath, TableToken tableToken) {
        boolean allClean = true;
        FilesFacade ff = engine.getConfiguration().getFilesFacade();
        tempPath.of(engine.getConfiguration().getRoot()).concat(tableToken);
        int rootLen = tempPath.length();
        long p = ff.findFirst(tempPath.$());
        if (p > 0L) {
            try {
                do {
                    int type;
                    long pUtf8NameZ;
                    if (ff.isDirOrSoftLinkDirNoDots(tempPath, rootLen, pUtf8NameZ = ff.findName(p), type = ff.findType(p))) {
                        if (CairoKeywords.isTxnSeq(pUtf8NameZ) || CairoKeywords.isWal(pUtf8NameZ) || ff.unlinkOrRemove(tempPath, LOG) == 0) continue;
                        allClean = false;
                        continue;
                    }
                    if (type != 8) continue;
                    tempPath.trimTo(rootLen);
                    tempPath.concat(pUtf8NameZ);
                    if (CairoKeywords.isTxn(pUtf8NameZ) || CairoKeywords.isMeta(pUtf8NameZ) || ApplyWal2TableJob.matchesWalLock(tempPath) || ff.remove(tempPath.$())) continue;
                    allClean = false;
                    LOG.info().$("could not remove [tempPath=").utf8(tempPath).$(", errno=").$(ff.errno()).I$();
                } while (ff.findNext(p) > 0);
                if (allClean) {
                    ff.remove(tempPath.trimTo(rootLen).concat("_txn").$());
                    ff.remove(tempPath.trimTo(rootLen).concat("_meta").$());
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                ff.findClose(p);
            }
        }
        return false;
    }

    private static AlterOperation compileAlter(TableWriter tableWriter, OperationCompiler compiler, CharSequence sql, long seqTxn) throws SqlException {
        try {
            return compiler.compileAlterSql(sql, tableWriter.getTableToken());
        }
        catch (SqlException ex) {
            tableWriter.markSeqTxnCommitted(seqTxn);
            throw ex;
        }
    }

    private static UpdateOperation compileUpdate(TableWriter tableWriter, OperationCompiler compiler, CharSequence sql, long seqTxn) throws SqlException {
        try {
            return compiler.compileUpdateSql(sql, tableWriter.getTableToken());
        }
        catch (SqlException ex) {
            tableWriter.markSeqTxnCommitted(seqTxn);
            throw ex;
        }
    }

    private static boolean matchesWalLock(CharSequence name) {
        int i;
        if (Chars.endsWith(name, ".lock")) {
            for (i = name.length() - ".lock".length() - 1; i > 0; --i) {
                char c = name.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return Chars.equals(name, i - "wal".length() + 1, i + 1, "wal", 0, "wal".length());
            }
        }
        int n = name.length();
        for (i = 0; i < n; ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private static boolean tryDestroyDroppedTable(TableToken tableToken, TableWriter writer, CairoEngine engine, Path tempPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean applyOutstandingWalTransactions(TableToken tableToken, TableWriter writer, CairoEngine engine, OperationCompiler operationCompiler, Path tempPath, Job.RunStatus runStatus) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doStoreTelemetry(short event, short origin) {
        TelemetryTask.store(this.telemetry, origin, event);
    }

    private void doStoreWalTelemetry(short event, TableToken tableToken, int walId, long seqTxn, long rowCount, long physicalRowCount, long latencyUs) {
        TelemetryWalTask.store(this.walTelemetry, event, tableToken.getTableId(), walId, seqTxn, rowCount, physicalRowCount, latencyUs);
    }

    private long processWalCommit(TableWriter writer, int walId, Path walPath, long segmentTxn, OperationCompiler operationCompiler, long seqTxn, long commitTimestamp) {
        try (WalEventReader eventReader = this.walEventReader;){
            WalEventCursor walEventCursor = eventReader.of(walPath, 0, segmentTxn);
            byte walTxnType = walEventCursor.getType();
            switch (walTxnType) {
                case 0: {
                    WalEventCursor.DataInfo dataInfo = walEventCursor.getDataInfo();
                    if (writer.getWalTnxDetails().hasRecord(seqTxn)) {
                        long rowCount = dataInfo.getEndRowID() - dataInfo.getStartRowID();
                        long start = this.microClock.getTicks();
                        this.walTelemetryFacade.store((short)103, writer.getTableToken(), walId, seqTxn, -1L, -1L, start - commitTimestamp);
                        long rowsAdded = writer.commitWalTransaction(walPath, !dataInfo.isOutOfOrder(), dataInfo.getStartRowID(), dataInfo.getEndRowID(), dataInfo.getMinTimestamp(), dataInfo.getMaxTimestamp(), dataInfo, seqTxn);
                        long latency = this.microClock.getTicks() - start;
                        long physicalRowCount = writer.getPhysicallyWrittenRowsSinceLastCommit();
                        this.metrics.addApplyRowsWritten(rowCount, physicalRowCount, latency);
                        this.walTelemetryFacade.store((short)105, writer.getTableToken(), walId, seqTxn, rowsAdded, physicalRowCount, latency);
                        long l = rowCount;
                        return l;
                    }
                    long rowCount = -2L;
                    return rowCount;
                }
                case 1: {
                    WalEventCursor.SqlInfo sqlInfo = walEventCursor.getSqlInfo();
                    long start = this.microClock.getTicks();
                    this.walTelemetryFacade.store((short)103, writer.getTableToken(), walId, seqTxn, -1L, -1L, start - commitTimestamp);
                    this.processWalSql(writer, sqlInfo, operationCompiler, seqTxn);
                    this.walTelemetryFacade.store((short)106, writer.getTableToken(), walId, seqTxn, -1L, -1L, this.microClock.getTicks() - start);
                    long l = -1L;
                    return l;
                }
                case 2: {
                    long txn = writer.getTxn();
                    writer.setSeqTxn(seqTxn);
                    writer.removeAllPartitions();
                    if (writer.getTxn() == txn) {
                        writer.markSeqTxnCommitted(seqTxn);
                    }
                    long l = -1L;
                    return l;
                }
            }
            throw new UnsupportedOperationException("Unsupported WAL txn type: " + walTxnType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWalSql(TableWriter tableWriter, WalEventCursor.SqlInfo sqlInfo, OperationCompiler operationCompiler, long seqTxn) {
        int cmdType = sqlInfo.getCmdType();
        CharSequence sql = sqlInfo.getSql();
        operationCompiler.resetRnd(sqlInfo.getRndSeed0(), sqlInfo.getRndSeed1());
        sqlInfo.populateBindVariableService(operationCompiler.getBindVariableService());
        try {
            switch (cmdType) {
                case 2: {
                    AlterOperation alterOperation = ApplyWal2TableJob.compileAlter(tableWriter, operationCompiler, sql, seqTxn);
                    try {
                        tableWriter.apply((AbstractOperation)alterOperation, seqTxn);
                        break;
                    }
                    finally {
                        Misc.free(alterOperation);
                    }
                }
                case 3: {
                    UpdateOperation updateOperation = ApplyWal2TableJob.compileUpdate(tableWriter, operationCompiler, sql, seqTxn);
                    try {
                        tableWriter.apply(updateOperation, seqTxn);
                        break;
                    }
                    finally {
                        Misc.free(updateOperation);
                    }
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported command type: " + cmdType);
                }
            }
        }
        catch (SqlException ex) {
            LOG.error().$("error applying SQL to wal table [table=").utf8(tableWriter.getTableToken().getTableName()).$(", sql=").$(sql).$(", error=").$(ex.getFlyweightMessage()).I$();
        }
        catch (CairoException e) {
            if (e.isWALTolerable()) {
                LOG.error().$("error applying SQL to wal table [table=").utf8(tableWriter.getTableToken().getTableName()).$(", sql=").$(sql).$(", error=").$(e.getFlyweightMessage()).I$();
            }
            throw e;
        }
    }

    private void storeTelemetryNoop(short event, short origin) {
    }

    private void storeWalTelemetryNoop(short event, TableToken tableToken, int walId, long seqTxn, long rowCount, long physicalRowCount, long latencyUs) {
    }

    long applyWAL(TableToken tableToken, CairoEngine engine, OperationCompiler operationCompiler, Job.RunStatus runStatus) {
        long lastWriterTxn = -1L;
        Path tempPath = Path.PATH.get();
        try {
            boolean finished;
            TableToken updatedToken = engine.getUpdatedTableToken(tableToken);
            if (engine.isTableDropped(tableToken) || updatedToken == null) {
                if (engine.isTableDropped(tableToken)) {
                    return ApplyWal2TableJob.tryDestroyDroppedTable(tableToken, null, engine, tempPath) ? Long.MAX_VALUE : -1L;
                }
                return Long.MAX_VALUE;
            }
            try (TableWriter writer = engine.getWriterUnsafe(updatedToken, WAL_2_TABLE_WRITE_REASON);){
                assert (writer.getMetadata().getTableId() == tableToken.getTableId());
                finished = this.applyOutstandingWalTransactions(tableToken, writer, engine, operationCompiler, tempPath, runStatus);
                lastWriterTxn = writer.getAppliedSeqTxn();
            }
            catch (EntryUnavailableException tableBusy) {
                if (tableBusy.getReason() != "unknown" && !WAL_2_TABLE_WRITE_REASON.equals(tableBusy.getReason()) && !WAL_2_TABLE_RESUME_REASON.equals(tableBusy.getReason())) {
                    LOG.critical().$("unsolicited table lock [table=").utf8(tableToken.getDirName()).$(", lock_reason=").$(tableBusy.getReason()).I$();
                }
                return lastWriterTxn;
            }
            long updatedLastWriterTxn = -1L;
            if (!finished || lastWriterTxn < (updatedLastWriterTxn = engine.getTableSequencerAPI().lastTxn(tableToken))) {
                long notifyTxn = updatedLastWriterTxn > -1L ? updatedLastWriterTxn : engine.getTableSequencerAPI().lastTxn(tableToken);
                engine.notifyWalTxnCommitted(tableToken, notifyTxn);
            }
        }
        catch (CairoException ex) {
            if (ex.isTableDropped() || engine.isTableDropped(tableToken)) {
                return ApplyWal2TableJob.tryDestroyDroppedTable(tableToken, null, engine, tempPath) ? Long.MAX_VALUE : -1L;
            }
            this.telemetryFacade.store((short)107, (short)6);
            LOG.critical().$("job failed, table suspended [table=").utf8(tableToken.getDirName()).$(", error=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            return -2L;
        }
        return lastWriterTxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        long seqTxn;
        TableToken tableToken;
        try {
            WalTxnNotificationTask task = (WalTxnNotificationTask)this.queue.get(cursor);
            tableToken = task.getTableToken();
            seqTxn = task.getTxn();
        }
        finally {
            this.subSeq.done(cursor);
        }
        int tableId = tableToken.getTableId();
        if (this.lastAppliedSeqTxns.get(tableId) < seqTxn) {
            long txn = this.applyWAL(tableToken, this.engine, this.operationCompiler, runStatus);
            if (txn > -1L) {
                this.lastAppliedSeqTxns.put(tableId, txn);
            } else if (txn == -2L) {
                this.lastAppliedSeqTxns.put(tableId, 0x7FFFFFFFFFFFFFFEL);
                try {
                    this.engine.getTableSequencerAPI().suspendTable(tableToken);
                }
                catch (CairoException e) {
                    LOG.critical().$("could not suspend table [table=").$(tableToken.getTableName()).$(", error=").$(e.getFlyweightMessage()).I$();
                }
            }
        } else {
            LOG.debug().$("Skipping WAL processing for table, already processed [table=").$(tableToken).$(", txn=").$(seqTxn).I$();
        }
        return true;
    }

    @FunctionalInterface
    private static interface WalTelemetryFacade {
        public void store(short var1, TableToken var2, int var3, long var4, long var6, long var8, long var10);
    }

    @FunctionalInterface
    private static interface TelemetryFacade {
        public void store(short var1, short var2);
    }
}

