/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.ptt;

import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.ptt.PartitionDateParseUtil;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.CharSink;

public class IsoDatePartitionFormat
implements DateFormat {
    private final DateFormat baseFormat;
    private final PartitionBy.PartitionFloorMethod floorMethod;

    public IsoDatePartitionFormat(PartitionBy.PartitionFloorMethod floorMethod, DateFormat baseFormat) {
        this.floorMethod = floorMethod;
        this.baseFormat = baseFormat;
    }

    @Override
    public void format(long timestamp, DateLocale locale, CharSequence timeZoneName, CharSink sink) {
        long overspill = timestamp - this.floorMethod.floor(timestamp);
        if (overspill > 0L) {
            TimestampFormatUtils.DAY_FORMAT.format(timestamp, locale, timeZoneName, sink);
            long time = timestamp - timestamp / 86400000000L * 86400000000L;
            if (time > 0L) {
                int hour = (int)(time / 3600000000L);
                int minute = (int)(time % 3600000000L / 60000000L);
                int second = (int)(time % 60000000L / 1000000L);
                int milliMicros = (int)(time % 1000000L);
                sink.put('T');
                TimestampFormatUtils.append0(sink, hour);
                if (minute > 0 || second > 0 || milliMicros > 0) {
                    TimestampFormatUtils.append0(sink, minute);
                    TimestampFormatUtils.append0(sink, second);
                    if (milliMicros > 0) {
                        sink.put('-');
                        TimestampFormatUtils.append00000(sink, milliMicros);
                    }
                }
            }
        } else {
            this.baseFormat.format(timestamp, locale, timeZoneName, sink);
        }
    }

    @Override
    public long parse(CharSequence in, DateLocale locale) throws NumericException {
        return PartitionDateParseUtil.parseFloorPartialTimestamp(in, 0, in.length());
    }

    @Override
    public long parse(CharSequence in, int lo, int hi, DateLocale locale) throws NumericException {
        return PartitionDateParseUtil.parseFloorPartialTimestamp(in, lo, hi);
    }
}

