/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.MessageBus;
import io.questdb.Metrics;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.LifecycleManager;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.pool.AbstractPool;
import io.questdb.cairo.pool.PoolConstants;
import io.questdb.cairo.pool.ex.EntryLockedException;
import io.questdb.cairo.pool.ex.PoolClosedException;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WriterPool
extends AbstractPool {
    public static final String OWNERSHIP_REASON_MISSING = "missing or owned by other process";
    public static final String OWNERSHIP_REASON_NONE = null;
    public static final String OWNERSHIP_REASON_RELEASED = "released";
    public static final String OWNERSHIP_REASON_UNKNOWN = "unknown";
    static final String OWNERSHIP_REASON_WRITER_ERROR = "writer error";
    private static final long ENTRY_OWNER = Unsafe.getFieldOffset(Entry.class, "owner");
    private static final Log LOG = LogFactory.getLog(WriterPool.class);
    private static final long QUEUE_PROCESSING_OWNER = -2L;
    private final MicrosecondClock clock;
    private final CairoConfiguration configuration;
    private final ConcurrentHashMap<Entry> entries = new ConcurrentHashMap();
    @NotNull
    private final MessageBus messageBus;
    @NotNull
    private final Metrics metrics;
    private final CharSequence root;

    public WriterPool(CairoConfiguration configuration, @NotNull MessageBus messageBus, @NotNull Metrics metrics) {
        super(configuration, configuration.getInactiveWriterTTL());
        this.configuration = configuration;
        this.messageBus = messageBus;
        this.clock = configuration.getMicrosecondClock();
        this.root = configuration.getRoot();
        this.metrics = metrics;
        this.notifyListener(Thread.currentThread().getId(), null, (short)23);
    }

    public int countFreeWriters() {
        int count = 0;
        for (Entry e : this.entries.values()) {
            long owner = e.owner;
            if (owner == -1L) {
                ++count;
                continue;
            }
            LOG.info().$("'").utf8(e.writer.getTableToken().getDirName()).$("' is still busy [owner=").$(owner).$(']').$();
        }
        return count;
    }

    public TableWriter get(TableToken tableToken, String lockReason) {
        return this.getWriterEntry(tableToken, lockReason, null);
    }

    public int getBusyCount() {
        int count = 0;
        for (Entry e : this.entries.values()) {
            if (e.owner == -1L) continue;
            ++count;
        }
        return count;
    }

    public TableWriter getWriterOrPublishCommand(TableToken tableToken, String lockReason, @NotNull AsyncWriterCommand asyncWriterCommand) {
        while (true) {
            try {
                return this.getWriterEntry(tableToken, lockReason, asyncWriterCommand);
            }
            catch (EntryUnavailableException entryUnavailableException) {
                continue;
            }
            break;
        }
    }

    public String lock(TableToken tableToken, String lockReason) {
        this.checkClosed();
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(tableToken.getDirName());
        if (e == null) {
            e = new Entry(this.clock.getTicks());
            Entry other = this.entries.putIfAbsent(tableToken.getDirName(), e);
            if (other == null) {
                if (this.lockAndNotify(thread, e, tableToken, lockReason)) {
                    return OWNERSHIP_REASON_NONE;
                }
                this.entries.remove(tableToken.getDirName());
                return this.reinterpretOwnershipReason(e.ownershipReason);
            }
            e = other;
        }
        if (Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
            this.closeWriter(thread, e, (short)19, 2);
            if (this.lockAndNotify(thread, e, tableToken, lockReason)) {
                return OWNERSHIP_REASON_NONE;
            }
            return this.reinterpretOwnershipReason(e.ownershipReason);
        }
        LOG.error().$("could not lock, busy [table=`").utf8(tableToken.getDirName()).$("`, owner=").$(e.owner).$(", thread=").$(thread).$(']').$();
        this.notifyListener(thread, tableToken, (short)7);
        return this.reinterpretOwnershipReason(e.ownershipReason);
    }

    public int size() {
        return this.entries.size();
    }

    public void unlock(TableToken tableToken, @Nullable TableWriter writer, boolean newTable) {
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(tableToken.getDirName());
        if (e == null) {
            this.notifyListener(thread, tableToken, (short)9);
            return;
        }
        if (e.owner == thread) {
            if (e.writer != null) {
                this.notifyListener(thread, tableToken, (short)9);
                throw CairoException.critical(0).put("Writer ").put(tableToken.getDirName()).put(" is not locked");
            }
            if (newTable) {
                assert (writer == null && e.lockFd != -1);
                LOG.info().$("created [table=`").utf8(tableToken.getDirName()).$("`, thread=").$(thread).$(']').$();
                writer = new TableWriter(this.configuration, tableToken, this.messageBus, null, false, e, this.root, this.metrics);
            }
            if (writer == null) {
                if (e.lockFd != -1) {
                    Path path = Path.getThreadLocal(this.root).concat(tableToken.getDirName());
                    TableUtils.lockName(path);
                    if (!this.ff.closeRemove(e.lockFd, path)) {
                        LOG.error().$("could not remove [file=").$(path).$(']').$();
                    }
                }
                this.entries.remove(tableToken.getDirName());
            } else {
                e.writer = writer;
                writer.setLifecycleManager(e);
                writer.transferLock(e.lockFd);
                e.lockFd = -1;
                e.ownershipReason = OWNERSHIP_REASON_NONE;
                Unsafe.getUnsafe().storeFence();
                Unsafe.getUnsafe().putOrderedLong(e, ENTRY_OWNER, -1L);
            }
        } else {
            this.notifyListener(thread, tableToken, (short)12);
            throw CairoException.critical(0).put("Not lock owner of ").put(tableToken.getDirName());
        }
        this.notifyListener(thread, tableToken, (short)8);
        LOG.debug().$("unlocked [table=`").utf8(tableToken.getDirName()).$("`, thread=").$(thread).I$();
    }

    public void unlock(TableToken tableToken) {
        this.unlock(tableToken, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommandToWriterQueue(Entry e, AsyncWriterCommand asyncWriterCommand, long thread) {
        TableWriter writer;
        while ((writer = e.writer) == null && e.owner != -1L) {
            Os.pause();
        }
        if (writer == null) {
            throw EntryUnavailableException.instance("please retry");
        }
        asyncWriterCommand.startAsync();
        writer.publishAsyncWriterCommand(asyncWriterCommand);
        while (e.owner == -2L) {
            Os.pause();
        }
        if (Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
            try {
                writer.tick(true);
            }
            finally {
                Unsafe.cas((Object)e, ENTRY_OWNER, thread, -1L);
            }
        }
    }

    private void assertLockReasonIsNone(String lockReason) {
        if (lockReason == OWNERSHIP_REASON_NONE) {
            throw new NullPointerException();
        }
    }

    private void checkClosed() {
        if (this.isClosed()) {
            LOG.info().$("is closed").$();
            throw PoolClosedException.INSTANCE;
        }
    }

    private TableWriter checkClosedAndGetWriter(TableToken tableToken, Entry e, String lockReason) {
        this.assertLockReasonIsNone(lockReason);
        if (this.isClosed()) {
            LOG.info().$('\'').utf8(tableToken.getDirName()).$("' born free").$();
            return e.goodbye();
        }
        e.ownershipReason = lockReason;
        e.writer.updateTableToken(tableToken);
        return this.logAndReturn(e, (short)11);
    }

    private void closeWriter(long thread, Entry e, short ev, int reason) {
        TableWriter w = e.writer;
        if (w != null) {
            TableToken name = e.writer.getTableToken();
            w.setLifecycleManager(DefaultLifecycleManager.INSTANCE);
            w.close();
            e.writer = null;
            e.ownershipReason = OWNERSHIP_REASON_RELEASED;
            LOG.info().$("closed [table=`").utf8(name.getDirName()).$("`, reason=").$(PoolConstants.closeReasonText(reason)).$(", by=").$(thread).$(']').$();
            this.notifyListener(thread, name, ev);
        }
    }

    private TableWriter createWriter(TableToken tableToken, Entry e, long thread, String lockReason) {
        try {
            this.checkClosed();
            LOG.info().$("open [table=`").utf8(tableToken.getDirName()).$("`, thread=").$(thread).$(']').$();
            e.writer = new TableWriter(this.configuration, tableToken, this.messageBus, null, true, e, this.root, this.metrics);
            e.ownershipReason = lockReason;
            return this.logAndReturn(e, (short)10);
        }
        catch (CairoException ex) {
            LogRecord record = ex.isCritical() ? LOG.critical() : LOG.error();
            record.$("could not open [table=`").utf8(tableToken.getTableName()).$("`, thread=").$(e.owner).$(", ex=").utf8(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
            e.ex = ex;
            e.ownershipReason = OWNERSHIP_REASON_WRITER_ERROR;
            e.owner = -1L;
            this.notifyListener(e.owner, tableToken, (short)14);
            throw ex;
        }
    }

    private TableWriter getWriterEntry(TableToken tableToken, String lockReason, @Nullable AsyncWriterCommand asyncWriterCommand) {
        long owner;
        Entry e;
        assert (null != lockReason);
        this.checkClosed();
        long thread = Thread.currentThread().getId();
        while (true) {
            if ((e = this.entries.get(tableToken.getDirName())) == null) {
                e = new Entry(this.clock.getTicks());
                Entry other = this.entries.putIfAbsent(tableToken.getDirName(), e);
                if (other == null) {
                    return this.createWriter(tableToken, e, thread, lockReason);
                }
                e = other;
            }
            owner = e.owner;
            if (Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
                if (e.writer == null) {
                    return this.createWriter(tableToken, e, thread, lockReason);
                }
                return this.checkClosedAndGetWriter(tableToken, e, lockReason);
            }
            if (owner >= 0L) break;
            Os.pause();
        }
        if (owner == thread) {
            if ((long)e.lockFd != -1L) {
                throw EntryLockedException.instance(this.reinterpretOwnershipReason(e.ownershipReason));
            }
            if (e.ex != null) {
                this.notifyListener(thread, tableToken, (short)21);
                this.entries.remove(tableToken.getDirName());
                throw e.ex;
            }
        }
        if (asyncWriterCommand != null) {
            this.addCommandToWriterQueue(e, asyncWriterCommand, thread);
            return null;
        }
        String reason = this.reinterpretOwnershipReason(e.ownershipReason);
        if (!tableToken.isWal()) {
            LOG.info().$("busy [table=`").utf8(tableToken.getDirName()).$("`, owner=").$(owner).$(", thread=").$(thread).$(", reason=").$(reason).I$();
        }
        throw EntryUnavailableException.instance(reason);
    }

    private boolean lockAndNotify(long thread, Entry e, TableToken tableToken, String lockReason) {
        this.assertLockReasonIsNone(lockReason);
        Path path = Path.getThreadLocal(this.root).concat(tableToken.getDirName());
        TableUtils.lockName(path);
        e.lockFd = TableUtils.lock(this.ff, path);
        if (e.lockFd == -1) {
            LOG.error().$("could not lock [table=`").utf8(tableToken.getDirName()).$("`, thread=").$(thread).$(']').$();
            e.ownershipReason = OWNERSHIP_REASON_MISSING;
            e.owner = -1L;
            return false;
        }
        LOG.debug().$("locked [table=`").utf8(tableToken.getDirName()).$("`, thread=").$(thread).$(']').$();
        this.notifyListener(thread, tableToken, (short)6);
        e.ownershipReason = lockReason;
        return true;
    }

    private TableWriter logAndReturn(Entry e, short event) {
        LOG.info().$(">> [table=`").utf8(e.writer.getTableToken().getDirName()).$("`, thread=").$(e.owner).$(']').$();
        this.notifyListener(e.owner, e.writer.getTableToken(), event);
        return e.writer;
    }

    private String reinterpretOwnershipReason(String providedReason) {
        return providedReason == OWNERSHIP_REASON_NONE ? OWNERSHIP_REASON_UNKNOWN : providedReason;
    }

    private boolean returnToPool(Entry e) {
        long thread = Thread.currentThread().getId();
        TableToken tableToken = e.writer.getTableToken();
        try {
            e.writer.rollback();
            if (e.owner != -1L) {
                e.owner = -2L;
            }
            e.writer.tick(true);
        }
        catch (Throwable ex) {
            this.entries.remove(tableToken.getDirName());
            this.closeWriter(thread, e, (short)19, 5);
            return true;
        }
        if (e.owner != -1L) {
            LOG.info().$("<< [table=`").utf8(tableToken.getDirName()).$("`, thread=").$(thread).$(']').$();
            e.ownershipReason = OWNERSHIP_REASON_NONE;
            e.lastReleaseTime = this.configuration.getMicrosecondClock().getTicks();
            Unsafe.getUnsafe().storeFence();
            Unsafe.getUnsafe().putOrderedLong(e, ENTRY_OWNER, -1L);
            if (this.isClosed() && Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
                e.writer = null;
                this.notifyListener(thread, tableToken, (short)2);
                return false;
            }
            this.notifyListener(thread, tableToken, (short)1);
        } else {
            LOG.critical().$("orphaned [table=`").utf8(tableToken.getDirName()).$("`]").$();
            this.notifyListener(thread, tableToken, (short)3);
        }
        return true;
    }

    @Override
    protected void closePool() {
        super.closePool();
        LOG.info().$("closed").$();
    }

    @Override
    protected boolean releaseAll(long deadline) {
        long thread = Thread.currentThread().getId();
        boolean removed = false;
        int reason = deadline == Long.MAX_VALUE ? 1 : 3;
        Iterator<Entry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            Entry e = iterator.next();
            if (deadline > e.lastReleaseTime && e.owner == -1L) {
                if (!Unsafe.cas((Object)e, ENTRY_OWNER, -1L, -thread - 3L)) continue;
                this.closeWriter(thread, e, (short)17, reason);
                iterator.remove();
                removed = true;
                continue;
            }
            if (e.lockFd != -1 && deadline == Long.MAX_VALUE) {
                if (!this.ff.close(e.lockFd)) continue;
                e.lockFd = -1;
                iterator.remove();
                removed = true;
                continue;
            }
            if (e.ex == null) continue;
            LOG.info().$("purging entry for failed to allocate writer").$();
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    private class Entry
    implements LifecycleManager {
        private CairoException ex = null;
        private volatile long lastReleaseTime;
        private volatile int lockFd = -1;
        private volatile long owner = Thread.currentThread().getId();
        private volatile String ownershipReason = OWNERSHIP_REASON_NONE;
        private TableWriter writer;

        public Entry(long lastReleaseTime) {
            this.lastReleaseTime = lastReleaseTime;
        }

        @Override
        public boolean close() {
            return !WriterPool.this.returnToPool(this);
        }

        public TableWriter goodbye() {
            TableWriter w = this.writer;
            if (this.writer != null) {
                this.writer.setLifecycleManager(DefaultLifecycleManager.INSTANCE);
                this.writer = null;
            }
            return w;
        }
    }
}

