/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.frm.FrameColumn;
import io.questdb.cairo.frm.file.RecycleBin;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.Path;

public class ContiguousFileFixFrameColumn
implements FrameColumn {
    public static final int MEMORY_TAG = 5;
    private static final Log LOG = LogFactory.getLog(ContiguousFileFixFrameColumn.class);
    protected final FilesFacade ff;
    private final long fileOpts;
    private int columnIndex;
    private long columnTop;
    private int columnType;
    private int fd = -1;
    private RecycleBin<ContiguousFileFixFrameColumn> recycleBin;
    private int shl;

    public ContiguousFileFixFrameColumn(CairoConfiguration configuration) {
        this.ff = configuration.getFilesFacade();
        this.fileOpts = configuration.getWriterFileOpenOpts();
    }

    @Override
    public void addTop(long value) {
        assert (value >= 0L);
        this.columnTop += value;
    }

    @Override
    public void append(long offset, FrameColumn sourceColumn, long sourceLo, long sourceHi, int commitMode) {
        if (sourceColumn.getStorageType() == 0) {
            sourceHi -= sourceColumn.getColumnTop();
            offset -= this.columnTop;
            assert ((sourceLo -= sourceColumn.getColumnTop()) >= 0L);
            assert (sourceHi >= 0L);
            assert (offset >= 0L);
            if (sourceHi > 0L) {
                int sourceFd = sourceColumn.getPrimaryFd();
                long length = sourceHi << this.shl;
                TableUtils.allocateDiskSpaceToPage(this.ff, this.fd, offset + sourceHi << this.shl);
                this.ff.fadvise(sourceFd, sourceLo << this.shl, length, Files.POSIX_FADV_SEQUENTIAL);
                if (this.ff.copyData(sourceFd, this.fd, sourceLo << this.shl, offset << this.shl, length) != length) {
                    throw CairoException.critical(this.ff.errno()).put("Cannot copy data [fd=").put(this.fd).put(", destOffset=").put(offset << this.shl).put(", size=").put(length).put(", fileSize=").put(this.ff.length(this.fd)).put(", srcFd=").put(sourceFd).put(", srcOffset=").put(sourceLo << this.shl).put(", srcFileSize=").put(this.ff.length(sourceFd)).put(']');
                }
                if (commitMode != 2) {
                    this.ff.fsync(this.fd);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendNulls(long offset, long count, int commitMode) {
        assert ((offset -= this.columnTop) >= 0L);
        assert (count >= 0L);
        if (count > 0L) {
            TableUtils.allocateDiskSpaceToPage(this.ff, this.fd, offset + count << this.shl);
            long mappedAddress = TableUtils.mapAppendColumnBuffer(this.ff, this.fd, offset << this.shl, count << this.shl, true, 5);
            try {
                TableUtils.setNull(this.columnType, mappedAddress, count);
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(this.ff, mappedAddress, offset << this.shl, count << this.shl, 5);
            }
            if (commitMode != 2) {
                this.ff.fsync(this.fd);
            }
        }
    }

    @Override
    public void close() {
        if (this.fd > -1) {
            this.ff.close(this.fd);
            this.fd = -1;
        }
        if (!this.recycleBin.isClosed()) {
            this.recycleBin.put(this);
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public long getColumnTop() {
        return this.columnTop;
    }

    @Override
    public int getColumnType() {
        return this.columnType;
    }

    @Override
    public int getPrimaryFd() {
        return this.fd;
    }

    @Override
    public int getSecondaryFd() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getStorageType() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ofRO(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, long columnTop, int columnIndex, boolean isEmpty) {
        assert (this.fd == -1);
        this.of(columnType, columnTop, columnIndex);
        if (!isEmpty) {
            int plen = partitionPath.length();
            try {
                TableUtils.dFile(partitionPath, columnName, columnTxn);
                this.fd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
            }
            finally {
                partitionPath.trimTo(plen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ofRW(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, long columnTop, int columnIndex) {
        assert (this.fd == -1);
        this.of(columnType, columnTop, columnIndex);
        int plen = partitionPath.length();
        try {
            TableUtils.dFile(partitionPath, columnName, columnTxn);
            this.fd = TableUtils.openRW(this.ff, partitionPath.$(), LOG, this.fileOpts);
        }
        finally {
            partitionPath.trimTo(plen);
        }
    }

    public void setPool(RecycleBin<ContiguousFileFixFrameColumn> recycleBin) {
        assert (this.recycleBin == null);
        this.recycleBin = recycleBin;
    }

    private void of(int columnType, long columnTop, int columnIndex) {
        this.shl = ColumnType.pow2SizeOf(columnType);
        this.columnType = columnType;
        this.columnTop = columnTop;
        this.columnIndex = columnIndex;
    }
}

