/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm;

import io.questdb.cairo.frm.Frame;
import io.questdb.cairo.frm.FrameColumn;

public class FrameAlgebra {
    public static void append(Frame target, Frame source, int commitMode) {
        if (source.getSize() > 0L) {
            int n = source.columnCount();
            for (int i = 0; i < n; ++i) {
                try (FrameColumn sourceColumn = source.createColumn(i);
                     FrameColumn targetColumn = target.createColumn(i);){
                    if (sourceColumn.getColumnType() < 0) continue;
                    FrameAlgebra.append(targetColumn, target.getSize(), sourceColumn, source.getSize(), commitMode);
                    target.saveChanges(targetColumn);
                    continue;
                }
            }
            target.setSize(source.getSize() + target.getSize());
        }
    }

    private static void append(FrameColumn targetColumn, long targetSize, FrameColumn sourceColumn, long sourceSize, int commitMode) {
        int columnType = sourceColumn.getColumnType();
        if (columnType != targetColumn.getColumnType()) {
            throw new UnsupportedOperationException();
        }
        long sourceColTop = sourceColumn.getColumnTop();
        if (sourceColTop > 0L) {
            long targetColTop = targetColumn.getColumnTop();
            if (targetColTop == targetSize) {
                targetColumn.addTop(sourceColTop);
            } else {
                targetColumn.appendNulls(targetSize, sourceColTop, commitMode);
            }
        }
        targetColumn.append(targetSize + sourceColTop, sourceColumn, sourceColTop, sourceSize, commitMode);
    }
}

