/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class TableToken
implements Sinkable {
    @NotNull
    private final String dirName;
    private final boolean isWal;
    private final int tableId;
    @NotNull
    private final String tableName;

    public TableToken(@NotNull String tableName, @NotNull String dirName, int tableId, boolean isWal) {
        this.tableName = tableName;
        this.dirName = dirName;
        this.tableId = tableId;
        this.isWal = isWal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableToken that = (TableToken)o;
        if (this.tableId != that.tableId) {
            return false;
        }
        if (this.isWal != that.isWal) {
            return false;
        }
        if (!this.tableName.equals(that.tableName)) {
            return false;
        }
        return this.dirName.equals(that.dirName);
    }

    @NotNull
    public String getDirName() {
        return this.dirName;
    }

    public int getTableId() {
        return this.tableId;
    }

    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    public int hashCode() {
        return this.tableId;
    }

    public boolean isWal() {
        return this.isWal;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.encodeUtf8(this.tableName);
    }
}

