/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.RebuildColumnBase;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.MemoryCMARWImpl;
import io.questdb.cairo.vm.MemoryCMRImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;

public class RecoverVarIndex
extends RebuildColumnBase {
    private static final Log LOG = LogFactory.getLog(RecoverVarIndex.class);

    public RecoverVarIndex(CairoConfiguration configuration) {
        super(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReindex(FilesFacade ff, ColumnVersionReader columnVersionReader, int columnWriterIndex, CharSequence columnName, long partitionNameTxn, long partitionSize, long partitionTimestamp, int partitionBy, int indexValueBlockCapacity) {
        long columnNameTxn = columnVersionReader.getColumnNameTxn(partitionTimestamp, columnWriterIndex);
        long columnTop = columnVersionReader.getColumnTop(partitionTimestamp, columnWriterIndex);
        if (columnTop == -1L) {
            LOG.info().$("not rebuilding column ").$(columnName).$(" in partition ").$ts(partitionTimestamp).$(", column not added to partition").$();
            return;
        }
        int trimTo = this.path.length();
        TableUtils.setPathForPartition(this.path, partitionBy, partitionTimestamp, partitionNameTxn);
        try {
            this.path.concat(columnName);
            int colNameLen = this.path.length();
            this.path.put(".d");
            if (columnNameTxn != -1L) {
                this.path.put('.').put(columnNameTxn);
            }
            LOG.info().$("reading: ").$(this.path).$();
            long maxOffset = ff.length(this.path.$());
            try (MemoryCMRImpl roMem = new MemoryCMRImpl(ff, this.path.$(), maxOffset, 0);){
                this.path.trimTo(colNameLen).put(".i");
                if (columnNameTxn != -1L) {
                    this.path.put('.').put(columnNameTxn);
                }
                LOG.info().$("writing: ").$(this.path).$();
                try (MemoryCMARWImpl rwMem = new MemoryCMARWImpl(ff, this.path.$(), 0x800000L, 0L, 0, 0L);){
                    long expectedRowCount = partitionSize - columnTop;
                    LOG.info().$("data file length: ").$(maxOffset).$(", expected record count: ").$(expectedRowCount).$();
                    long offset = 0L;
                    int rows = 0;
                    while ((long)rows < expectedRowCount && offset + 3L < maxOffset) {
                        int len = roMem.getInt(offset);
                        rwMem.putLong(offset);
                        offset = len > -1 ? (offset += 4L + (long)len * 2L) : (offset += 4L);
                        ++rows;
                    }
                    if ((long)rows != expectedRowCount) {
                        throw CairoException.critical(0).put(" rebuild var index file failed [path=").put(this.path).put(", expectedRows=").put(expectedRowCount).put(", actualRows=").put(rows).put(']');
                    }
                    rwMem.putLong(offset);
                    LOG.info().$("write complete. Index file length: ").$(rwMem.getAppendOffset()).$();
                }
            }
        }
        finally {
            this.path.trimTo(trimTo);
        }
    }

    @Override
    protected boolean isSupportedColumn(RecordMetadata metadata, int columnIndex) {
        return metadata.getColumnType(columnIndex) == 11;
    }
}

