/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public abstract class RebuildColumnBase
implements Closeable,
Mutable {
    static final int REBUILD_ALL_COLUMNS = -1;
    protected final CairoConfiguration configuration;
    protected final String unsupportedTableMessage = "Table does not have any indexes";
    private final MillisecondClock clock;
    private final StringSink tempStringSink = new StringSink();
    protected FilesFacade ff;
    protected Path path = new Path();
    protected int rootLen;
    protected String unsupportedColumnMessage = "Wrong column type";
    private int lockFd;

    public RebuildColumnBase(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
        this.clock = configuration.getMillisecondClock();
    }

    @Override
    public void clear() {
        this.path.trimTo(0);
        this.tempStringSink.clear();
    }

    @Override
    public void close() {
        this.path = Misc.free(this.path);
    }

    public RebuildColumnBase of(CharSequence tablePath) {
        this.path.of(tablePath);
        this.rootLen = tablePath.length();
        return this;
    }

    public void rebuildAll() {
        this.reindex(this.ff, null, null);
    }

    public void reindex(@Nullable CharSequence partitionName, @Nullable CharSequence columnName) {
        this.reindex(this.ff, partitionName, columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(FilesFacade ff, @Nullable CharSequence partitionName, @Nullable CharSequence columnName) {
        try {
            this.lock(ff);
            this.path.concat("_cv").$();
            try (ColumnVersionReader columnVersionReader = new ColumnVersionReader().ofRO(ff, this.path);){
                long deadline = this.clock.getTicks() + this.configuration.getSpinLockTimeout();
                columnVersionReader.readSafe(this.clock, deadline);
                this.path.trimTo(this.rootLen);
                this.reindex0(ff, columnVersionReader, partitionName, columnName);
            }
        }
        finally {
            TableUtils.lockName(this.path);
            this.releaseLock(ff);
        }
    }

    public void reindexAfterUpdate(FilesFacade ff, long partitionTimestamp, CharSequence columnName, TableWriter tableWriter) {
        TxReader txReader = tableWriter.getTxReader();
        int partitionIndex = txReader.getPartitionIndex(partitionTimestamp);
        assert ((long)partitionIndex > -1L);
        TableRecordMetadata metadata = tableWriter.getMetadata();
        int columnIndex = tableWriter.getColumnIndex(columnName);
        int indexValueBlockCapacity = metadata.getIndexValueBlockCapacity(columnIndex);
        assert (indexValueBlockCapacity > 0);
        long partitionSize = partitionIndex == txReader.getPartitionCount() - 1 ? txReader.getTransientRowCount() : txReader.getPartitionSize(partitionIndex);
        long partitionNameTxn = txReader.getPartitionNameTxn(partitionIndex);
        this.doReindex(ff, tableWriter.getColumnVersionReader(), columnIndex, columnName, partitionNameTxn, partitionSize, partitionTimestamp, tableWriter.getPartitionBy(), indexValueBlockCapacity);
    }

    public void reindexAllInPartition(CharSequence partitionName) {
        this.reindex(partitionName, null);
    }

    public void reindexColumn(CharSequence columnName) {
        this.reindex(null, columnName);
    }

    public void reindexColumn(FilesFacade ff, CharSequence columnName) {
        this.reindex(ff, null, columnName);
    }

    public void reindexColumn(FilesFacade ff, ColumnVersionReader columnVersionReader, RecordMetadata metadata, int columnIndex, long partitionNameTxn, long partitionTimestamp, int partitionBy, long partitionSize) {
        this.doReindex(ff, columnVersionReader, metadata.getWriterIndex(columnIndex), metadata.getColumnName(columnIndex), partitionNameTxn, partitionSize, partitionTimestamp, partitionBy, metadata.getIndexValueBlockCapacity(columnIndex));
    }

    private void lock(FilesFacade ff) {
        try {
            this.path.trimTo(this.rootLen);
            TableUtils.lockName(this.path);
            this.lockFd = TableUtils.lock(ff, this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
        if (this.lockFd == -1) {
            throw CairoException.nonCritical().put("Cannot lock table: ").put(this.path.$());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindex0(FilesFacade ff, ColumnVersionReader columnVersionReader, @Nullable CharSequence partitionName, @Nullable CharSequence columnName) {
        this.path.trimTo(this.rootLen).concat("_meta");
        try (TableReaderMetadata metadata = new TableReaderMetadata(this.configuration);){
            metadata.load(this.path.$());
            int columnIndex = columnName != null ? metadata.getColumnIndex(columnName) : -1;
            this.path.trimTo(this.rootLen);
            int partitionBy = metadata.getPartitionBy();
            try (TxReader txReader = new TxReader(ff).ofRO(this.path.concat("_txn").$(), partitionBy);){
                txReader.unsafeLoadAll();
                this.path.trimTo(this.rootLen);
                if (PartitionBy.isPartitioned(partitionBy)) {
                    if (partitionName != null) {
                        long partitionTimestamp = PartitionBy.parsePartitionDirName(partitionName, partitionBy);
                        int partitionIndex = txReader.findAttachedPartitionIndexByLoTimestamp(partitionTimestamp);
                        if ((long)partitionIndex > -1L) {
                            this.reindexPartition(ff, metadata, columnVersionReader, txReader, columnIndex, partitionIndex, partitionBy, partitionTimestamp);
                        }
                    } else {
                        for (int partitionIndex = txReader.getPartitionCount() - 1; partitionIndex > -1; --partitionIndex) {
                            this.reindexPartition(ff, metadata, columnVersionReader, txReader, columnIndex, partitionIndex, partitionBy, txReader.getPartitionTimestampByIndex(partitionIndex));
                        }
                    }
                } else {
                    this.reindexOneOrAllColumns(ff, metadata, columnVersionReader, columnIndex, partitionBy, -1L, 0L, txReader.getTransientRowCount());
                }
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void reindexOneOrAllColumns(FilesFacade ff, RecordMetadata metadata, ColumnVersionReader columnVersionReader, int columnIndex, int partitionBy, long partitionNameTxn, long partitionTimestamp, long partitionSize) {
        boolean isIndexed = false;
        if (columnIndex == -1) {
            int n = metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (!this.isSupportedColumn(metadata, i)) continue;
                isIndexed = true;
                this.reindexColumn(ff, columnVersionReader, metadata, i, partitionNameTxn, partitionTimestamp, partitionBy, partitionSize);
            }
            if (!isIndexed) {
                throw CairoException.nonCritical().put("Table does not have any indexes");
            }
        } else if (this.isSupportedColumn(metadata, columnIndex)) {
            this.reindexColumn(ff, columnVersionReader, metadata, columnIndex, partitionNameTxn, partitionTimestamp, partitionBy, partitionSize);
        } else {
            throw CairoException.nonCritical().put(this.unsupportedColumnMessage);
        }
    }

    private void reindexPartition(FilesFacade ff, RecordMetadata metadata, ColumnVersionReader columnVersionReader, TxReader txReader, int columnIndex, int partitionIndex, int partitionBy, long partitionTimestamp) {
        long partitionSize = partitionIndex == txReader.getPartitionCount() - 1 ? txReader.getTransientRowCount() : txReader.getPartitionSize(partitionIndex);
        this.reindexOneOrAllColumns(ff, metadata, columnVersionReader, columnIndex, partitionBy, txReader.getPartitionNameTxn(partitionIndex), partitionTimestamp, partitionSize);
    }

    private void releaseLock(FilesFacade ff) {
        if ((long)this.lockFd != -1L) {
            ff.close(this.lockFd);
            this.lockFd = -1;
            try {
                this.path.trimTo(this.rootLen);
                TableUtils.lockName(this.path);
                if (ff.exists(this.path) && !ff.remove(this.path)) {
                    throw CairoException.critical(ff.errno()).put("Cannot remove ").put(this.path);
                }
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    protected abstract void doReindex(FilesFacade var1, ColumnVersionReader var2, int var3, CharSequence var4, long var5, long var7, long var9, int var11, int var12);

    protected abstract boolean isSupportedColumn(RecordMetadata var1, int var2);
}

