/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Job;
import io.questdb.mp.Sequence;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class O3OpenColumnJob
extends AbstractQueueConsumerJob<O3OpenColumnTask> {
    public static final int OPEN_LAST_PARTITION_FOR_APPEND = 2;
    public static final int OPEN_LAST_PARTITION_FOR_MERGE = 4;
    public static final int OPEN_MID_PARTITION_FOR_APPEND = 1;
    public static final int OPEN_MID_PARTITION_FOR_MERGE = 3;
    public static final int OPEN_NEW_PARTITION_FOR_APPEND = 5;
    private static final Log LOG = LogFactory.getLog(O3OpenColumnJob.class);

    public O3OpenColumnJob(MessageBus messageBus) {
        super(messageBus.getO3OpenColumnQueue(), messageBus.getO3OpenColumnSubSeq());
    }

    public static void appendLastPartition(Path pathToPartition, int plen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, MemoryMA dstFixMem, MemoryMA dstVarMem, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long columnNameTxn, long partitionUpdateSinkAddr) {
        long dstLen = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop;
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                O3OpenColumnJob.appendVarColumn(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, 0, 0L, 0L, -dstFixMem.getFd(), -dstVarMem.getFd(), dstFixMem, dstVarMem, dstLen, newPartitionSize, oldPartitionSize, tableWriter, partitionUpdateSinkAddr);
                break;
            }
            case 8: {
                boolean designated = ColumnType.isDesignatedTimestamp(columnType);
                if (designated) {
                    O3OpenColumnJob.appendTimestampColumn(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataMax, indexBlockCapacity, -dstFixMem.getFd(), 0L, 0L, dstFixMem, dstLen, newPartitionSize, oldPartitionSize, tableWriter, partitionUpdateSinkAddr);
                    break;
                }
            }
            default: {
                O3OpenColumnJob.appendFixColumn(pathToPartition, plen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, 0, 0L, 0L, -dstFixMem.getFd(), dstFixMem, dstLen, tableWriter, newPartitionSize, oldPartitionSize, indexWriter, columnNameTxn, partitionUpdateSinkAddr);
            }
        }
    }

    public static boolean isOpenColumnModeForAppend(int openColumnMode) {
        switch (openColumnMode) {
            case 1: 
            case 2: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static void openColumn(O3OpenColumnTask task, long cursor, Sequence subSeq) {
        int openColumnMode = task.getOpenColumnMode();
        Path pathToTable = task.getPathToTable();
        int columnType = task.getColumnType();
        CharSequence columnName = task.getColumnName();
        long srcOooLo = task.getSrcOooLo();
        long srcOooHi = task.getSrcOooHi();
        long srcOooMax = task.getSrcOooMax();
        long timestampMin = task.getTimestampMin();
        long partitionTimestamp = task.getPartitionTimestamp();
        long oldPartitionTimestamp = task.getOldPartitionTimestamp();
        long srcDataMax = task.getSrcDataMax();
        long srcDataTxn = task.getSrcDataTxn();
        int srcTimestampFd = task.getSrcTimestampFd();
        long srcTimestampAddr = task.getSrcTimestampAddr();
        long srcTimestampSize = task.getSrcTimestampSize();
        AtomicInteger columnCounter = task.getColumnCounter();
        AtomicInteger partCounter = task.getPartCounter();
        int indexBlockCapacity = task.getIndexBlockCapacity();
        long srcOooFixAddr = task.getSrcOooFixAddr();
        long srcOooVarAddr = task.getSrcOooVarAddr();
        long mergeOOOLo = task.getMergeOOOLo();
        long mergeOOOHi = task.getMergeOOOHi();
        long mergeDataLo = task.getMergeDataLo();
        long mergeDataHi = task.getMergeDataHi();
        long txn = task.getTxn();
        int prefixType = task.getPrefixType();
        long prefixLo = task.getPrefixLo();
        long prefixHi = task.getPrefixHi();
        int suffixType = task.getSuffixType();
        long suffixLo = task.getSuffixLo();
        long suffixHi = task.getSuffixHi();
        int mergeType = task.getMergeType();
        long timestampMergeIndexAddr = task.getTimestampMergeIndexAddr();
        long timestampMergeIndexSize = task.getTimestampMergeIndexSize();
        int activeFixFd = task.getActiveFixFd();
        int activeVarFd = task.getActiveVarFd();
        long srcDataTop = task.getSrcDataTop();
        TableWriter tableWriter = task.getTableWriter();
        BitmapIndexWriter indexWriter = task.getIndexWriter();
        long partitionUpdateSinkAddr = task.getPartitionUpdateSinkAddr();
        int columnIndex = task.getColumnIndex();
        long columnNameTxn = task.getColumnNameTxn();
        long newPartitionSize = task.getNewPartitionSize();
        long oldPartitionSize = task.getOldPartitionSize();
        subSeq.done(cursor);
        O3OpenColumnJob.openColumn(openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, oldPartitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, indexBlockCapacity, activeFixFd, activeVarFd, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr, columnIndex, columnNameTxn);
    }

    public static void openColumn(int openColumnMode, Path pathToTable, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long oldPartitionTimestamp, long srcDataTop, long srcDataMax, long srcDataTxn, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, int suffixType, long suffixLo, long suffixHi, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int indexBlockCapacity, int activeFixFd, int activeVarFd, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr, int columnIndex, long columnNameTxn) {
        long mergeLen = mergeOOOHi - mergeOOOLo + 1L + mergeDataHi - mergeDataLo + 1L;
        Path pathToOldPartition = Path.getThreadLocal(pathToTable);
        TableUtils.setPathForPartition(pathToOldPartition, tableWriter.getPartitionBy(), oldPartitionTimestamp, srcDataTxn);
        int plen = pathToOldPartition.length();
        Path pathToNewPartition = Path.getThreadLocal2(pathToTable);
        boolean partitionAppend = openColumnMode == 1 || openColumnMode == 5;
        TableUtils.setPathForPartition(pathToNewPartition, tableWriter.getPartitionBy(), partitionTimestamp, partitionAppend ? srcDataTxn : txn);
        int pplen = pathToNewPartition.length();
        long colTopSinkAddr = O3OpenColumnJob.columnTopAddress(partitionUpdateSinkAddr, columnIndex);
        switch (openColumnMode) {
            case 1: {
                O3OpenColumnJob.appendMidPartition(pathToNewPartition, pplen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, oldPartitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, colTopSinkAddr, columnIndex, columnNameTxn, partitionUpdateSinkAddr);
                break;
            }
            case 3: {
                O3OpenColumnJob.mergeMidPartition(pathToOldPartition, plen, pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, colTopSinkAddr, oldPartitionTimestamp, columnIndex, columnNameTxn, partitionUpdateSinkAddr);
                break;
            }
            case 4: {
                O3OpenColumnJob.mergeLastPartition(pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, activeFixFd, activeVarFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, colTopSinkAddr, columnNameTxn, partitionUpdateSinkAddr);
                break;
            }
            case 5: {
                Unsafe.getUnsafe().putLong(colTopSinkAddr, 0L);
                O3OpenColumnJob.appendNewPartition(pathToNewPartition, plen, columnName, columnCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataMax, indexBlockCapacity, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, columnNameTxn, partitionUpdateSinkAddr);
                break;
            }
        }
    }

    private static void appendFixColumn(Path pathToNewPartition, int pNewLen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int dstFixFd, MemoryMA dstFixMem, long dstLen, TableWriter tableWriter, long newPartitionSize, long oldPartitionSize, BitmapIndexWriter indexWriter, long columnNameTxn, long partitionUpdateSinkAddr) {
        long dstFixFileOffset;
        long dstIndexAdjust;
        long dstIndexOffset;
        long dstFixAddr;
        long dstFixOffset;
        long dstFixSize;
        int dstKFd = 0;
        int dstVFd = 0;
        int shl = ColumnType.pow2SizeOf(columnType);
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            dstFixSize = dstLen << shl;
            dstFixOffset = srcDataMax - srcDataTop << shl;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize) {
                dstFixAddr = TableUtils.mapRW(ff, Math.abs(dstFixFd), dstFixSize, 2);
            } else {
                dstFixAddr = dstFixMem.getAppendAddress() - dstFixOffset;
                dstFixSize = -dstFixSize;
            }
            dstIndexOffset = dstFixOffset;
            dstIndexAdjust = srcDataTop;
            dstFixFileOffset = dstFixOffset;
            if (indexBlockCapacity > -1 && !indexWriter.isOpen()) {
                BitmapIndexUtils.keyFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                dstKFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                BitmapIndexUtils.valueFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                dstVFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            }
        }
        catch (Throwable e) {
            LOG.error().$("append fix error [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            O3Utils.unmapAndClose(ff, dstFixFd, 0L, 0L);
            O3Utils.close(ff, dstKFd);
            O3Utils.close(ff, dstVFd);
            O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0, 0L, 0L, 0L, 0, 0L, 0L, 0L, srcOooLo, srcOooHi, srcDataTop << shl, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, 0, 0L, 0L, 0L, 0L, 0L, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
    }

    private static void appendMidPartition(Path pathToNewPartition, int pNewLen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long oldPartitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, int columnIndex, long columnNameTxn, long partitionUpdateSinkAddr) {
        int dstFixFd = 0;
        int dstVarFd = 0;
        FilesFacade ff = tableWriter.getFilesFacade();
        if (srcDataTop == -1L) {
            try {
                srcDataTop = Math.min(srcDataMax, tableWriter.getColumnTop(oldPartitionTimestamp, columnIndex, srcDataMax));
                if (srcDataTop == srcDataMax) {
                    Unsafe.getUnsafe().putLong(colTopSinkAddr, srcDataMax);
                }
            }
            catch (Throwable e) {
                LOG.error().$("append mid partition error 1 [table=").$(tableWriter.getTableToken()).$(", e=").$(e).I$();
                O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                throw e;
            }
        }
        long dstLen = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop;
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                try {
                    TableUtils.iFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                    dstFixFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    TableUtils.dFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                    dstVarFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                }
                catch (Throwable e) {
                    LOG.error().$("append mid partition error 2 [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                    O3Utils.close(ff, dstFixFd);
                    O3Utils.close(ff, dstVarFd);
                    O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                    throw e;
                }
                O3OpenColumnJob.appendVarColumn(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstVarFd, null, null, dstLen, newPartitionSize, oldPartitionSize, tableWriter, partitionUpdateSinkAddr);
                break;
            }
            case 8: {
                boolean designated = ColumnType.isDesignatedTimestamp(columnType);
                if (designated) {
                    O3OpenColumnJob.appendTimestampColumn(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, null, dstLen, newPartitionSize, oldPartitionSize, tableWriter, partitionUpdateSinkAddr);
                    break;
                }
            }
            default: {
                try {
                    TableUtils.dFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                    dstFixFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                }
                catch (Throwable e) {
                    LOG.error().$("append mid partition error 3 [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                    O3Utils.close(ff, dstFixFd);
                    O3Utils.close(ff, dstVarFd);
                    O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                    throw e;
                }
                O3OpenColumnJob.appendFixColumn(pathToNewPartition, pNewLen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, null, dstLen, tableWriter, newPartitionSize, oldPartitionSize, indexWriter, columnNameTxn, partitionUpdateSinkAddr);
            }
        }
    }

    private static void appendNewPartition(Path pathToNewPartition, int pNewLen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long srcDataMax, int indexBlockCapacity, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long columnNameTxn, long partitionUpdateSinkAddr) {
        int dstFixFd = 0;
        long dstFixAddr = 0L;
        long dstFixSize = 0L;
        int dstVarFd = 0;
        long dstVarAddr = 0L;
        long dstVarSize = 0L;
        int dstKFd = 0;
        int dstVFd = 0;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            if (ColumnType.isVariableLength(columnType)) {
                TableUtils.iFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                dstFixFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstFixSize = (srcOooHi - srcOooLo + 1L + 1L) * 8L;
                dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 2);
                TableUtils.dFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                dstVarFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstVarSize = O3Utils.getVarColumnLength(srcOooLo, srcOooHi, srcOooFixAddr);
                dstVarAddr = TableUtils.mapRW(ff, dstVarFd, dstVarSize, 2);
            } else {
                TableUtils.dFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                dstFixFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstFixSize = srcOooHi - srcOooLo + 1L << ColumnType.pow2SizeOf(Math.abs(columnType));
                dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 2);
                if (indexBlockCapacity > -1) {
                    BitmapIndexUtils.keyFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                    dstKFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    BitmapIndexUtils.valueFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                    dstVFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                }
            }
        }
        catch (Throwable e) {
            LOG.error().$("append new partition error [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            FilesFacade ff1 = tableWriter.getFilesFacade();
            O3Utils.unmapAndClose(ff1, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff1, dstVarFd, dstVarAddr, dstVarSize);
            O3Utils.close(ff1, dstKFd);
            O3Utils.close(ff1, dstVFd);
            if (columnCounter.decrementAndGet() == 0) {
                tableWriter.o3ClockDownPartitionUpdateCount();
                tableWriter.o3CountDownDoneLatch();
            }
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, timestampMergeIndexAddr, timestampMergeIndexSize, 0, 0L, 0L, 0L, 0, 0L, 0L, 0L, 0L, 0L, 0L, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, 0L, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, indexBlockCapacity, 0, 0L, 0L, false, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
    }

    private static void appendTimestampColumn(AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long srcDataMax, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, MemoryMA dstFixMem, long dstLen, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, long partitionUpdateSinkAddr) {
        long dstFixAddr;
        long dstFixFileOffset;
        long dstFixOffset;
        long dstFixSize;
        int dstFixFd = 0;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            dstFixSize = dstLen * 8L;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize) {
                dstFixFileOffset = dstFixOffset = srcDataMax * 8L;
                dstFixFd = -Math.abs(srcTimestampFd);
                dstFixAddr = TableUtils.mapRW(ff, -dstFixFd, dstFixSize, 2);
            } else {
                dstFixAddr = dstFixMem.getAppendAddress();
                dstFixOffset = 0L;
                dstFixFileOffset = dstFixMem.getAppendOffset();
                dstFixSize = -dstFixSize;
            }
        }
        catch (Throwable e) {
            LOG.error().$("append ts error [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            O3Utils.close(ff, dstFixFd);
            O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0, 0L, 0L, 0L, 0, 0L, 0L, 0L, srcOooLo, srcOooHi, 0L, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, 0, 0L, 0L, 0L, 0L, 0L, 0, 0, 0L, 0L, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, newPartitionSize, oldPartitionSize, tableWriter, null, partitionUpdateSinkAddr);
    }

    private static void appendVarColumn(AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int activeFixFd, int activeVarFd, MemoryMA dstFixMem, MemoryMA dstVarMem, long dstLen, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, long partitionUpdateSinkAddr) {
        long dstVarAdjust;
        long dstVarOffset;
        long dstFixFileOffset;
        long dstFixOffset;
        long dstFixAddr = 0L;
        long dstVarAddr = 0L;
        long dstVarSize = 0L;
        long dstFixSize = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            long l = O3Utils.getVarColumnLength(srcOooLo, srcOooHi, srcOooFixAddr);
            dstFixSize = (dstLen + 1L) * 8L;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize || dstVarMem.getAppendAddressSize() < l) {
                assert (dstFixMem == null || dstFixMem.getAppendOffset() - 8L == (srcDataMax - srcDataTop) * 8L);
                dstFixFileOffset = dstFixOffset = (srcDataMax - srcDataTop) * 8L;
                dstFixAddr = TableUtils.mapRW(ff, Math.abs(activeFixFd), dstFixSize, 2);
                dstVarOffset = dstFixOffset > 0L ? Unsafe.getUnsafe().getLong(dstFixAddr + dstFixOffset) : 0L;
                dstVarSize = l + dstVarOffset;
                dstVarAddr = TableUtils.mapRW(ff, Math.abs(activeVarFd), dstVarSize, 2);
                dstVarAdjust = 0L;
            } else {
                assert (dstFixMem.getAppendOffset() >= 8L);
                assert (dstFixMem.getAppendOffset() - 8L == (srcDataMax - srcDataTop) * 8L);
                dstFixAddr = dstFixMem.getAppendAddress() - 8L;
                dstVarAddr = dstVarMem.getAppendAddress();
                dstFixOffset = 0L;
                dstFixFileOffset = dstFixMem.getAppendOffset() - 8L;
                dstFixSize = -dstFixSize;
                dstVarOffset = 0L;
                dstVarSize = -l;
                dstVarAdjust = dstVarMem.getAppendOffset();
            }
        }
        catch (Throwable e) {
            LOG.error().$("append var error [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            O3Utils.unmapAndClose(ff, activeFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff, activeVarFd, dstVarAddr, dstVarSize);
            O3OpenColumnJob.freeTs(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0, 0L, 0L, 0L, 0, 0L, 0L, 0L, srcOooLo, srcOooHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, activeFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, activeVarFd, dstVarAddr, dstVarOffset, 0L, dstVarAdjust, dstVarSize, 0, 0, 0L, 0L, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, newPartitionSize, oldPartitionSize, tableWriter, null, partitionUpdateSinkAddr);
    }

    private static long columnTopAddress(long partitionUpdateSinkAddr, int columnIndex) {
        return partitionUpdateSinkAddr + 40L + (long)columnIndex * 8L;
    }

    private static void freeTs(AtomicInteger columnCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, FilesFacade ff) {
        tableWriter.o3BumpErrorCount();
        if (columnCounter.decrementAndGet() == 0) {
            O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
            O3Utils.close(ff, srcTimestampFd);
            tableWriter.o3ClockDownPartitionUpdateCount();
            tableWriter.o3CountDownDoneLatch();
            if (timestampMergeIndexAddr != 0L) {
                Vect.freeMergedIndex(timestampMergeIndexAddr, timestampMergeIndexSize);
            }
        }
    }

    private static void mergeFixColumn(Path pathToNewPartition, int pNewLen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionHi, long srcDataMax, long srcDataTop, int srcDataFixFd, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, long columnNameTxn, long partitionUpdateSinkAddr) {
        long dstFixAppendOffset2;
        long dstFixAppendOffset1;
        long dstIndexAdjust;
        long srcDataTopOffset;
        long srcDataFixOffset;
        int partCount = 0;
        long srcDataFixSize = 0L;
        long srcDataFixAddr = 0L;
        int dstFixFd = 0;
        long dstFixAddr = 0L;
        long dstFixSize = 0L;
        int dstKFd = 0;
        int dstVFd = 0;
        int srcFixFd = Math.abs(srcDataFixFd);
        int shl = ColumnType.pow2SizeOf(Math.abs(columnType));
        FilesFacade ff = tableWriter.getFilesFacade();
        boolean mixedIOFlag = tableWriter.allowMixedIO();
        try {
            if (srcDataTop > 0L) {
                long srcDataActualBytes = srcDataMax - srcDataTop << shl;
                long srcDataMaxBytes = srcDataMax << shl;
                if (srcDataTop > prefixHi || prefixType == 1) {
                    srcDataFixSize = srcDataActualBytes + srcDataMaxBytes;
                    srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                    ff.madvise(srcDataFixAddr, srcDataFixSize, Files.POSIX_MADV_SEQUENTIAL);
                    TableUtils.setNull(columnType, srcDataFixAddr + srcDataActualBytes, srcDataTop);
                    Vect.memcpy(srcDataFixAddr + srcDataMaxBytes, srcDataFixAddr, srcDataActualBytes);
                    srcDataTop = 0L;
                    srcDataFixOffset = srcDataActualBytes;
                } else {
                    if (prefixType != -1) {
                        Unsafe.getUnsafe().putLong(colTopSinkAddr, srcDataTop);
                    }
                    srcDataFixSize = srcDataActualBytes;
                    srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                    ff.madvise(srcDataFixAddr, srcDataFixSize, Files.POSIX_MADV_SEQUENTIAL);
                    srcDataFixOffset = 0L;
                }
            } else {
                srcDataFixSize = srcDataMax << shl;
                srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                ff.madvise(srcDataFixAddr, srcDataFixSize, Files.POSIX_MADV_SEQUENTIAL);
                srcDataFixOffset = 0L;
            }
            srcDataTopOffset = srcDataTop << shl;
            dstIndexAdjust = srcDataTopOffset >> 2;
            TableUtils.dFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
            dstFixFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            dstFixSize = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop << shl;
            dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 2);
            if (mixedIOFlag) {
                ff.fadvise(dstFixFd, 0L, dstFixSize, Files.POSIX_FADV_RANDOM);
            } else {
                ff.madvise(dstFixAddr, dstFixSize, Files.POSIX_MADV_RANDOM);
            }
            if (prefixType == 2) {
                dstFixAppendOffset1 = prefixHi - prefixLo + 1L - srcDataTop << shl;
                prefixHi -= srcDataTop;
            } else if (prefixType == -1) {
                dstFixAppendOffset1 = 0L;
                prefixHi -= srcDataTop;
                dstIndexAdjust = 0L;
            } else {
                dstFixAppendOffset1 = prefixHi - prefixLo + 1L << shl;
            }
            dstFixAppendOffset2 = mergeDataLo > -1L && mergeOOOLo > -1L ? dstFixAppendOffset1 + (mergeLen << shl) : dstFixAppendOffset1;
            if (suffixType == 2 && srcDataTop > 0L) {
                suffixHi -= srcDataTop;
                suffixLo -= srcDataTop;
            }
            if (indexBlockCapacity > -1) {
                BitmapIndexUtils.keyFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                dstKFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                BitmapIndexUtils.valueFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn);
                dstVFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            }
            if (prefixType != -1) {
                ++partCount;
            }
            if (mergeType != -1) {
                ++partCount;
            }
            if (suffixType != -1) {
                ++partCount;
            }
        }
        catch (Throwable e) {
            LOG.error().$("merge fix error [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            O3Utils.unmapAndClose(ff, srcDataFixFd, srcDataFixAddr, srcDataFixSize);
            O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.close(ff, dstKFd);
            O3Utils.close(ff, dstVFd);
            tableWriter.o3BumpErrorCount();
            if (columnCounter.decrementAndGet() == 0) {
                O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
                O3Utils.close(ff, srcTimestampFd);
                Vect.freeMergedIndex(timestampMergeIndexAddr, timestampMergeIndexSize);
                tableWriter.o3ClockDownPartitionUpdateCount();
                tableWriter.o3CountDownDoneLatch();
            }
            throw e;
        }
        partCounter.set(partCount);
        O3OpenColumnJob.publishMultiCopyTasks(columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, 0, 0L, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, dstFixFd, dstFixAddr, dstFixSize, 0, 0L, 0L, dstFixAppendOffset1, dstFixAppendOffset2, 0L, 0L, dstKFd, dstVFd, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, dstIndexAdjust, partitionUpdateSinkAddr);
    }

    private static void mergeLastPartition(Path pathToNewPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionHi, long srcDataTop, long srcDataMax, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, int activeFixFd, int activeVarFd, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, long columnNameTxn, long partitionUpdateSinkAddr) {
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                O3OpenColumnJob.mergeVarColumn(pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, srcDataTop, srcDataMax, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, -activeFixFd, -activeVarFd, newPartitionSize, oldPartitionSize, tableWriter, colTopSinkAddr, columnNameTxn, partitionUpdateSinkAddr);
                break;
            }
            default: {
                O3OpenColumnJob.mergeFixColumn(pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, srcDataMax, srcDataTop, -activeFixFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, colTopSinkAddr, columnNameTxn, partitionUpdateSinkAddr);
            }
        }
    }

    private static void mergeMidPartition(Path pathToOldPartition, int plen, Path pathToNewPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionHi, long srcDataTop, long srcDataMax, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, long oldPartitionTimestamp, int columnIndex, long columnNameTxn, long partitionUpdateSinkAddr) {
        FilesFacade ff = tableWriter.getFilesFacade();
        if (srcDataTop == -1L) {
            try {
                srcDataTop = Math.min(tableWriter.getColumnTop(oldPartitionTimestamp, columnIndex, srcDataMax), srcDataMax);
            }
            catch (Throwable e) {
                LOG.error().$("merge mid partition error 1 [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                O3OpenColumnJob.freeTs(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                throw e;
            }
        }
        int srcDataFixFd = 0;
        int srcDataVarFd = 0;
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                try {
                    TableUtils.iFile(pathToOldPartition.trimTo(plen), columnName, columnNameTxn);
                    srcDataFixFd = TableUtils.openRW(ff, pathToOldPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    TableUtils.dFile(pathToOldPartition.trimTo(plen), columnName, columnNameTxn);
                    srcDataVarFd = TableUtils.openRW(ff, pathToOldPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                }
                catch (Throwable e) {
                    LOG.error().$("merge mid partition error 2 [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                    O3Utils.close(ff, srcDataFixFd);
                    O3Utils.close(ff, srcDataVarFd);
                    O3OpenColumnJob.freeTs(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                    throw e;
                }
                O3OpenColumnJob.mergeVarColumn(pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, srcDataTop, srcDataMax, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, srcDataFixFd, srcDataVarFd, newPartitionSize, oldPartitionSize, tableWriter, colTopSinkAddr, columnNameTxn, partitionUpdateSinkAddr);
                break;
            }
            default: {
                try {
                    if (columnType < 0 && srcTimestampFd > 0) {
                        srcDataFixFd = -srcTimestampFd;
                    } else {
                        TableUtils.dFile(pathToOldPartition.trimTo(plen), columnName, columnNameTxn);
                        srcDataFixFd = TableUtils.openRW(ff, pathToOldPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    }
                }
                catch (Throwable e) {
                    LOG.error().$("merge mid partition error 3 [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                    O3OpenColumnJob.freeTs(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff);
                    throw e;
                }
                O3OpenColumnJob.mergeFixColumn(pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, srcDataMax, srcDataTop, srcDataFixFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, indexBlockCapacity, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, colTopSinkAddr, columnNameTxn, partitionUpdateSinkAddr);
            }
        }
    }

    private static void mergeVarColumn(Path pathToNewPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionHi, long srcDataTop, long srcDataMax, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int srcDataFixFd, int srcDataVarFd, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, long colTopSinkAddr, long columnNameTxn, long partitionUpdateSinkAddr) {
        long dstVarAppendOffset2;
        long dstFixAppendOffset2;
        long dstFixAppendOffset1;
        long srcDataTopOffset;
        long srcDataFixOffset;
        int partCount = 0;
        int dstVarFd = 0;
        long dstVarAddr = 0L;
        long srcDataFixAddr = 0L;
        long dstVarSize = 0L;
        long dstFixSize = 0L;
        long srcDataFixSize = 0L;
        long srcDataVarSize = 0L;
        int dstFixFd = 0;
        long dstFixAddr = 0L;
        long srcDataVarAddr = 0L;
        long srcDataVarOffset = 0L;
        long dstVarAppendOffset1 = 0L;
        int srcFixFd = Math.abs(srcDataFixFd);
        int srcVarFd = Math.abs(srcDataVarFd);
        FilesFacade ff = tableWriter.getFilesFacade();
        boolean mixedIOFlag = tableWriter.allowMixedIO();
        long initialSrcDataTop = srcDataTop;
        try {
            pathToNewPartition.trimTo(pplen);
            if (srcDataTop > 0L) {
                long srcDataActualBytes = (srcDataMax - srcDataTop) * 8L;
                long srcDataMaxBytes = srcDataMax * 8L;
                if (srcDataTop > prefixHi || prefixType == 1) {
                    srcDataFixSize = srcDataActualBytes + 8L + srcDataMaxBytes + 8L;
                    srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                    ff.madvise(srcDataFixAddr, srcDataFixSize, Files.POSIX_MADV_SEQUENTIAL);
                    if (srcDataActualBytes > 0L) {
                        srcDataVarSize = Unsafe.getUnsafe().getLong(srcDataFixAddr + srcDataActualBytes);
                    }
                    srcDataVarOffset = srcDataVarSize;
                    long reservedBytesForColTopNulls = srcDataTop * (long)(ColumnType.isString(columnType) ? 4 : 8);
                    srcDataVarSize += reservedBytesForColTopNulls + srcDataVarSize;
                    srcDataVarAddr = TableUtils.mapRW(ff, srcVarFd, srcDataVarSize, 2);
                    ff.madvise(srcDataVarAddr, srcDataVarSize, Files.POSIX_MADV_SEQUENTIAL);
                    Vect.memset(srcDataVarAddr + srcDataVarOffset, (int)reservedBytesForColTopNulls, -1);
                    Vect.memcpy(srcDataVarAddr + srcDataVarOffset + reservedBytesForColTopNulls, srcDataVarAddr, srcDataVarOffset);
                    long hiInclusive = srcDataMax - srcDataTop;
                    assert (srcDataFixSize >= srcDataMaxBytes + (hiInclusive + 1L) * 8L);
                    O3Utils.shiftCopyFixedSizeColumnData(-reservedBytesForColTopNulls, srcDataFixAddr, 0L, hiInclusive, srcDataFixAddr + srcDataMaxBytes + 8L);
                    if (ColumnType.isString(columnType)) {
                        Vect.setVarColumnRefs32Bit(srcDataFixAddr + srcDataActualBytes + 8L, 0L, srcDataTop);
                    } else {
                        Vect.setVarColumnRefs64Bit(srcDataFixAddr + srcDataActualBytes + 8L, 0L, srcDataTop);
                    }
                    srcDataTop = 0L;
                    srcDataFixOffset = srcDataActualBytes + 8L;
                } else {
                    if (prefixType != -1) {
                        Unsafe.getUnsafe().putLong(colTopSinkAddr, srcDataTop);
                    }
                    srcDataFixSize = srcDataActualBytes + 8L;
                    srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                    ff.madvise(srcDataFixAddr, srcDataFixSize, Files.POSIX_MADV_SEQUENTIAL);
                    srcDataFixOffset = 0L;
                    srcDataVarSize = Unsafe.getUnsafe().getLong(srcDataFixAddr + srcDataFixSize - 8L);
                    srcDataVarAddr = TableUtils.mapRO(ff, srcVarFd, srcDataVarSize, 2);
                    ff.madvise(srcDataVarAddr, srcDataVarSize, Files.POSIX_MADV_SEQUENTIAL);
                }
            } else {
                srcDataFixSize = (srcDataMax + 1L) * 8L;
                srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 2);
                ff.madvise(srcDataFixAddr, srcDataFixSize, Files.POSIX_MADV_SEQUENTIAL);
                srcDataFixOffset = 0L;
                srcDataVarSize = Unsafe.getUnsafe().getLong(srcDataFixAddr + srcDataFixSize - 8L);
                srcDataVarAddr = TableUtils.mapRO(ff, srcVarFd, srcDataVarSize, 2);
                ff.madvise(srcDataVarAddr, srcDataVarSize, Files.POSIX_MADV_SEQUENTIAL);
            }
            srcDataTopOffset = srcDataTop * 8L;
            TableUtils.iFile(pathToNewPartition.trimTo(pplen), columnName, columnNameTxn);
            dstFixFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            dstFixSize = (srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop + 1L) * 8L;
            if (prefixType == -1) {
                dstFixSize -= (prefixHi - srcDataTop + 1L) * 8L;
            }
            dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 2);
            if (mixedIOFlag) {
                ff.fadvise(dstFixFd, 0L, dstFixSize, Files.POSIX_FADV_RANDOM);
            } else {
                ff.madvise(dstFixAddr, dstFixSize, Files.POSIX_MADV_RANDOM);
            }
            TableUtils.dFile(pathToNewPartition.trimTo(pplen), columnName, columnNameTxn);
            dstVarFd = TableUtils.openRW(ff, pathToNewPartition, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            dstVarSize = srcDataVarSize - srcDataVarOffset + O3Utils.getVarColumnLength(srcOooLo, srcOooHi, srcOooFixAddr);
            if (prefixType == -1 && prefixHi > initialSrcDataTop) {
                assert (prefixLo == 0L);
                dstVarSize -= O3Utils.getVarColumnLength(prefixLo, prefixHi - initialSrcDataTop, srcDataFixAddr);
            }
            dstVarAddr = TableUtils.mapRW(ff, dstVarFd, dstVarSize, 2);
            if (mixedIOFlag) {
                ff.fadvise(dstVarFd, 0L, dstVarSize, Files.POSIX_FADV_RANDOM);
            } else {
                ff.madvise(dstVarAddr, dstVarSize, Files.POSIX_MADV_RANDOM);
            }
            if (prefixType == 2) {
                dstFixAppendOffset1 = (prefixHi - prefixLo + 1L - srcDataTop) * 8L;
                prefixHi -= srcDataTop;
            } else {
                dstFixAppendOffset1 = prefixType == -1 ? 0L : (prefixHi - prefixLo + 1L) * 8L;
            }
            if (suffixType == 2 && srcDataTop > 0L) {
                suffixHi -= srcDataTop;
                suffixLo -= srcDataTop;
            }
            switch (prefixType) {
                case 1: {
                    dstVarAppendOffset1 = O3Utils.getVarColumnLength(prefixLo, prefixHi, srcOooFixAddr);
                    ++partCount;
                    break;
                }
                case 2: {
                    dstVarAppendOffset1 = O3Utils.getVarColumnLength(prefixLo, prefixHi, srcDataFixAddr + srcDataFixOffset);
                    ++partCount;
                    break;
                }
            }
            if (mergeDataLo > -1L && mergeOOOLo > -1L) {
                long oooLen = O3Utils.getVarColumnLength(mergeOOOLo, mergeOOOHi, srcOooFixAddr);
                long dataLen = O3Utils.getVarColumnLength(mergeDataLo, mergeDataHi, srcDataFixAddr + srcDataFixOffset - srcDataTop * 8L);
                dstFixAppendOffset2 = dstFixAppendOffset1 + mergeLen * 8L;
                dstVarAppendOffset2 = dstVarAppendOffset1 + oooLen + dataLen;
            } else {
                dstFixAppendOffset2 = dstFixAppendOffset1;
                dstVarAppendOffset2 = dstVarAppendOffset1;
            }
            if (mergeType != -1) {
                ++partCount;
            }
            if (suffixType != -1) {
                ++partCount;
            }
        }
        catch (Throwable e) {
            LOG.error().$("merge var error [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            O3CopyJob.copyIdleQuick(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, 0, 0, tableWriter);
            throw e;
        }
        partCounter.set(partCount);
        O3OpenColumnJob.publishMultiCopyTasks(columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstFixAppendOffset1, dstFixAppendOffset2, dstVarAppendOffset1, dstVarAppendOffset2, 0, 0, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, newPartitionSize, oldPartitionSize, tableWriter, null, srcDataTopOffset >> 2, partitionUpdateSinkAddr);
    }

    private static void publishCopyTask(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, int srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long partitionTimestamp, int dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, int dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarOffsetEnd, long dstVarAdjust, long dstVarSize, int dstKFd, int dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr) {
        long cursor = tableWriter.getO3CopyPubSeq().next();
        if (cursor > -1L) {
            O3OpenColumnJob.publishCopyTaskHarmonized(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, cursor, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        } else {
            O3OpenColumnJob.publishCopyTaskContended(cursor, columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataTop, srcDataLo, srcDataHi, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        }
    }

    private static void publishCopyTaskContended(long cursor, AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, int srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataTop, long srcDataLo, long srcDataHi, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long partitionTimestamp, int dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, int dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarOffsetEnd, long dstVarAdjust, long dstVarSize, int dstKFd, int dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr) {
        while (cursor == -2L) {
            cursor = tableWriter.getO3CopyPubSeq().next();
        }
        if (cursor == -1L) {
            O3CopyJob.copy(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        } else {
            O3OpenColumnJob.publishCopyTaskHarmonized(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, cursor, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        }
    }

    private static void publishCopyTaskHarmonized(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, int srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long partitionTimestamp, int dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, int dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarOffsetEnd, long dstVarAdjust, long dstVarSize, int dstKFd, int dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, long cursor, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr) {
        O3CopyTask task = tableWriter.getO3CopyQueue().get(cursor);
        task.of(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        tableWriter.getO3CopyPubSeq().done(cursor);
    }

    private static void publishMultiCopyTasks(AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, int srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataTopOffset, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, int dstFixFd, long dstFixAddr, long dstFixSize, int dstVarFd, long dstVarAddr, long dstVarSize, long dstFixAppendOffset1, long dstFixAppendOffset2, long dstVarAppendOffset1, long dstVarAppendOffset2, int dstKFd, int dstVFd, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long newPartitionSize, long oldPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long dstIndexAdjust, long partitionUpdateSinkAddr) {
        boolean partitionMutates = true;
        switch (prefixType) {
            case 1: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, prefixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, prefixLo, prefixHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, 0L, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                break;
            }
            case 2: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, prefixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, prefixLo, prefixHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, 0L, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                break;
            }
        }
        switch (mergeType) {
            case 1: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, mergeType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, mergeOOOLo, mergeOOOHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset1, dstFixAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset1, dstVarAppendOffset2, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                break;
            }
            case 2: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, mergeType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, mergeDataLo, mergeDataHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset1, dstFixAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset1, dstVarAppendOffset2, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                break;
            }
            case 3: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, mergeType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, mergeDataLo, mergeDataHi, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, mergeOOOLo, mergeOOOHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset1, dstFixAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset1, dstVarAppendOffset2, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                break;
            }
        }
        switch (suffixType) {
            case 1: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, suffixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, suffixLo, suffixHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset2, dstFixAppendOffset2, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset2, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                break;
            }
            case 2: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, suffixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, suffixLo, suffixHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset2, dstFixAppendOffset2, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset2, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, newPartitionSize, oldPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                break;
            }
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        O3OpenColumnJob.openColumn((O3OpenColumnTask)this.queue.get(cursor), cursor, this.subSeq);
        return true;
    }
}

