/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.SymbolCountProvider;
import io.questdb.cairo.SymbolValueCountCollector;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.Path;

public interface MapWriter
extends SymbolCountProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSymbolMapFiles(FilesFacade ff, MemoryMA mem, Path path, CharSequence columnName, long columnNameTxn, int symbolCapacity, boolean symbolCacheFlag) {
        int plen = path.length();
        try {
            mem.smallFile(ff, TableUtils.offsetFileName(path.trimTo(plen), columnName, columnNameTxn), 14);
            mem.jumpTo(0L);
            mem.putInt(symbolCapacity);
            mem.putBool(symbolCacheFlag);
            mem.jumpTo(64L);
            mem.sync(false);
            mem.close(false);
            if (!ff.touch(TableUtils.charFileName(path.trimTo(plen), columnName, columnNameTxn))) {
                throw CairoException.critical(ff.errno()).put("Cannot create ").put(path);
            }
            mem.smallFile(ff, BitmapIndexUtils.keyFileName(path.trimTo(plen), columnName, columnNameTxn), 14);
            BitmapIndexWriter.initKeyMemory(mem, TableUtils.MIN_INDEX_VALUE_BLOCK_SIZE);
            mem.sync(false);
            ff.touch(BitmapIndexUtils.valueFileName(path.trimTo(plen), columnName, columnNameTxn));
        }
        finally {
            mem.close(false);
            path.trimTo(plen);
        }
    }

    public void sync(boolean var1);

    public boolean getNullFlag();

    public int getSymbolCapacity();

    public boolean isCached();

    public int put(char var1);

    public int put(CharSequence var1);

    public int put(CharSequence var1, SymbolValueCountCollector var2);

    public void rollback(int var1);

    public void setSymbolIndexInTxWriter(int var1);

    public void truncate();

    public void updateCacheFlag(boolean var1);

    public void updateNullFlag(boolean var1);
}

