/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class IDGenerator
implements Closeable {
    private final CairoConfiguration configuration;
    private final String uniqueIdFileName;
    private final long uniqueIdMemSize;
    private int uniqueIdFd = -1;
    private long uniqueIdMem = 0L;

    public IDGenerator(CairoConfiguration configuration, String uniqueIdFileName) {
        this.configuration = configuration;
        this.uniqueIdFileName = uniqueIdFileName;
        this.uniqueIdMemSize = Files.PAGE_SIZE;
    }

    @Override
    public void close() {
        FilesFacade ff = this.configuration.getFilesFacade();
        if (this.uniqueIdMem != 0L) {
            ff.munmap(this.uniqueIdMem, this.uniqueIdMemSize, 0);
            this.uniqueIdMem = 0L;
        }
        if (ff.close(this.uniqueIdFd)) {
            this.uniqueIdFd = -1;
        }
    }

    public long getNextId() {
        long next;
        long x = this.getCurrentId();
        while ((next = x) != (x = Os.compareAndSwap(this.uniqueIdMem, next, next + 1L))) {
        }
        return next + 1L;
    }

    public void open() {
        this.open(null);
    }

    public void open(Path path) {
        this.close();
        if (path == null) {
            path = Path.getThreadLocal(this.configuration.getRoot());
        }
        int rootLen = path.length();
        try {
            path.concat(this.uniqueIdFileName).$();
            FilesFacade ff = this.configuration.getFilesFacade();
            this.uniqueIdFd = TableUtils.openFileRWOrFail(ff, path, this.configuration.getWriterFileOpenOpts());
            this.uniqueIdMem = TableUtils.mapRW(ff, this.uniqueIdFd, this.uniqueIdMemSize, 0);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    public void reset() {
        Unsafe.getUnsafe().putLong(this.uniqueIdMem, 0L);
    }

    long getCurrentId() {
        assert (this.uniqueIdMem > 0L);
        return Unsafe.getUnsafe().getLong(this.uniqueIdMem);
    }
}

