/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractFullDataFrameCursor;
import io.questdb.cairo.sql.DataFrame;
import org.jetbrains.annotations.Nullable;

public class FullFwdDataFrameCursor
extends AbstractFullDataFrameCursor {
    private int skipToPartitionIndex = -1;
    private long skipToPosition = -1L;

    @Override
    @Nullable
    public DataFrame next() {
        while (this.partitionIndex < this.partitionHi) {
            long hi = this.getTableReader().openPartition(this.partitionIndex);
            if (hi < 1L) {
                ++this.partitionIndex;
                continue;
            }
            this.frame.partitionIndex = this.partitionIndex++;
            this.frame.rowLo = 0L;
            this.frame.rowHi = hi;
            return this.frame;
        }
        return null;
    }

    @Override
    @Nullable
    public DataFrame skipTo(long rowCount) {
        int partitionCount = this.getTableReader().getPartitionCount();
        if (partitionCount < 1) {
            return null;
        }
        if (this.skipToPartitionIndex == -1) {
            this.skipToPosition = rowCount;
            this.skipToPartitionIndex = 0;
        }
        long partitionRows = 0L;
        while (this.skipToPartitionIndex < partitionCount) {
            partitionRows = this.getTableReader().openPartition(this.skipToPartitionIndex);
            if (partitionRows < 0L) {
                ++this.skipToPartitionIndex;
                continue;
            }
            if (partitionRows > this.skipToPosition) break;
            if (this.skipToPartitionIndex == partitionCount - 1) {
                this.skipToPosition = partitionRows;
                break;
            }
            this.skipToPosition -= partitionRows;
            ++this.skipToPartitionIndex;
        }
        this.frame.partitionIndex = this.skipToPartitionIndex;
        this.frame.rowHi = partitionRows;
        this.frame.rowLo = this.skipToPosition;
        this.partitionIndex = this.skipToPartitionIndex + 1;
        this.skipToPosition = -1L;
        this.skipToPartitionIndex = -1;
        return this.frame;
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }

    @Override
    public void toTop() {
        this.partitionIndex = 0;
        this.skipToPosition = -1L;
        this.skipToPartitionIndex = -1;
    }
}

