/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Unsafe;

public class DebugUtils {
    public static final Log LOG = LogFactory.getLog(DebugUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAscendingTimestamp(FilesFacade ff, long size, int fd) {
        if (size > 0L) {
            long buffer = TableUtils.mapAppendColumnBuffer(ff, fd, 0L, size * 8L, false, 0);
            try {
                long ts = Long.MIN_VALUE;
                int i = 0;
                while ((long)i < size) {
                    long nextTs = Unsafe.getUnsafe().getLong(buffer + (long)i * 8L);
                    if (nextTs < ts) {
                        boolean bl = false;
                        return bl;
                    }
                    ts = nextTs;
                    ++i;
                }
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(ff, buffer, 0L, size * 8L, 0);
            }
        }
        return true;
    }

    public static boolean reconcileColumnTops(int partitionsSlotSize, LongList openPartitionInfo, ColumnVersionReader columnVersionReader, TableReader reader) {
        int partitionCount = reader.getPartitionCount();
        for (int p = 0; p < partitionCount; ++p) {
            long partitionRowCount = reader.getPartitionRowCount(p);
            if (partitionRowCount == -1L) continue;
            long partitionTimestamp = openPartitionInfo.getQuick(p * partitionsSlotSize);
            for (int c = 0; c < reader.getColumnCount(); ++c) {
                long colTop = Math.min(reader.getColumnTop(reader.getColumnBase(p), c), partitionRowCount);
                long columnTopRaw = columnVersionReader.getColumnTop(partitionTimestamp, c);
                long columnTop = Math.min(columnTopRaw == -1L ? partitionRowCount : columnTopRaw, partitionRowCount);
                if (columnTop == colTop) continue;
                LOG.criticalW().$("failed to reconcile column top [partition=").$ts(partitionTimestamp).$(", column=").$(c).$(", expected=").$(columnTop).$(", actual=").$(colTop).$(']').$();
                return false;
            }
        }
        return true;
    }
}

