/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;

public class ColumnVersionWriter
extends ColumnVersionReader {
    private final MemoryCMARW mem;
    private boolean hasChanges;
    private long size;
    private long version;
    private final CairoConfiguration configuration;

    public ColumnVersionWriter(CairoConfiguration configuration, LPSZ fileName) {
        FilesFacade ff = configuration.getFilesFacade();
        this.mem = Vm.getCMARWInstance(ff, fileName, ff.getPageSize(), 0L, 7, 0L);
        this.configuration = configuration;
        this.size = this.mem.size();
        super.ofRO(this.mem);
        if (this.size > 0L) {
            this.version = super.readUnsafe();
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.mem.close(false);
    }

    public void commit() {
        if (!this.hasChanges) {
            return;
        }
        this.doCommit();
        this.hasChanges = false;
    }

    public void copyPartition(long partitionTimestamp, ColumnVersionReader source) {
        LongList src = source.cachedList;
        LongList dest = this.cachedList;
        int srcIndex = src.binarySearchBlock(BLOCK_SIZE_MSB, partitionTimestamp, -1);
        if (srcIndex < 0) {
            return;
        }
        int index = dest.binarySearchBlock(BLOCK_SIZE_MSB, partitionTimestamp, -1);
        if ((long)index > -1L) {
            this.removePartition(partitionTimestamp);
            index = dest.binarySearchBlock(BLOCK_SIZE_MSB, partitionTimestamp, -1);
        }
        if (index >= 0) {
            throw CairoException.critical(0).put("invalid Column Version state ").ts(partitionTimestamp).put(" column version state, cannot update partition information");
        }
        index = -index - 1;
        int srcEnd = src.binarySearchBlock(srcIndex, BLOCK_SIZE_MSB, partitionTimestamp, 1);
        dest.insertFromSource(index, src, srcIndex, srcEnd + 4);
        this.hasChanges = true;
    }

    public long getOffsetA() {
        return this.mem.getLong(8L);
    }

    public long getOffsetB() {
        return this.mem.getLong(24L);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    @Override
    public long readUnsafe() {
        this.hasChanges = false;
        this.version = super.readUnsafe();
        return this.version;
    }

    public void removeColumnTop(long partitionTimestamp, int columnIndex) {
        int recordIndex = this.getRecordIndex(partitionTimestamp, columnIndex);
        if (recordIndex >= 0) {
            this.cachedList.setQuick(recordIndex + 3, 0L);
            this.hasChanges = true;
        }
    }

    public void removePartition(long partitionTimestamp) {
        int from = this.cachedList.binarySearchBlock(BLOCK_SIZE_MSB, partitionTimestamp, -1);
        if (from > -1) {
            int to = this.cachedList.binarySearchBlock(from, BLOCK_SIZE_MSB, partitionTimestamp, 1);
            int len = to - from + 4;
            this.cachedList.removeIndexBlock(from, len);
            this.hasChanges = true;
        }
    }

    public void truncate() {
        if (this.cachedList.size() > 0) {
            int from = this.cachedList.binarySearchBlock(BLOCK_SIZE_MSB, -9223372036854775807L, -1);
            if (from < 0) {
                from = -from - 1;
            }
            if (from < this.cachedList.size()) {
                this.cachedList.setPos(from);
            }
            int n = this.cachedList.size();
            for (int i = 0; i < n; i += 4) {
                this.cachedList.setQuick(i + 3, Long.MIN_VALUE);
            }
            this.hasChanges = true;
            this.commit();
        }
    }

    public void upsert(long timestamp, int columnIndex, long txn, long columnTop) {
        int index;
        int sz = this.cachedList.size();
        boolean insert = true;
        if (index > -1) {
            for (index = this.cachedList.binarySearchBlock(BLOCK_SIZE_MSB, timestamp, -1); index < sz && this.cachedList.getQuick(index) == timestamp; index += 4) {
                long thisIndex = this.cachedList.getQuick(index + 1);
                if (thisIndex == (long)columnIndex) {
                    if (txn > -1L) {
                        this.cachedList.setQuick(index + 2, txn);
                    }
                    this.cachedList.setQuick(index + 3, columnTop);
                    insert = false;
                } else if (thisIndex <= (long)columnIndex) {
                    continue;
                }
                break;
            }
        } else {
            index = -index - 1;
        }
        if (insert) {
            if (index < sz) {
                this.cachedList.insert(index, 4);
            } else {
                this.cachedList.setPos(Math.max(index + 4, sz + 4));
            }
            this.cachedList.setQuick(index, timestamp);
            this.cachedList.setQuick(index + 1, columnIndex);
            this.cachedList.setQuick(index + 2, txn);
            this.cachedList.setQuick(index + 3, columnTop);
        }
        this.hasChanges = true;
    }

    public void upsertColumnTop(long partitionTimestamp, int columnIndex, long colTop) {
        int recordIndex = this.getRecordIndex(partitionTimestamp, columnIndex);
        if ((long)recordIndex > -1L) {
            this.cachedList.setQuick(recordIndex + 3, colTop);
            this.hasChanges = true;
        } else {
            int defaultRecordIndex = this.getRecordIndex(Long.MIN_VALUE, columnIndex);
            if (defaultRecordIndex >= 0) {
                long columnNameTxn = this.cachedList.getQuick(defaultRecordIndex + 2);
                long defaultPartitionTimestamp = this.cachedList.getQuick(defaultRecordIndex + 3);
                if (defaultPartitionTimestamp > partitionTimestamp || colTop > 0L) {
                    this.upsert(partitionTimestamp, columnIndex, columnNameTxn, colTop);
                }
            } else if (colTop > 0L) {
                this.upsert(partitionTimestamp, columnIndex, -1L, colTop);
            }
        }
    }

    public void upsertDefaultTxnName(int columnIndex, long columnNameTxn, long partitionTimestamp) {
        this.upsert(Long.MIN_VALUE, columnIndex, columnNameTxn, partitionTimestamp);
    }

    private void bumpFileSize(long size) {
        this.mem.setSize(size);
        this.size = size;
    }

    private long calculateSize(int entryCount) {
        return (long)entryCount * 32L;
    }

    private long calculateWriteOffset(long areaSize) {
        boolean currentIsA = this.isCurrentA();
        long currentOffset = currentIsA ? this.getOffsetA() : this.getOffsetB();
        if (40L + areaSize <= (currentOffset = Math.max(currentOffset, 40L))) {
            return 40L;
        }
        long currentSize = currentIsA ? this.getSizeA() : this.getSizeB();
        return currentOffset + currentSize;
    }

    private void doCommit() {
        int entryCount = this.cachedList.size() / 4;
        long areaSize = this.calculateSize(entryCount);
        long writeOffset = this.calculateWriteOffset(areaSize);
        this.bumpFileSize(writeOffset + areaSize);
        this.store(entryCount, writeOffset);
        if (this.isCurrentA()) {
            this.updateB(writeOffset, areaSize);
        } else {
            this.updateA(writeOffset, areaSize);
        }
        Unsafe.getUnsafe().storeFence();
        this.storeNewVersion();
        int commitMode = this.configuration.getCommitMode();
        if (commitMode != 2) {
            this.mem.sync(commitMode == 0);
        }
    }

    private long getSizeA() {
        return this.mem.getLong(16L);
    }

    private long getSizeB() {
        return this.mem.getLong(32L);
    }

    private boolean isCurrentA() {
        return (this.version & 1L) == 0L;
    }

    private void store(int entryCount, long offset) {
        for (int i = 0; i < entryCount; ++i) {
            int x = i * 4;
            this.mem.putLong(offset, this.cachedList.getQuick(x));
            this.mem.putLong(offset + 8L, this.cachedList.getQuick(x + 1));
            this.mem.putLong(offset + 16L, this.cachedList.getQuick(x + 2));
            this.mem.putLong(offset + 24L, this.cachedList.getQuick(x + 3));
            offset += 32L;
        }
    }

    private void storeNewVersion() {
        this.mem.putLong(0L, ++this.version);
    }

    private void updateA(long aOffset, long aSize) {
        this.mem.putLong(8L, aOffset);
        this.mem.putLong(16L, aSize);
    }

    private void updateB(long bOffset, long bSize) {
        this.mem.putLong(24L, bOffset);
        this.mem.putLong(32L, bSize);
    }
}

