/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.MessageBusImpl;
import io.questdb.Metrics;
import io.questdb.Telemetry;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.IDGenerator;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableConverter;
import io.questdb.cairo.TableNameRegistry;
import io.questdb.cairo.TableNameRegistryRO;
import io.questdb.cairo.TableNameRegistryRW;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.mig.EngineMigration;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.MetadataPool;
import io.questdb.cairo.pool.PoolListener;
import io.questdb.cairo.pool.ReaderPool;
import io.questdb.cairo.pool.WalWriterPool;
import io.questdb.cairo.pool.WriterPool;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.wal.WalReader;
import io.questdb.cairo.wal.WalWriter;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.cutlass.text.CopyContext;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.mp.Sequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.TelemetryTask;
import io.questdb.tasks.TelemetryWalTask;
import io.questdb.tasks.WalTxnNotificationTask;
import java.io.Closeable;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CairoEngine
implements Closeable,
WriterSource {
    public static final String BUSY_READER = "busyReader";
    private static final Log LOG = LogFactory.getLog(CairoEngine.class);
    private final AtomicLong asyncCommandCorrelationId = new AtomicLong();
    private final CairoConfiguration configuration;
    private final CopyContext copyContext;
    private final EngineMaintenanceJob engineMaintenanceJob;
    private final FunctionFactoryCache ffCache;
    private final MessageBusImpl messageBus;
    private final MetadataPool metadataPool;
    private final Metrics metrics;
    private final ReaderPool readerPool;
    private final IDGenerator tableIdGenerator;
    private final TableNameRegistry tableNameRegistry;
    private final TableSequencerAPI tableSequencerAPI;
    private final Telemetry<TelemetryTask> telemetry;
    private final Telemetry<TelemetryWalTask> telemetryWal;
    private final AtomicLong unpublishedWalTxnCount = new AtomicLong(1L);
    private final WalWriterPool walWriterPool;
    private final WriterPool writerPool;

    public CairoEngine(CairoConfiguration configuration) {
        this(configuration, Metrics.disabled());
    }

    public CairoEngine(CairoConfiguration configuration, Metrics metrics) {
        ObjList<TableToken> convertedTables;
        this.ffCache = new FunctionFactoryCache(configuration, ServiceLoader.load(FunctionFactory.class, FunctionFactory.class.getClassLoader()));
        this.configuration = configuration;
        this.copyContext = new CopyContext(configuration);
        this.metrics = metrics;
        this.tableSequencerAPI = new TableSequencerAPI(this, configuration);
        this.messageBus = new MessageBusImpl(configuration);
        this.writerPool = new WriterPool(configuration, this.messageBus, metrics);
        this.readerPool = new ReaderPool(configuration, this.messageBus);
        this.metadataPool = new MetadataPool(configuration, this);
        this.walWriterPool = new WalWriterPool(configuration, this);
        this.engineMaintenanceJob = new EngineMaintenanceJob(configuration);
        this.telemetry = new Telemetry<TelemetryTask>(TelemetryTask.TELEMETRY, configuration);
        this.telemetryWal = new Telemetry<TelemetryWalTask>(TelemetryWalTask.WAL_TELEMETRY, configuration);
        this.tableIdGenerator = new IDGenerator(configuration, "_tab_index.d");
        try {
            this.tableIdGenerator.open();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        try {
            DatabaseSnapshotAgent.recoverSnapshot(this);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        try {
            EngineMigration.migrateEngineTo(this, 426, 427, false);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        try {
            convertedTables = TableConverter.convertTables(configuration, this.tableSequencerAPI);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        try {
            this.tableNameRegistry = configuration.isReadOnlyInstance() ? new TableNameRegistryRO(configuration) : new TableNameRegistryRW(configuration);
            this.tableNameRegistry.reloadTableNameCache(convertedTables);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        if (convertedTables != null) {
            int n = convertedTables.size();
            for (int i = 0; i < n; ++i) {
                TableToken token = convertedTables.get(i);
                try (TableWriter writer = this.getWriter(token, "tableTypeConversion");){
                    writer.commitSeqTxn(0L);
                    continue;
                }
            }
        }
    }

    public boolean clear() {
        boolean b1 = this.readerPool.releaseAll();
        boolean b2 = this.writerPool.releaseAll();
        boolean b3 = this.tableSequencerAPI.releaseAll();
        boolean b4 = this.metadataPool.releaseAll();
        boolean b5 = this.walWriterPool.releaseAll();
        this.messageBus.reset();
        return b1 & b2 & b3 & b4 & b5;
    }

    @Override
    public void close() {
        Misc.free(this.writerPool);
        Misc.free(this.readerPool);
        Misc.free(this.metadataPool);
        Misc.free(this.walWriterPool);
        Misc.free(this.tableIdGenerator);
        Misc.free(this.messageBus);
        Misc.free(this.tableSequencerAPI);
        Misc.free(this.telemetry);
        Misc.free(this.telemetryWal);
        Misc.free(this.tableNameRegistry);
    }

    public void closeNameRegistry() {
        this.tableNameRegistry.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TableToken createTable(SecurityContext securityContext, MemoryMARW mem, Path path, boolean ifNotExists, TableStructure struct, boolean keepLock) {
        TableToken tableToken;
        block16: {
            securityContext.authorizeTableCreate();
            CharSequence tableName = struct.getTableName();
            this.validNameOrThrow(tableName);
            int tableId = (int)this.tableIdGenerator.getNextId();
            tableToken = this.lockTableName(tableName, tableId, struct.isWalEnabled());
            if (tableToken == null) {
                if (ifNotExists) {
                    return this.getTableTokenIfExists(tableName);
                }
                throw EntryUnavailableException.instance("table exists");
            }
            try {
                String lockedReason = this.lock(tableToken, "createTable");
                if (lockedReason == null) {
                    boolean tableCreated = false;
                    try {
                        if (1 != TableUtils.exists(this.configuration.getFilesFacade(), path, this.configuration.getRoot(), tableToken.getDirName())) {
                            throw CairoException.nonCritical().put("name is reserved [table=").put(tableToken.getTableName()).put(']');
                        }
                        this.createTableUnsafe(mem, path, struct, tableToken);
                        tableCreated = true;
                    }
                    finally {
                        if (!keepLock) {
                            this.unlockTableUnsafe(tableToken, null, tableCreated);
                            LOG.info().$("unlocked [table=`").$(tableToken).$("`]").$();
                        }
                    }
                    this.tableNameRegistry.registerName(tableToken);
                    break block16;
                }
                if (!ifNotExists) {
                    throw EntryUnavailableException.instance(lockedReason);
                }
            }
            catch (Throwable th) {
                if (struct.isWalEnabled()) {
                    this.tableSequencerAPI.dropTable(tableToken, true);
                }
                throw th;
            }
            finally {
                this.tableNameRegistry.unlockTableName(tableToken);
            }
        }
        return tableToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TableToken createTableInVolume(SecurityContext securityContext, MemoryMARW mem, Path path, boolean ifNotExists, TableStructure struct, boolean keepLock) {
        TableToken tableToken;
        block16: {
            securityContext.authorizeTableCreate();
            CharSequence tableName = struct.getTableName();
            this.validNameOrThrow(tableName);
            int tableId = (int)this.tableIdGenerator.getNextId();
            tableToken = this.lockTableName(tableName, tableId, struct.isWalEnabled());
            if (tableToken == null) {
                if (ifNotExists) {
                    return this.getTableTokenIfExists(tableName);
                }
                throw EntryUnavailableException.instance("table exists");
            }
            try {
                String lockedReason = this.lock(tableToken, "createTable");
                if (null == lockedReason) {
                    boolean tableCreated = false;
                    try {
                        if (1 != TableUtils.existsInVolume(this.configuration.getFilesFacade(), path, tableToken.getDirName())) {
                            throw CairoException.nonCritical().put("name is reserved [table=").put(tableToken.getTableName()).put(']');
                        }
                        this.createTableInVolumeUnsafe(mem, path, struct, tableToken);
                        tableCreated = true;
                    }
                    finally {
                        if (!keepLock) {
                            this.unlockTableUnsafe(tableToken, null, tableCreated);
                            LOG.info().$("unlocked [table=`").$(tableToken).$("`]").$();
                        }
                    }
                    this.tableNameRegistry.registerName(tableToken);
                    break block16;
                }
                if (!ifNotExists) {
                    throw EntryUnavailableException.instance(lockedReason);
                }
            }
            catch (Throwable th) {
                if (struct.isWalEnabled()) {
                    this.tableSequencerAPI.dropTable(tableToken, true);
                }
                throw th;
            }
            finally {
                this.tableNameRegistry.unlockTableName(tableToken);
            }
        }
        return tableToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(Path path, TableToken tableToken) {
        this.verifyTableToken(tableToken);
        if (tableToken.isWal()) {
            if (this.tableNameRegistry.dropTable(tableToken)) {
                this.tableSequencerAPI.dropTable(tableToken, false);
            } else {
                LOG.info().$("table is already dropped [table=").$(tableToken).$(", dirName=").$(tableToken.getDirName()).I$();
            }
        } else {
            String lockedReason = this.lock(tableToken, "removeTable");
            if (lockedReason == null) {
                try {
                    path.of(this.configuration.getRoot()).concat(tableToken).$();
                    int errno = this.configuration.getFilesFacade().unlinkOrRemove(path, LOG);
                    if (errno != 0) {
                        throw CairoException.critical(errno).put("could not remove table [name=").put(tableToken).put(", dirName=").put(tableToken.getDirName()).put(']');
                    }
                }
                finally {
                    this.unlockTableUnsafe(tableToken, null, false);
                }
                this.tableNameRegistry.dropTable(tableToken);
                return;
            }
            throw CairoException.nonCritical().put("Could not lock '").put(tableToken).put("' [reason='").put(lockedReason).put("']");
        }
    }

    public TableWriter getBackupWriter(TableToken tableToken, CharSequence backupDirName) {
        this.verifyTableToken(tableToken);
        return new TableWriter(this.configuration, tableToken, this.messageBus, null, true, DefaultLifecycleManager.INSTANCE, backupDirName, Metrics.disabled());
    }

    public int getBusyReaderCount() {
        return this.readerPool.getBusyCount();
    }

    public int getBusyWriterCount() {
        return this.writerPool.getBusyCount();
    }

    public long getCommandCorrelationId() {
        return this.asyncCommandCorrelationId.incrementAndGet();
    }

    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    public CopyContext getCopyContext() {
        return this.copyContext;
    }

    public Job getEngineMaintenanceJob() {
        return this.engineMaintenanceJob;
    }

    public FunctionFactoryCache getFunctionFactoryCache() {
        return this.ffCache;
    }

    public MessageBus getMessageBus() {
        return this.messageBus;
    }

    public TableRecordMetadata getMetadata(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        try {
            return (TableRecordMetadata)this.metadataPool.get(tableToken);
        }
        catch (CairoException e) {
            this.tryRepairTable(tableToken, e);
            return (TableRecordMetadata)this.metadataPool.get(tableToken);
        }
    }

    public TableRecordMetadata getMetadata(TableToken tableToken, long metadataVersion) {
        this.verifyTableToken(tableToken);
        try {
            TableRecordMetadata metadata = (TableRecordMetadata)this.metadataPool.get(tableToken);
            if (metadataVersion != -1L && metadata.getMetadataVersion() != metadataVersion) {
                TableReferenceOutOfDateException ex = TableReferenceOutOfDateException.of(tableToken, metadata.getTableId(), metadata.getTableId(), metadataVersion, metadata.getMetadataVersion());
                metadata.close();
                throw ex;
            }
            return metadata;
        }
        catch (CairoException e) {
            this.tryRepairTable(tableToken, e);
            return (TableRecordMetadata)this.metadataPool.get(tableToken);
        }
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public PoolListener getPoolListener() {
        return this.writerPool.getPoolListener();
    }

    public TableReader getReader(CharSequence tableName) {
        return this.getReader(this.verifyTableNameForRead(tableName));
    }

    public TableReader getReader(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        return (TableReader)this.readerPool.get(tableToken);
    }

    public TableReader getReader(TableToken tableToken, long version) {
        this.verifyTableToken(tableToken);
        int tableId = tableToken.getTableId();
        TableReader reader = (TableReader)this.readerPool.get(tableToken);
        if (version > -1L && reader.getVersion() != version || tableId > -1 && reader.getMetadata().getTableId() != tableId) {
            TableReferenceOutOfDateException ex = TableReferenceOutOfDateException.of(tableToken, tableId, reader.getMetadata().getTableId(), version, reader.getVersion());
            reader.close();
            throw ex;
        }
        return reader;
    }

    public Map<CharSequence, AbstractMultiTenantPool.Entry<ReaderPool.R>> getReaderPoolEntries() {
        return this.readerPool.entries();
    }

    public TableReader getReaderWithRepair(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        try {
            return this.getReader(tableToken);
        }
        catch (CairoException e) {
            this.tryRepairTable(tableToken, e);
            try {
                return this.getReader(tableToken);
            }
            catch (CairoException e2) {
                LOG.critical().$("could not open reader [table=").$(tableToken).$(", errno=").$(e2.getErrno()).$(", error=").$(e2.getMessage()).I$();
                throw e2;
            }
        }
    }

    public IDGenerator getTableIdGenerator() {
        return this.tableIdGenerator;
    }

    public TableSequencerAPI getTableSequencerAPI() {
        return this.tableSequencerAPI;
    }

    public int getTableStatus(Path path, TableToken tableToken) {
        if (tableToken == TableNameRegistry.LOCKED_TOKEN) {
            return 2;
        }
        if (tableToken == null || !tableToken.equals(this.tableNameRegistry.getTableToken(tableToken.getTableName()))) {
            return 1;
        }
        return TableUtils.exists(this.configuration.getFilesFacade(), path, this.configuration.getRoot(), tableToken.getDirName());
    }

    public int getTableStatus(CharSequence tableName) {
        TableToken tableToken = this.getTableTokenIfExists(tableName);
        if (tableToken == null) {
            return 1;
        }
        return this.getTableStatus(Path.getThreadLocal(this.configuration.getRoot()), tableToken);
    }

    public TableToken getTableTokenByDirName(String dirName, int tableId) {
        return this.tableNameRegistry.getTableToken(dirName, tableId);
    }

    public int getTableTokenCount(boolean includeDropped) {
        return this.tableNameRegistry.getTableTokenCount(includeDropped);
    }

    public TableToken getTableTokenIfExists(CharSequence tableName) {
        return this.tableNameRegistry.getTableToken(tableName);
    }

    public TableToken getTableTokenIfExists(CharSequence tableName, int lo, int hi) {
        StringSink sink = Misc.getThreadLocalBuilder();
        sink.put(tableName, lo, hi);
        return this.tableNameRegistry.getTableToken(sink);
    }

    public void getTableTokens(ObjHashSet<TableToken> bucket, boolean includeDropped) {
        this.tableNameRegistry.getTableTokens(bucket, includeDropped);
    }

    @Override
    public TableWriterAPI getTableWriterAPI(TableToken tableToken, @Nullable String lockReason) {
        this.verifyTableToken(tableToken);
        if (!tableToken.isWal()) {
            return this.writerPool.get(tableToken, lockReason);
        }
        return (TableWriterAPI)this.walWriterPool.get(tableToken);
    }

    @Override
    public TableWriterAPI getTableWriterAPI(CharSequence tableName, String lockReason) {
        return this.getTableWriterAPI(this.verifyTableNameForRead(tableName), lockReason);
    }

    public Telemetry<TelemetryTask> getTelemetry() {
        return this.telemetry;
    }

    public Telemetry<TelemetryWalTask> getTelemetryWal() {
        return this.telemetryWal;
    }

    public long getUnpublishedWalTxnCount() {
        return this.unpublishedWalTxnCount.get();
    }

    public TableToken getUpdatedTableToken(TableToken tableToken) {
        return this.tableNameRegistry.getTokenByDirName(tableToken.getDirName());
    }

    public WalReader getWalReader(SecurityContext securityContext, TableToken tableToken, CharSequence walName, int segmentId, long walRowCount) {
        if (tableToken.isWal()) {
            return new WalReader(this.configuration, tableToken, walName, segmentId, walRowCount);
        }
        throw CairoException.nonCritical().put("WAL reader is not supported for table ").put(tableToken);
    }

    @NotNull
    public WalWriter getWalWriter(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        return (WalWriter)this.walWriterPool.get(tableToken);
    }

    public TableWriter getWriter(TableToken tableToken, String lockReason) {
        this.verifyTableToken(tableToken);
        return this.writerPool.get(tableToken, lockReason);
    }

    public TableWriter getWriterOrPublishCommand(TableToken tableToken, @NotNull AsyncWriterCommand asyncWriterCommand) {
        this.verifyTableToken(tableToken);
        return this.writerPool.getWriterOrPublishCommand(tableToken, asyncWriterCommand.getCommandName(), asyncWriterCommand);
    }

    public TableWriter getWriterUnsafe(TableToken tableToken, String lockReason) {
        return this.writerPool.get(tableToken, lockReason);
    }

    public boolean isTableDropped(TableToken tableToken) {
        return this.tableNameRegistry.isTableDropped(tableToken);
    }

    public boolean isWalTable(TableToken tableToken) {
        return tableToken.isWal();
    }

    public String lock(TableToken tableToken, String lockReason) {
        assert (null != lockReason);
        String lockedReason = BUSY_READER;
        if (this.metadataPool.lock(tableToken)) {
            lockedReason = this.writerPool.lock(tableToken, lockReason);
            if (lockedReason == null) {
                if (this.readerPool.lock(tableToken)) {
                    LOG.info().$("locked [table=`").utf8(tableToken.getDirName()).$("`, thread=").$(Thread.currentThread().getId()).I$();
                    return null;
                }
                this.writerPool.unlock(tableToken);
                lockedReason = BUSY_READER;
            }
            this.metadataPool.unlock(tableToken);
        }
        return lockedReason;
    }

    public boolean lockReaders(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        return this.readerPool.lock(tableToken);
    }

    public boolean lockReadersByTableToken(TableToken tableToken) {
        return this.readerPool.lock(tableToken);
    }

    public TableToken lockTableName(CharSequence tableName, boolean isWal) {
        this.validNameOrThrow(tableName);
        int tableId = (int)this.getTableIdGenerator().getNextId();
        return this.lockTableName(tableName, tableId, isWal);
    }

    @Nullable
    public TableToken lockTableName(CharSequence tableName, int tableId, boolean isWal) {
        String tableNameStr = Chars.toString(tableName);
        String dirName = TableUtils.getTableDir(this.configuration.mangleTableDirNames(), tableNameStr, tableId, isWal);
        return this.tableNameRegistry.lockTableName(tableNameStr, dirName, tableId, isWal);
    }

    public void notifyWalTxnCommitted(TableToken tableToken, long txn) {
        long cursor;
        Sequence pubSeq = this.messageBus.getWalTxnNotificationPubSequence();
        do {
            if ((cursor = pubSeq.next()) <= -1L) continue;
            WalTxnNotificationTask task = this.messageBus.getWalTxnNotificationQueue().get(cursor);
            task.of(tableToken, txn);
            pubSeq.done(cursor);
            return;
        } while (cursor != -1L);
        LOG.debug().$("cannot publish WAL notifications, queue is full [current=").$(pubSeq.current()).$(", table=").utf8(tableToken.getDirName()).I$();
        this.notifyWalTxnRepublisher();
    }

    public void notifyWalTxnRepublisher() {
        this.unpublishedWalTxnCount.incrementAndGet();
    }

    public void registerTableToken(TableToken tableToken) {
        this.tableNameRegistry.registerName(tableToken);
    }

    public boolean releaseAllReaders() {
        boolean b1 = this.metadataPool.releaseAll();
        return this.readerPool.releaseAll() & b1;
    }

    public void releaseAllWriters() {
        this.writerPool.releaseAll();
    }

    public boolean releaseInactive() {
        boolean useful = this.writerPool.releaseInactive();
        useful |= this.readerPool.releaseInactive();
        useful |= this.tableSequencerAPI.releaseInactive();
        useful |= this.metadataPool.releaseInactive();
        return useful |= this.walWriterPool.releaseInactive();
    }

    public void releaseInactiveTableSequencers() {
        this.walWriterPool.releaseInactive();
        this.tableSequencerAPI.releaseInactive();
    }

    public void releaseReadersByTableToken(TableToken tableToken) {
        this.readerPool.unlock(tableToken);
    }

    public void reloadTableNames() {
        this.reloadTableNames(null);
    }

    public void reloadTableNames(ObjList<TableToken> convertedTables) {
        this.tableNameRegistry.reloadTableNameCache(convertedTables);
    }

    public void removeTableToken(TableToken tableToken) {
        this.tableNameRegistry.purgeToken(tableToken);
        PoolListener listener = this.getPoolListener();
        if (listener != null) {
            listener.onEvent((byte)5, Thread.currentThread().getId(), tableToken, (short)26, (short)0, (short)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableToken rename(SecurityContext securityContext, Path path, MemoryMARW memory, CharSequence tableName, Path otherPath, CharSequence newName) {
        this.validNameOrThrow(tableName);
        this.validNameOrThrow(newName);
        TableToken tableToken = this.verifyTableName(tableName);
        securityContext.authorizeTableRename(tableToken);
        if (tableToken != null) {
            TableToken newTableToken;
            if (tableToken.isWal()) {
                newTableToken = this.tableNameRegistry.rename(tableName, newName, tableToken);
                TableUtils.overwriteTableNameFile(path.of(this.configuration.getRoot()).concat(newTableToken), memory, this.configuration.getFilesFacade(), newTableToken);
                this.tableSequencerAPI.renameWalTable(tableToken, newTableToken);
            } else {
                String lockedReason = this.lock(tableToken, "renameTable");
                if (null == lockedReason) {
                    try {
                        newTableToken = this.rename0(path, tableToken, tableName, otherPath, newName);
                        TableUtils.overwriteTableNameFile(path.of(this.configuration.getRoot()).concat(newTableToken), memory, this.configuration.getFilesFacade(), newTableToken);
                    }
                    finally {
                        this.unlock(securityContext, tableToken, null, false);
                    }
                    this.tableNameRegistry.dropTable(tableToken);
                } else {
                    LOG.error().$("cannot lock and rename [from='").$(tableName).$("', to='").$(newName).$("', reason='").$(lockedReason).$("']").$();
                    throw EntryUnavailableException.instance(lockedReason);
                }
            }
            return newTableToken;
        }
        LOG.error().$('\'').utf8(tableName).$("' does not exist. Rename failed.").$();
        throw CairoException.nonCritical().put("Rename failed. Table '").put(tableName).put("' does not exist");
    }

    public void resetNameRegistryMemory() {
        this.tableNameRegistry.resetMemory();
    }

    public void setPoolListener(PoolListener poolListener) {
        this.metadataPool.setPoolListener(poolListener);
        this.writerPool.setPoolListener(poolListener);
        this.readerPool.setPoolListener(poolListener);
        this.walWriterPool.setPoolListener(poolListener);
    }

    public void setReaderListener(ReaderPool.ReaderListener readerListener) {
        this.readerPool.setTableReaderListener(readerListener);
    }

    public void unlock(SecurityContext securityContext, TableToken tableToken, @Nullable TableWriter writer, boolean newTable) {
        this.verifyTableToken(tableToken);
        this.unlockTableUnsafe(tableToken, writer, newTable);
        LOG.info().$("unlocked [table=`").$(tableToken).$("`]").$();
    }

    public void unlockReaders(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        this.readerPool.unlock(tableToken);
    }

    public void unlockTableName(TableToken tableToken) {
        this.tableNameRegistry.unlockTableName(tableToken);
    }

    public TableToken verifyTableName(CharSequence tableName) {
        TableToken tableToken = this.tableNameRegistry.getTableToken(tableName);
        if (tableToken == null) {
            throw CairoException.tableDoesNotExist(tableName);
        }
        if (tableToken == TableNameRegistry.LOCKED_TOKEN) {
            throw CairoException.nonCritical().put("table name is reserved [table=").put(tableName).put("]");
        }
        return tableToken;
    }

    public TableToken verifyTableName(CharSequence tableName, int lo, int hi) {
        StringSink sink = Misc.getThreadLocalBuilder();
        sink.put(tableName, lo, hi);
        return this.verifyTableName(sink);
    }

    public void verifyTableToken(TableToken tableToken) {
        TableToken tt = this.tableNameRegistry.getTableToken(tableToken.getTableName());
        if (tt == null) {
            throw CairoException.tableDoesNotExist(tableToken.getTableName());
        }
        if (!tt.equals(tableToken)) {
            throw TableReferenceOutOfDateException.of(tableToken, tableToken.getTableId(), tt.getTableId(), tt.getTableId(), -1L);
        }
    }

    private void createTableInVolumeUnsafe(MemoryMARW mem, Path path, TableStructure struct, TableToken tableToken) {
        TableUtils.createTableInVolume(this.configuration.getFilesFacade(), this.configuration.getRoot(), this.configuration.getMkDirMode(), mem, path, tableToken.getDirName(), struct, 426, tableToken.getTableId());
        if (struct.isWalEnabled()) {
            this.tableSequencerAPI.registerTable(tableToken.getTableId(), struct, tableToken);
        }
    }

    private void createTableUnsafe(MemoryMARW mem, Path path, TableStructure struct, TableToken tableToken) {
        TableUtils.createTable(this.configuration.getFilesFacade(), (CharSequence)this.configuration.getRoot(), this.configuration.getMkDirMode(), mem, path, tableToken.getDirName(), struct, 426, tableToken.getTableId());
        if (struct.isWalEnabled()) {
            this.tableSequencerAPI.registerTable(tableToken.getTableId(), struct, tableToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableToken rename0(Path path, TableToken srcTableToken, CharSequence tableName, Path otherPath, CharSequence to) {
        FilesFacade ff = this.configuration.getFilesFacade();
        String root = this.configuration.getRoot();
        path.of(root).concat(srcTableToken).$();
        TableToken dstTableToken = this.lockTableName(to, srcTableToken.getTableId(), false);
        if (dstTableToken == null || ff.exists(otherPath.of(root).concat(dstTableToken).$())) {
            if (dstTableToken != null) {
                this.tableNameRegistry.unlockTableName(dstTableToken);
            }
            LOG.error().$("rename target exists [from='").utf8(tableName).$("', to='").utf8(otherPath.$()).I$();
            throw CairoException.nonCritical().put("Rename target exists");
        }
        try {
            if (ff.rename(path, otherPath) != 0) {
                int error = ff.errno();
                LOG.error().$("could not rename [from='").utf8(path).$("', to='").utf8(otherPath).$("', error=").$(error).I$();
                throw CairoException.critical(error).put("could not rename [from='").put(path).put("', to='").put(otherPath).put("', error=").put(error);
            }
            this.tableNameRegistry.registerName(dstTableToken);
            TableToken tableToken = dstTableToken;
            return tableToken;
        }
        finally {
            this.tableNameRegistry.unlockTableName(dstTableToken);
        }
    }

    private void tryRepairTable(TableToken tableToken, RuntimeException rethrow) {
        try {
            this.writerPool.get(tableToken, "repair").close();
        }
        catch (EntryUnavailableException e) {
            throw rethrow;
        }
        catch (Throwable th) {
            LOG.critical().$("could not repair before reading [dirName=").utf8(tableToken.getDirName()).$(" ,error=").$(th.getMessage()).I$();
            throw rethrow;
        }
    }

    private void unlockTableUnsafe(TableToken tableToken, TableWriter writer, boolean newTable) {
        this.readerPool.unlock(tableToken);
        this.writerPool.unlock(tableToken, writer, newTable);
        this.metadataPool.unlock(tableToken);
    }

    private void validNameOrThrow(CharSequence tableName) {
        if (!TableUtils.isValidTableName(tableName, this.configuration.getMaxFileNameLength())) {
            throw CairoException.nonCritical().put("invalid table name [table=").putAsPrintable(tableName).put(']');
        }
    }

    @NotNull
    private TableToken verifyTableNameForRead(CharSequence tableName) {
        TableToken token = this.getTableTokenIfExists(tableName);
        if (token == null || token == TableNameRegistry.LOCKED_TOKEN) {
            throw CairoException.tableDoesNotExist(tableName);
        }
        return token;
    }

    private class EngineMaintenanceJob
    extends SynchronizedJob {
        private final long checkInterval;
        private final MicrosecondClock clock;
        private long last = 0L;

        public EngineMaintenanceJob(CairoConfiguration configuration) {
            this.clock = configuration.getMicrosecondClock();
            this.checkInterval = configuration.getIdleCheckInterval() * 1000L;
        }

        @Override
        protected boolean runSerially() {
            long t = this.clock.getTicks();
            if (this.last + this.checkInterval < t) {
                this.last = t;
                return CairoEngine.this.releaseInactive();
            }
            return false;
        }
    }
}

