/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class BitmapIndexWriter
implements Closeable,
Mutable {
    private static final Log LOG = LogFactory.getLog(BitmapIndexWriter.class);
    private static final long MAX_VALUE_OFFSET = 37L;
    private final CairoConfiguration configuration;
    private final Cursor cursor = new Cursor();
    private final FilesFacade ff;
    private final MemoryMARW keyMem = Vm.getMARWInstance();
    private final MemoryMARW valueMem = Vm.getMARWInstance();
    private int blockCapacity;
    private int blockValueCountMod;
    private int keyCount = -1;
    private long seekValueBlockOffset;
    private long seekValueCount;
    private final BitmapIndexUtils.ValueBlockSeeker SEEKER = this::seek;
    private long valueMemSize = -1L;

    public BitmapIndexWriter(CairoConfiguration configuration, Path path, CharSequence name, long columnNameTxn) {
        this(configuration);
        this.of(path, name, columnNameTxn);
    }

    public BitmapIndexWriter(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
    }

    public static void initKeyMemory(MemoryMA keyMem, int blockValueCount) {
        assert (blockValueCount == Numbers.ceilPow2(blockValueCount));
        keyMem.jumpTo(0L);
        keyMem.truncate();
        keyMem.putByte((byte)-6);
        keyMem.putLong(1L);
        Unsafe.getUnsafe().storeFence();
        keyMem.putLong(0L);
        keyMem.putInt(blockValueCount);
        keyMem.putLong(0L);
        Unsafe.getUnsafe().storeFence();
        keyMem.putLong(1L);
        assert (keyMem.getAppendOffset() == 37L);
        keyMem.putLong(-1L);
        keyMem.skip(64L - keyMem.getAppendOffset());
    }

    public void add(int key, long value) {
        assert (key > -1) : "key must be positive integer: " + key;
        long offset = BitmapIndexUtils.getKeyEntryOffset(key);
        if (key < this.keyCount) {
            long valueBlockOffset = this.keyMem.getLong(offset + 16L);
            long valueCount = this.keyMem.getLong(offset + 0L);
            int valueCellIndex = (int)(valueCount & (long)this.blockValueCountMod);
            if (valueCellIndex > 0) {
                assert (valueBlockOffset + (long)this.blockCapacity <= this.valueMemSize);
                this.appendValue(offset, valueBlockOffset, valueCount, valueCellIndex, value);
            } else if (valueCount == 0L) {
                this.initValueBlockAndStoreValue(offset, value);
            } else {
                assert (valueBlockOffset + (long)this.blockCapacity <= this.valueMemSize);
                this.addValueBlockAndStoreValue(offset, valueBlockOffset, valueCount, value);
            }
        } else {
            this.initValueBlockAndStoreValue(offset, value);
            this.updateKeyCount(key);
        }
    }

    @Override
    public void clear() {
        this.close();
    }

    @Override
    public void close() {
        if (this.keyMem.isOpen()) {
            if (this.keyCount > -1) {
                this.keyMem.setSize(this.keyMemSize());
            }
            Misc.free(this.keyMem);
        }
        if (this.valueMem.isOpen()) {
            if (this.valueMemSize > -1L) {
                this.valueMem.setSize(this.valueMemSize);
            }
            Misc.free(this.valueMem);
        }
    }

    public void commit() {
        int commitMode = this.configuration.getCommitMode();
        if (commitMode != 2) {
            this.sync(commitMode == 0);
        }
    }

    public RowCursor getCursor(int key) {
        if (key < this.keyCount) {
            this.cursor.of(key);
            return this.cursor;
        }
        return EmptyRowCursor.INSTANCE;
    }

    public int getKeyCount() {
        return this.keyCount;
    }

    public long getMaxValue() {
        return this.keyMem.getLong(37L);
    }

    public long getValueMemSize() {
        return this.valueMemSize;
    }

    public boolean isOpen() {
        return this.keyMem.isOpen();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void of(CairoConfiguration configuration, int keyFd, int valueFd, boolean init, int indexBlockCapacity) {
        this.close();
        FilesFacade ff = configuration.getFilesFacade();
        boolean kFdUnassigned = true;
        boolean vFdUnassigned = true;
        long keyAppendPageSize = configuration.getDataIndexKeyAppendPageSize();
        long valueAppendPageSize = configuration.getDataIndexValueAppendPageSize();
        try {
            if (init) {
                if (!ff.truncate(keyFd, 0L)) throw CairoException.critical(ff.errno()).put("Could not truncate [fd=").put(keyFd).put(']');
                kFdUnassigned = false;
                this.keyMem.of(ff, keyFd, null, keyAppendPageSize, keyAppendPageSize, 14);
                BitmapIndexWriter.initKeyMemory(this.keyMem, indexBlockCapacity);
            } else {
                kFdUnassigned = false;
                this.keyMem.of(ff, keyFd, null, ff.length(keyFd), 14);
            }
            long keyMemSize = this.keyMem.getAppendOffset();
            if (keyMemSize < 64L) {
                LOG.error().$("file too short [corrupt] [fd=").$(keyFd).$(']').$();
                throw CairoException.critical(0).put("Index file too short (w): [fd=").put(keyFd).put(']');
            }
            if (this.keyMem.getByte(0L) != -6) {
                LOG.error().$("unknown format [corrupt] [fd=").$(keyFd).$(']').$();
                throw CairoException.critical(0).put("Unknown format: [fd=").put(keyFd).put(']');
            }
            this.keyCount = this.keyMem.getInt(21L);
            if (keyMemSize < this.keyMemSize()) {
                LOG.error().$("key count does not match file length [corrupt] [fd=").$(keyFd).$(", keyCount=").$(this.keyCount).$(']').$();
                throw CairoException.critical(0).put("Key count does not match file length [fd=").put(keyFd).put(']');
            }
            if (this.keyMem.getLong(29L) != this.keyMem.getLong(1L)) {
                LOG.error().$("sequence mismatch [corrupt] at [fd=").$(keyFd).$(']').$();
                throw CairoException.critical(0).put("Sequence mismatch [fd=").put(keyFd).put(']');
            }
            this.valueMemSize = this.keyMem.getLong(9L);
            if (init) {
                if (!ff.truncate(valueFd, 0L)) throw CairoException.critical(ff.errno()).put("Could not truncate [fd=").put(valueFd).put(']');
                vFdUnassigned = false;
                this.valueMem.of(ff, valueFd, null, valueAppendPageSize, valueAppendPageSize, 14);
                this.valueMem.jumpTo(0L);
            } else {
                vFdUnassigned = false;
                this.valueMem.of(ff, valueFd, null, valueAppendPageSize, this.valueMemSize, 14);
            }
            this.blockValueCountMod = this.keyMem.getInt(17L) - 1;
            assert (this.blockValueCountMod > 0);
            this.blockCapacity = (this.blockValueCountMod + 1) * 8 + 16;
            return;
        }
        catch (Throwable e) {
            this.close();
            if (kFdUnassigned) {
                ff.close(keyFd);
            }
            if (!vFdUnassigned) throw e;
            ff.close(valueFd);
            throw e;
        }
    }

    public final void of(Path path, CharSequence name, long columnNameTxn) {
        this.of(path, name, columnNameTxn, 0);
    }

    public final void of(Path path, CharSequence name, long columnNameTxn, int indexBlockCapacity) {
        this.close();
        int plen = path.length();
        try {
            boolean init = indexBlockCapacity > 0;
            BitmapIndexUtils.keyFileName(path, name, columnNameTxn);
            if (init) {
                this.keyMem.of(this.ff, (LPSZ)path, this.configuration.getDataIndexKeyAppendPageSize(), 0L, 14);
                BitmapIndexWriter.initKeyMemory(this.keyMem, indexBlockCapacity);
            } else {
                boolean exists = this.ff.exists(path);
                if (!exists) {
                    LOG.error().$(path).$(" not found").$();
                    throw CairoException.critical(0).put("Index does not exist: ").put(path);
                }
                this.keyMem.of(this.ff, (LPSZ)path, this.configuration.getDataIndexKeyAppendPageSize(), this.ff.length(path), 14);
            }
            long keyMemSize = this.keyMem.getAppendOffset();
            if (keyMemSize < 64L) {
                LOG.error().$("file too short [corrupt] ").$(path).$();
                throw CairoException.critical(0).put("Index file too short (w): ").put(path);
            }
            if (this.keyMem.getByte(0L) != -6) {
                LOG.error().$("unknown format [corrupt] ").$(path).$();
                throw CairoException.critical(0).put("Unknown format: ").put(path);
            }
            this.keyCount = this.keyMem.getInt(21L);
            if (keyMemSize < this.keyMemSize()) {
                LOG.error().$("key count does not match file length [corrupt] of ").$(path).$(" [keyCount=").$(this.keyCount).$(']').$();
                throw CairoException.critical(0).put("Key count does not match file length of ").put(path);
            }
            if (this.keyMem.getLong(29L) != this.keyMem.getLong(1L)) {
                LOG.error().$("sequence mismatch [corrupt] at ").$(path).$();
                throw CairoException.critical(0).put("Sequence mismatch on ").put(path);
            }
            this.valueMemSize = this.keyMem.getLong(9L);
            this.valueMem.of(this.ff, (LPSZ)BitmapIndexUtils.valueFileName(path.trimTo(plen), name, columnNameTxn), this.configuration.getDataIndexValueAppendPageSize(), this.valueMemSize, 14);
            if (init) {
                assert (this.valueMemSize == 0L);
                this.valueMem.truncate();
            }
            this.blockValueCountMod = this.keyMem.getInt(17L) - 1;
            if (this.blockValueCountMod < 1) {
                LOG.error().$("corrupt file [name=").$(path).$(", valueMemSize=").$(this.valueMemSize).$(", blockValueCountMod=").$(this.blockValueCountMod).I$();
                throw CairoException.critical(0).put("corrupt file ").put(path);
            }
            this.blockCapacity = (this.blockValueCountMod + 1) * 8 + 16;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(plen);
        }
    }

    public void rollbackConditionally(long row) {
        long currentMaxRow;
        if (row >= 0L && ((currentMaxRow = this.getMaxValue()) < 1L || currentMaxRow >= row)) {
            if (row == 0L) {
                this.truncate();
            } else {
                this.rollbackValues(row - 1L);
            }
        }
    }

    public void rollbackValues(long maxValue) {
        long maxValueBlockOffset = 0L;
        for (int k = 0; k < this.keyCount; ++k) {
            long offset = BitmapIndexUtils.getKeyEntryOffset(k);
            long valueCount = this.keyMem.getLong(offset + 0L);
            if (valueCount <= 0L) continue;
            long blockOffset = this.keyMem.getLong(offset + 16L);
            BitmapIndexUtils.seekValueBlockRTL(valueCount, blockOffset, this.valueMem, maxValue, this.blockValueCountMod, this.SEEKER);
            if (valueCount != this.seekValueCount || blockOffset != this.seekValueBlockOffset) {
                this.keyMem.putLong(offset + 0L, this.seekValueCount);
                if (blockOffset != this.seekValueBlockOffset) {
                    Unsafe.getUnsafe().storeFence();
                    this.keyMem.putLong(offset + 16L, this.seekValueBlockOffset);
                    Unsafe.getUnsafe().storeFence();
                }
                this.keyMem.putLong(offset + 24L, this.seekValueCount);
            }
            if (this.seekValueBlockOffset <= maxValueBlockOffset) continue;
            maxValueBlockOffset = this.seekValueBlockOffset;
        }
        this.valueMemSize = maxValueBlockOffset + (long)this.blockCapacity;
        this.updateValueMemSize();
        this.setMaxValue(maxValue);
    }

    public void setMaxValue(long maxValue) {
        this.keyMem.putLong(37L, maxValue);
    }

    public void sync(boolean async) {
        this.keyMem.sync(async);
        this.valueMem.sync(async);
    }

    public void truncate() {
        BitmapIndexWriter.initKeyMemory(this.keyMem, this.blockValueCountMod + 1);
        this.valueMem.truncate();
        this.keyCount = 0;
        this.valueMemSize = 0L;
    }

    private void addValueBlockAndStoreValue(long offset, long valueBlockOffset, long valueCount, long value) {
        long newValueBlockOffset = this.allocateValueBlockAndStore(value);
        this.valueMem.putLong(this.valueMemSize - 16L, valueBlockOffset);
        this.valueMem.putLong(valueBlockOffset + (long)this.blockCapacity - 16L + 8L, newValueBlockOffset);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset, valueCount + 1L);
        Unsafe.getUnsafe().storeFence();
        assert (newValueBlockOffset < this.valueMemSize);
        this.keyMem.putLong(offset + 16L, newValueBlockOffset);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset + 24L, valueCount + 1L);
        Unsafe.getUnsafe().storeFence();
    }

    private long allocateValueBlockAndStore(long value) {
        long newValueBlockOffset = this.valueMemSize;
        this.valueMem.putLong(newValueBlockOffset, value);
        this.valueMem.skip(this.blockCapacity);
        this.valueMemSize += (long)this.blockCapacity;
        this.updateValueMemSize();
        return newValueBlockOffset;
    }

    private void appendValue(long offset, long valueBlockOffset, long valueCount, int valueCellIndex, long value) {
        this.valueMem.putLong(valueBlockOffset + (long)valueCellIndex * 8L, value);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset, valueCount + 1L);
        this.keyMem.putLong(offset + 24L, valueCount + 1L);
    }

    private void initValueBlockAndStoreValue(long offset, long value) {
        long newValueBlockOffset = this.allocateValueBlockAndStore(value);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset, 1L);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset + 8L, newValueBlockOffset);
        this.keyMem.putLong(offset + 16L, newValueBlockOffset);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset + 24L, 1L);
        Unsafe.getUnsafe().storeFence();
    }

    private long keyMemSize() {
        return (long)this.keyCount * 32L + 64L;
    }

    private void seek(long count, long offset) {
        this.seekValueCount = count;
        this.seekValueBlockOffset = offset;
    }

    private void updateValueMemSize() {
        long seq = this.keyMem.getLong(1L) + 1L;
        this.keyMem.putLong(1L, seq);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(9L, this.valueMemSize);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(29L, seq);
    }

    void updateKeyCount(int key) {
        this.keyCount = key + 1;
        long seq = this.keyMem.getLong(1L) + 1L;
        this.keyMem.putLong(1L, seq);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putInt(21L, this.keyCount);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(29L, seq);
    }

    private class Cursor
    implements RowCursor {
        private long valueBlockOffset;
        private long valueCount;

        private Cursor() {
        }

        @Override
        public boolean hasNext() {
            return this.valueCount > 0L;
        }

        @Override
        public long next() {
            long cellIndex = this.getValueCellIndex(--this.valueCount);
            long result = BitmapIndexWriter.this.valueMem.getLong(this.valueBlockOffset + cellIndex * 8L);
            if (cellIndex == 0L && this.valueCount > 0L) {
                this.jumpToPreviousValueBlock();
            }
            return result;
        }

        private long getPreviousBlock(long currentValueBlockOffset) {
            return BitmapIndexWriter.this.valueMem.getLong(currentValueBlockOffset + (long)BitmapIndexWriter.this.blockCapacity - 16L);
        }

        private long getValueCellIndex(long absoluteValueIndex) {
            return absoluteValueIndex & (long)BitmapIndexWriter.this.blockValueCountMod;
        }

        private void jumpToPreviousValueBlock() {
            this.valueBlockOffset = this.getPreviousBlock(this.valueBlockOffset);
        }

        void of(int key) {
            assert (key > -1) : "key must be positive integer: " + key;
            long offset = BitmapIndexUtils.getKeyEntryOffset(key);
            this.valueCount = BitmapIndexWriter.this.keyMem.getLong(offset + 0L);
            assert (this.valueCount > -1L);
            this.valueBlockOffset = BitmapIndexWriter.this.keyMem.getLong(offset + 16L);
        }
    }
}

