/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractIndexReader;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.IndexFrame;
import io.questdb.cairo.IndexFrameCursor;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;

public class BitmapIndexBwdReader
extends AbstractIndexReader {
    private final Cursor cursor = new Cursor();
    private final NullCursor nullCursor = new NullCursor();

    public BitmapIndexBwdReader(CairoConfiguration configuration, Path path, CharSequence name, long columnNameTxn, long unIndexedNullCount) {
        this.of(configuration, path, name, columnNameTxn, unIndexedNullCount);
    }

    @Override
    public RowCursor getCursor(boolean cachedInstance, int key, long minValue, long maxValue) {
        assert (minValue <= maxValue);
        if (key >= this.keyCount) {
            this.updateKeyCount();
        }
        if (key == 0 && this.unIndexedNullCount > 0L) {
            NullCursor nullCursor = this.getNullCursor(cachedInstance);
            nullCursor.nullCount = this.unIndexedNullCount;
            nullCursor.of(key, minValue, maxValue, this.keyCount);
            return nullCursor;
        }
        if (key < this.keyCount) {
            Cursor cursor = this.getCursor(cachedInstance);
            cursor.of(key, minValue, maxValue, this.keyCount);
            return cursor;
        }
        return EmptyRowCursor.INSTANCE;
    }

    private Cursor getCursor(boolean cachedInstance) {
        return cachedInstance ? this.cursor : new Cursor();
    }

    private NullCursor getNullCursor(boolean cachedInstance) {
        return cachedInstance ? this.nullCursor : new NullCursor();
    }

    private class NullCursor
    extends Cursor {
        private long nullCount;

        private NullCursor() {
        }

        @Override
        public boolean hasNext() {
            if (super.hasNext()) {
                return true;
            }
            if (--this.nullCount >= this.minValue) {
                this.next = this.nullCount;
                return true;
            }
            return false;
        }
    }

    private class Cursor
    implements RowCursor,
    IndexFrameCursor {
        protected long minValue;
        protected long next;
        protected long valueCount;
        private long valueBlockOffset;
        private final BitmapIndexUtils.ValueBlockSeeker SEEKER = this::seekValue;

        private Cursor() {
        }

        @Override
        public IndexFrame getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.valueCount > 0L) {
                long cellIndex = this.getValueCellIndex(--this.valueCount);
                long result = BitmapIndexBwdReader.this.valueMem.getLong(this.valueBlockOffset + cellIndex * 8L);
                if (cellIndex == 0L && this.valueCount > 0L) {
                    this.jumpToPreviousValueBlock();
                }
                if (result >= this.minValue) {
                    this.next = result;
                    return true;
                }
                this.valueCount = 0L;
                return false;
            }
            return false;
        }

        @Override
        public long next() {
            return this.next;
        }

        private long getPreviousBlock(long currentValueBlockOffset) {
            return BitmapIndexBwdReader.this.valueMem.getLong(currentValueBlockOffset + (long)BitmapIndexBwdReader.this.blockCapacity - 16L);
        }

        private long getValueCellIndex(long absoluteValueIndex) {
            return absoluteValueIndex & (long)BitmapIndexBwdReader.this.blockValueCountMod;
        }

        private void jumpToPreviousValueBlock() {
            this.valueBlockOffset = this.getPreviousBlock(this.valueBlockOffset);
        }

        private void seekValue(long count, long offset) {
            this.valueCount = count;
            this.valueBlockOffset = offset;
        }

        void of(int key, long minValue, long maxValue, long keyCount) {
            if (keyCount == 0L) {
                this.valueCount = 0L;
            } else {
                long valueBlockOffset;
                long valueCount;
                block6: {
                    assert (key > -1) : "key must be positive integer: " + key;
                    long offset = BitmapIndexUtils.getKeyEntryOffset(key);
                    BitmapIndexBwdReader.this.keyMem.extend(offset + 32L);
                    long deadline = BitmapIndexBwdReader.this.clock.getTicks() + BitmapIndexBwdReader.this.spinLockTimeoutUs;
                    do {
                        valueCount = BitmapIndexBwdReader.this.keyMem.getLong(offset + 0L);
                        Unsafe.getUnsafe().loadFence();
                        if (BitmapIndexBwdReader.this.keyMem.getLong(offset + 24L) != valueCount) continue;
                        valueBlockOffset = BitmapIndexBwdReader.this.keyMem.getLong(offset + 16L);
                        Unsafe.getUnsafe().loadFence();
                        if (BitmapIndexBwdReader.this.keyMem.getLong(offset + 0L) == valueCount) break block6;
                    } while (BitmapIndexBwdReader.this.clock.getTicks() <= deadline);
                    AbstractIndexReader.LOG.error().$("cursor could not consistently read index header [corrupt?]").$(" [timeout=").$(BitmapIndexBwdReader.this.spinLockTimeoutUs).utf8("\u03bcs, key=").$(key).$(", offset=").$(offset).$(']').$();
                    throw CairoException.critical(0).put("cursor could not consistently read index header [corrupt?]");
                }
                BitmapIndexBwdReader.this.valueMem.extend(valueBlockOffset + (long)BitmapIndexBwdReader.this.blockCapacity);
                if (valueCount > 0L) {
                    BitmapIndexUtils.seekValueBlockRTL(valueCount, valueBlockOffset, BitmapIndexBwdReader.this.valueMem, maxValue, BitmapIndexBwdReader.this.blockValueCountMod, this.SEEKER);
                } else {
                    this.seekValue(valueCount, valueBlockOffset);
                }
                this.minValue = minValue;
            }
        }
    }
}

