/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.Telemetry;
import io.questdb.TelemetryConfigLogger;
import io.questdb.cairo.CairoEngine;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SynchronizedJob;
import io.questdb.tasks.TelemetryTask;
import io.questdb.tasks.TelemetryWalTask;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class TelemetryJob
extends SynchronizedJob
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TelemetryJob.class);
    private final Telemetry<TelemetryTask> telemetry;
    private final Telemetry<TelemetryWalTask> telemetryWal;
    private final TelemetryConfigLogger telemetryConfigLogger;

    public TelemetryJob(CairoEngine engine) throws SqlException {
        this(engine, null);
    }

    public TelemetryJob(CairoEngine engine, @Nullable FunctionFactoryCache functionFactoryCache) throws SqlException {
        this.telemetry = engine.getTelemetry();
        this.telemetryWal = engine.getTelemetryWal();
        this.telemetryConfigLogger = new TelemetryConfigLogger(engine);
        try (SqlCompiler compiler = new SqlCompiler(engine, functionFactoryCache, null);){
            SqlExecutionContextImpl sqlExecutionContext = new SqlExecutionContextImpl(engine, 1);
            sqlExecutionContext.with(engine.getConfiguration().getFactoryProvider().getSecurityContextFactory().getRootContext(), null, null);
            this.telemetry.init(engine, compiler, sqlExecutionContext);
            this.telemetryWal.init(engine, compiler, sqlExecutionContext);
            this.telemetryConfigLogger.init(compiler, sqlExecutionContext);
        }
    }

    @Override
    public void close() {
        this.telemetry.close();
        this.telemetryWal.close();
        this.telemetryConfigLogger.close();
    }

    @Override
    public boolean runSerially() {
        try {
            this.telemetry.consumeAll();
        }
        catch (Throwable th) {
            LOG.error().$("failed to process telemetry event").$(th).$();
        }
        try {
            this.telemetryWal.consumeAll();
        }
        catch (Throwable th) {
            LOG.error().$("failed to process wal telemetry event").$(th).$();
        }
        return false;
    }
}

