/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.TelemetryConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SCSequence;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.NanosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import java.io.Closeable;

public class TelemetryConfigLogger
implements Closeable {
    public static final String OS_NAME = "os.name";
    public static final CharSequence TELEMETRY_CONFIG_TABLE_NAME = "telemetry_config";
    static final String QDB_PACKAGE = "QDB_PACKAGE";
    private static final Log LOG = LogFactory.getLog(TelemetryConfigLogger.class);
    private final CharSequence questDBVersion;
    private final TelemetryConfiguration telemetryConfiguration;
    private final SCSequence tempSequence = new SCSequence();
    private TableWriter configWriter;

    public TelemetryConfigLogger(CairoEngine engine) {
        this.questDBVersion = engine.getConfiguration().getBuildInformation().getQuestDbVersion();
        this.telemetryConfiguration = engine.getConfiguration().getTelemetryConfiguration();
    }

    @Override
    public void close() {
        this.configWriter = Misc.free(this.configWriter);
    }

    private void appendConfigRow(SqlCompiler compiler, TableWriter configWriter, Long256 id, boolean enabled) {
        TableWriter.Row row = configWriter.newRow();
        if (id == null) {
            MicrosecondClock clock = compiler.getEngine().getConfiguration().getMicrosecondClock();
            NanosecondClock nanosecondClock = compiler.getEngine().getConfiguration().getNanosecondClock();
            long a = nanosecondClock.getTicks();
            long b = clock.getTicks();
            row.putLong256(0, a, b, 0L, 0L);
            LOG.info().$("new instance [id=").$256(a, b, 0L, 0L).$(", enabled=").$(enabled).$(']').$();
        } else {
            row.putLong256(0, id);
        }
        row.putBool(1, enabled);
        row.putSym(2, this.questDBVersion);
        row.putSym(3, System.getProperty(OS_NAME));
        String packageStr = System.getenv().get(QDB_PACKAGE);
        if (packageStr != null) {
            row.putSym(4, packageStr);
        }
        row.append();
        configWriter.commit();
    }

    private void tryAddColumn(SqlCompiler compiler, SqlExecutionContext executionContext, CharSequence columnDetails) {
        try {
            CompiledQuery cc = compiler.query().$("ALTER TABLE ").$(TELEMETRY_CONFIG_TABLE_NAME).$(" ADD COLUMN ").$(columnDetails).compile(executionContext);
            try (OperationFuture fut = cc.execute(this.tempSequence);){
                fut.await();
            }
        }
        catch (SqlException ex) {
            LOG.info().$("Failed to alter telemetry table [table=").$(TELEMETRY_CONFIG_TABLE_NAME).$(", error=").$(ex.getFlyweightMessage()).I$();
        }
    }

    private TableWriter updateTelemetryConfig(SqlCompiler compiler, SqlExecutionContextImpl sqlExecutionContext, TableToken tableToken) throws SqlException {
        TableWriter configWriter = compiler.getEngine().getWriter(tableToken, "telemetryConfig");
        CompiledQuery cc = compiler.query().$(TELEMETRY_CONFIG_TABLE_NAME).$(" LIMIT -1").compile(sqlExecutionContext);
        try (RecordCursorFactory factory = cc.getRecordCursorFactory();
             RecordCursor cursor = factory.getCursor(sqlExecutionContext);){
            boolean enabled = this.telemetryConfiguration.getEnabled();
            if (cursor.hasNext()) {
                Record record = cursor.getRecord();
                boolean _enabled = record.getBool(1);
                Long256 l256 = record.getLong256A(0);
                CharSequence _questDBVersion = record.getSym(2);
                if (enabled != _enabled || !this.questDBVersion.equals(_questDBVersion)) {
                    this.appendConfigRow(compiler, configWriter, l256, enabled);
                    LOG.advisory().$("instance config changes [id=").$256(l256.getLong0(), l256.getLong1(), 0L, 0L).$(", enabled=").$(enabled).$(']').$();
                } else {
                    LOG.advisory().$("instance [id=").$256(l256.getLong0(), l256.getLong1(), 0L, 0L).$(", enabled=").$(enabled).$(']').$();
                }
            } else {
                this.appendConfigRow(compiler, configWriter, null, enabled);
            }
        }
        return configWriter;
    }

    void init(SqlCompiler compiler, SqlExecutionContextImpl sqlExecutionContext) throws SqlException {
        TableToken configTableToken = compiler.query().$("CREATE TABLE IF NOT EXISTS ").$(TELEMETRY_CONFIG_TABLE_NAME).$(" (id long256, enabled boolean, version symbol, os symbol, package symbol)").compile(sqlExecutionContext).getTableToken();
        this.tryAddColumn(compiler, sqlExecutionContext, "version symbol");
        this.tryAddColumn(compiler, sqlExecutionContext, "os symbol");
        this.tryAddColumn(compiler, sqlExecutionContext, "package symbol");
        try {
            this.configWriter = this.updateTelemetryConfig(compiler, sqlExecutionContext, configTableToken);
        }
        catch (CairoException ex) {
            LOG.error().$("could not open [table=`").utf8(TELEMETRY_CONFIG_TABLE_NAME).$("`, ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
        }
    }
}

