/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.Bootstrap;
import io.questdb.MessageBus;
import io.questdb.Metrics;
import io.questdb.ServerConfiguration;
import io.questdb.TelemetryJob;
import io.questdb.WorkerPoolManager;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnIndexerJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.security.ReadOnlySecurityContextFactory;
import io.questdb.cairo.security.SecurityContextFactory;
import io.questdb.cairo.wal.ApplyWal2TableJob;
import io.questdb.cairo.wal.CheckWalTransactionsJob;
import io.questdb.cairo.wal.WalPurgeJob;
import io.questdb.cutlass.Services;
import io.questdb.cutlass.auth.DefaultLineAuthenticatorFactory;
import io.questdb.cutlass.auth.EllipticCurveLineAuthenticatorFactory;
import io.questdb.cutlass.auth.LineAuthenticatorFactory;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.pgwire.PgWireAuthenticatorFactory;
import io.questdb.cutlass.pgwire.ReadOnlyUsersAwareSecurityContextFactory;
import io.questdb.cutlass.pgwire.StaticUsernamePasswordMatcher;
import io.questdb.cutlass.pgwire.UsernamePasswordPgWireAuthenticatorFactory;
import io.questdb.cutlass.text.CopyJob;
import io.questdb.cutlass.text.CopyRequestJob;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.engine.groupby.vect.GroupByJob;
import io.questdb.griffin.engine.table.AsyncFilterAtom;
import io.questdb.griffin.engine.table.LatestByAllIndexedJob;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.WorkerPool;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import java.io.Closeable;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public class ServerMain
implements Closeable {
    private final String banner;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ServerConfiguration config;
    private final CairoEngine engine;
    private final ObjList<Closeable> freeOnExitList = new ObjList();
    private final Log log;
    private final AtomicBoolean running = new AtomicBoolean();
    private final WorkerPoolManager workerPoolManager;

    public ServerMain(String ... args) {
        this(new Bootstrap(args));
    }

    public ServerMain(Bootstrap bootstrap) {
        this(bootstrap.getConfiguration(), bootstrap.getMetrics(), bootstrap.getLog(), bootstrap.getBanner());
    }

    public ServerMain(final ServerConfiguration config, Metrics metrics, Log log, String banner) {
        this.config = config;
        this.log = log;
        this.banner = banner;
        final CairoConfiguration cairoConfig = config.getCairoConfiguration();
        this.engine = this.freeOnExit(new CairoEngine(cairoConfig, metrics));
        final FunctionFactoryCache ffCache = this.engine.getFunctionFactoryCache();
        config.init(this.engine, ffCache);
        this.freeOnExit(config.getFactoryProvider());
        final DatabaseSnapshotAgent snapshotAgent = this.freeOnExit(new DatabaseSnapshotAgent(this.engine));
        final boolean walSupported = config.getCairoConfiguration().isWalSupported();
        final boolean isReadOnly = config.getCairoConfiguration().isReadOnlyInstance();
        final boolean walApplyEnabled = config.getCairoConfiguration().isWalApplyEnabled();
        this.workerPoolManager = new WorkerPoolManager(config, metrics.health()){

            @Override
            protected void configureSharedPool(WorkerPool sharedPool) {
                try {
                    sharedPool.assign(ServerMain.this.engine.getEngineMaintenanceJob());
                    MessageBus messageBus = ServerMain.this.engine.getMessageBus();
                    sharedPool.assign(new ColumnIndexerJob(messageBus));
                    sharedPool.assign(new GroupByJob(messageBus));
                    sharedPool.assign(new LatestByAllIndexedJob(messageBus));
                    if (!isReadOnly) {
                        O3Utils.setupWorkerPool(sharedPool, ServerMain.this.engine, config.getCairoConfiguration().getCircuitBreakerConfiguration(), ffCache);
                        if (walSupported) {
                            sharedPool.assign(new CheckWalTransactionsJob(ServerMain.this.engine));
                            WalPurgeJob walPurgeJob = new WalPurgeJob(ServerMain.this.engine);
                            snapshotAgent.setWalPurgeJobRunLock(walPurgeJob.getRunLock());
                            walPurgeJob.delayByHalfInterval();
                            sharedPool.assign(walPurgeJob);
                            sharedPool.freeOnExit(walPurgeJob);
                            if (walApplyEnabled && !config.getWalApplyPoolConfiguration().isEnabled()) {
                                ServerMain.this.setupWalApplyJob(sharedPool, ServerMain.this.engine, this.getSharedWorkerCount(), ffCache);
                            }
                        }
                        CopyJob.assignToPool(messageBus, sharedPool);
                        if (cairoConfig.getSqlCopyInputRoot() != null) {
                            CopyRequestJob copyRequestJob = new CopyRequestJob(ServerMain.this.engine, Math.max(1, sharedPool.getWorkerCount() - 2), ffCache);
                            sharedPool.assign(copyRequestJob);
                            sharedPool.freeOnExit(copyRequestJob);
                        }
                    }
                    if (!cairoConfig.getTelemetryConfiguration().getDisableCompletely()) {
                        TelemetryJob telemetryJob = new TelemetryJob(ServerMain.this.engine, ffCache);
                        ServerMain.this.freeOnExitList.add(telemetryJob);
                        if (cairoConfig.getTelemetryConfiguration().getEnabled()) {
                            sharedPool.assign(telemetryJob);
                        }
                    }
                }
                catch (Throwable thr) {
                    throw new Bootstrap.BootstrapException(thr);
                }
            }
        };
        if (walApplyEnabled && !isReadOnly && walSupported && config.getWalApplyPoolConfiguration().isEnabled()) {
            WorkerPool walApplyWorkerPool = this.workerPoolManager.getInstance(config.getWalApplyPoolConfiguration(), metrics.health(), WorkerPoolManager.Requester.WAL_APPLY);
            this.setupWalApplyJob(walApplyWorkerPool, this.engine, this.workerPoolManager.getSharedWorkerCount(), ffCache);
        }
        this.freeOnExit(Services.createHttpServer(config.getHttpServerConfiguration(), this.engine, this.workerPoolManager, ffCache, snapshotAgent, metrics));
        this.freeOnExit(Services.createMinHttpServer(config.getHttpMinServerConfiguration(), this.engine, this.workerPoolManager, metrics));
        this.freeOnExit(Services.createPGWireServer(config.getPGWireConfiguration(), this.engine, this.workerPoolManager, ffCache, snapshotAgent, metrics));
        if (!isReadOnly) {
            this.freeOnExit(Services.createLineTcpReceiver(config.getLineTcpReceiverConfiguration(), this.engine, this.workerPoolManager, metrics));
            this.freeOnExit(Services.createLineUdpReceiver(config.getLineUdpReceiverConfiguration(), this.engine, this.workerPoolManager));
        }
        System.gc();
        log.advisoryW().$("server is ready to be started").$();
    }

    public static LineAuthenticatorFactory getLineAuthenticatorFactory(ServerConfiguration configuration) {
        LineAuthenticatorFactory authenticatorFactory;
        if (configuration.getLineTcpReceiverConfiguration().isEnabled() && configuration.getLineTcpReceiverConfiguration().getAuthDB() != null) {
            String rootDir = new File(configuration.getCairoConfiguration().getRoot()).getParent();
            authenticatorFactory = new EllipticCurveLineAuthenticatorFactory(configuration.getLineTcpReceiverConfiguration().getNetworkFacade(), new File(rootDir, configuration.getLineTcpReceiverConfiguration().getAuthDB()).getAbsolutePath());
        } else {
            authenticatorFactory = DefaultLineAuthenticatorFactory.INSTANCE;
        }
        return authenticatorFactory;
    }

    public static PgWireAuthenticatorFactory getPgWireAuthenticatorFactory(ServerConfiguration configuration) {
        return new UsernamePasswordPgWireAuthenticatorFactory(new StaticUsernamePasswordMatcher(configuration.getPGWireConfiguration()));
    }

    public static SecurityContextFactory getSecurityContextFactory(ServerConfiguration configuration) {
        boolean readOnlyInstance = configuration.getCairoConfiguration().isReadOnlyInstance();
        if (readOnlyInstance) {
            return ReadOnlySecurityContextFactory.INSTANCE;
        }
        PGWireConfiguration pgWireConfiguration = configuration.getPGWireConfiguration();
        HttpContextConfiguration httpContextConfiguration = configuration.getHttpServerConfiguration().getHttpContextConfiguration();
        boolean pgWireReadOnlyContext = pgWireConfiguration.readOnlySecurityContext();
        boolean pgWireReadOnlyUserEnabled = pgWireConfiguration.isReadOnlyUserEnabled();
        String pgWireReadOnlyUsername = pgWireReadOnlyUserEnabled ? pgWireConfiguration.getReadOnlyUsername() : null;
        boolean httpReadOnly = httpContextConfiguration.readOnlySecurityContext();
        return new ReadOnlyUsersAwareSecurityContextFactory(pgWireReadOnlyContext, pgWireReadOnlyUsername, httpReadOnly);
    }

    public static void main(String[] args) {
        try {
            new ServerMain(args).start(true);
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            LogFactory.closeInstance();
            System.exit(55);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.workerPoolManager.halt();
            for (int i = this.freeOnExitList.size() - 1; i >= 0; --i) {
                Misc.free(this.freeOnExitList.getQuick(i));
            }
            this.freeOnExitList.clear();
        }
    }

    public ServerConfiguration getConfiguration() {
        return this.config;
    }

    public CairoEngine getEngine() {
        if (this.closed.get()) {
            throw new IllegalStateException("close was called");
        }
        return this.engine;
    }

    public WorkerPoolManager getWorkerPoolManager() {
        if (this.closed.get()) {
            throw new IllegalStateException("close was called");
        }
        return this.workerPoolManager;
    }

    public boolean hasBeenClosed() {
        return this.closed.get();
    }

    public boolean hasStarted() {
        return this.running.get();
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean addShutdownHook) {
        if (!this.closed.get() && this.running.compareAndSet(false, true)) {
            if (addShutdownHook) {
                this.addShutdownHook();
            }
            this.workerPoolManager.start(this.log);
            Bootstrap.logWebConsoleUrls(this.config, this.log, this.banner);
            System.gc();
            this.log.advisoryW().$("enjoy").$();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                System.err.println("QuestDB is shutting down...");
                System.err.println("Pre-touch magic number: " + AsyncFilterAtom.PRE_TOUCH_BLACK_HOLE.sum());
                this.close();
                LogFactory.closeInstance();
            }
            catch (Error error) {
            }
            finally {
                System.err.println("QuestDB is shutdown.");
            }
        }));
    }

    protected <T extends Closeable> T freeOnExit(T closeable) {
        if (closeable != null) {
            this.freeOnExitList.add(closeable);
        }
        return closeable;
    }

    protected void setupWalApplyJob(WorkerPool workerPool, CairoEngine engine, int sharedWorkerCount, @Nullable FunctionFactoryCache ffCache) {
        int workerCount = workerPool.getWorkerCount();
        for (int i = 0; i < workerCount; ++i) {
            ApplyWal2TableJob applyWal2TableJob = new ApplyWal2TableJob(engine, workerCount, sharedWorkerCount, ffCache);
            workerPool.assign(i, applyWal2TableJob);
            workerPool.freeOnExit(applyWal2TableJob);
        }
    }
}

