/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.FactoryProvider;
import io.questdb.ServerConfiguration;
import io.questdb.ServerMain;
import io.questdb.cairo.security.SecurityContextFactory;
import io.questdb.cairo.wal.BasicWalInitializerFactory;
import io.questdb.cairo.wal.WalInitializerFactory;
import io.questdb.cutlass.auth.LineAuthenticatorFactory;
import io.questdb.cutlass.http.DefaultHttpAuthenticatorFactory;
import io.questdb.cutlass.http.HttpAuthenticatorFactory;
import io.questdb.cutlass.pgwire.PgWireAuthenticatorFactory;
import io.questdb.griffin.SqlCompilerFactory;
import io.questdb.griffin.SqlCompilerFactoryImpl;

public class FactoryProviderImpl
implements FactoryProvider {
    private final LineAuthenticatorFactory lineAuthenticatorFactory;
    private final PgWireAuthenticatorFactory pgWireAuthenticatorFactory;
    private final SecurityContextFactory securityContextFactory;

    public FactoryProviderImpl(ServerConfiguration configuration) {
        this.lineAuthenticatorFactory = ServerMain.getLineAuthenticatorFactory(configuration);
        this.securityContextFactory = ServerMain.getSecurityContextFactory(configuration);
        this.pgWireAuthenticatorFactory = ServerMain.getPgWireAuthenticatorFactory(configuration);
    }

    @Override
    public HttpAuthenticatorFactory getHttpAuthenticatorFactory() {
        return DefaultHttpAuthenticatorFactory.INSTANCE;
    }

    @Override
    public LineAuthenticatorFactory getLineAuthenticatorFactory() {
        return this.lineAuthenticatorFactory;
    }

    @Override
    public PgWireAuthenticatorFactory getPgWireAuthenticatorFactory() {
        return this.pgWireAuthenticatorFactory;
    }

    @Override
    public SecurityContextFactory getSecurityContextFactory() {
        return this.securityContextFactory;
    }

    @Override
    public SqlCompilerFactory getSqlCompilerFactory() {
        return SqlCompilerFactoryImpl.INSTANCE;
    }

    @Override
    public WalInitializerFactory getWalInitializerFactory() {
        return BasicWalInitializerFactory.INSTANCE;
    }
}

