/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.BuildInformation;
import io.questdb.ServerMain;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;

public class BuildInformationHolder
implements BuildInformation,
CharSequence {
    public static final BuildInformationHolder INSTANCE = BuildInformationHolder.fetchBuildInformation();
    private static final String UNKNOWN = "Unknown Version";
    private final String buildKey;
    private final CharSequence commitHash;
    private final CharSequence jdkVersion;
    private final CharSequence questDbVersion;

    public BuildInformationHolder() {
        this(UNKNOWN, UNKNOWN, UNKNOWN);
    }

    public BuildInformationHolder(CharSequence questDbVersion, CharSequence commitHash, CharSequence jdkVersion) {
        this.questDbVersion = questDbVersion;
        this.commitHash = commitHash;
        this.jdkVersion = jdkVersion;
        this.buildKey = questDbVersion + ":" + commitHash + ":" + jdkVersion;
    }

    @Override
    public char charAt(int index) {
        return this.buildKey.charAt(index);
    }

    @Override
    public CharSequence getCommitHash() {
        return this.commitHash;
    }

    @Override
    public CharSequence getJdkVersion() {
        return this.jdkVersion;
    }

    @Override
    public CharSequence getQuestDbVersion() {
        return this.questDbVersion;
    }

    @Override
    public int length() {
        return this.buildKey.length();
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.buildKey.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.buildKey;
    }

    private static BuildInformationHolder fetchBuildInformation() {
        try {
            Attributes manifestAttributes = BuildInformationHolder.getManifestAttributes();
            return new BuildInformationHolder(BuildInformationHolder.getQuestDbVersion(manifestAttributes), BuildInformationHolder.getCommitHash(manifestAttributes), BuildInformationHolder.getJdkVersion(manifestAttributes));
        }
        catch (IOException e) {
            return new BuildInformationHolder();
        }
    }

    private static CharSequence getCommitHash(Attributes manifestAttributes) {
        String version = manifestAttributes.getValue("Build-Commit-Hash");
        return version != null ? version : UNKNOWN;
    }

    private static CharSequence getJdkVersion(Attributes manifestAttributes) {
        String version = manifestAttributes.getValue("Build-Jdk");
        return version != null ? version : UNKNOWN;
    }

    private static Attributes getManifestAttributes() throws IOException {
        Enumeration<URL> resources = ServerMain.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            InputStream is = resources.nextElement().openStream();
            try {
                Manifest manifest = new Manifest(is);
                Attributes attributes = manifest.getMainAttributes();
                if (!"org.questdb".equals(attributes.getValue("Implementation-Vendor-Id"))) continue;
                Attributes attributes2 = manifest.getMainAttributes();
                return attributes2;
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return new Attributes();
    }

    private static CharSequence getQuestDbVersion(Attributes manifestAttributes) {
        String version = manifestAttributes.getValue("Implementation-Version");
        return version != null ? version : "[DEVELOPMENT]";
    }
}

