/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.BootstrapConfiguration;
import io.questdb.BuildInformation;
import io.questdb.BuildInformationHolder;
import io.questdb.Metrics;
import io.questdb.PropBootstrapConfiguration;
import io.questdb.PropServerConfiguration;
import io.questdb.ServerConfiguration;
import io.questdb.ServerMain;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.jit.JitUtil;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.millitime.Dates;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import sun.misc.Signal;

public class Bootstrap {
    public static final String SWITCH_USE_DEFAULT_LOG_FACTORY_CONFIGURATION = "--use-default-log-factory-configuration";
    private static final String CONFIG_FILE = "/server.conf";
    private static final String LOG_NAME = "server-main";
    private static final String PUBLIC_VERSION_TXT = "version.txt";
    private static final String PUBLIC_ZIP = "/io/questdb/site/public.zip";
    private static final BuildInformation buildInformation = BuildInformationHolder.INSTANCE;
    private final String banner;
    private final ServerConfiguration config;
    private final Log log;
    private final Metrics metrics;
    private final String rootDirectory;

    public Bootstrap(String ... args) {
        this(new PropBootstrapConfiguration(), args);
    }

    public Bootstrap(BootstrapConfiguration bootstrapConfiguration, String ... args) {
        String archName;
        if (args.length < 2) {
            throw new BootstrapException("Root directory name expected (-d <root-path>)");
        }
        this.banner = bootstrapConfiguration.getBanner();
        CharSequenceObjHashMap<String> argsMap = Bootstrap.processArgs(args);
        this.rootDirectory = argsMap.get("-d");
        if (Chars.isBlank(this.rootDirectory)) {
            throw new BootstrapException("Root directory name expected (-d <root-path>)");
        }
        File rootPath = new File(this.rootDirectory);
        if (!rootPath.exists()) {
            throw new BootstrapException("Root directory does not exist: " + this.rootDirectory);
        }
        if (argsMap.get("-n") == null && Os.type != 3) {
            Signal.handle(new Signal("HUP"), signal -> {});
        }
        byte[] buffer = new byte[0x100000];
        try {
            Bootstrap.copyConfResource(this.rootDirectory, false, buffer, "conf/log.conf", null);
        }
        catch (IOException e) {
            throw new BootstrapException("Could not extract log configuration file");
        }
        if (argsMap.get(SWITCH_USE_DEFAULT_LOG_FACTORY_CONFIGURATION) == null) {
            LogFactory.configureRootDir(this.rootDirectory);
        }
        this.log = LogFactory.getLog(LOG_NAME);
        this.log.advisoryW().$("QuestDB server ").$(buildInformation.getQuestDbVersion()).$(". Copyright (C) 2014-").$(Dates.getYear(System.currentTimeMillis())).$(", all rights reserved.").$();
        boolean isOsSupported = true;
        switch (Os.type) {
            case 3: {
                archName = "OS/Arch Windows/amd64";
                break;
            }
            case 2: {
                archName = "OS/Arch linux/amd64";
                break;
            }
            case 1: {
                archName = "OS/Arch apple/amd64";
                break;
            }
            case 6: {
                archName = "OS/Arch apple/apple-silicon";
                break;
            }
            case 4: {
                archName = "OS/Arch linux/arm64";
                break;
            }
            case 5: {
                archName = "OS/ARCH freebsd/amd64";
                break;
            }
            default: {
                isOsSupported = false;
                archName = "Unsupported OS";
            }
        }
        StringBuilder sb = new StringBuilder(Vect.getSupportedInstructionSetName());
        sb.setLength(sb.length() - 1);
        sb.append(", ").append(System.getProperty("sun.arch.data.model")).append(" bits");
        sb.append(", ").append(Runtime.getRuntime().availableProcessors()).append(" processors");
        if (isOsSupported) {
            this.log.advisoryW().$(archName).$(sb).I$();
        } else {
            this.log.criticalW().$(archName).$(sb).I$();
        }
        try {
            ServerConfiguration configuration;
            if (bootstrapConfiguration.useSite()) {
                this.extractSite();
            }
            if ((configuration = bootstrapConfiguration.getServerConfiguration(this)) == null) {
                Properties properties = this.loadProperties();
                final FilesFacade ffOverride = bootstrapConfiguration.getFilesFacade();
                this.config = ffOverride == null ? new PropServerConfiguration(this.rootDirectory, properties, bootstrapConfiguration.getEnv(), this.log, buildInformation) : new PropServerConfiguration(this.rootDirectory, properties, bootstrapConfiguration.getEnv(), this.log, buildInformation){
                    private CairoConfiguration cairoConf;

                    @Override
                    public CairoConfiguration getCairoConfiguration() {
                        if (this.cairoConf == null) {
                            this.cairoConf = new PropServerConfiguration.PropCairoConfiguration(){

                                @Override
                                public FilesFacade getFilesFacade() {
                                    return ffOverride;
                                }
                            };
                        }
                        return this.cairoConf;
                    }
                };
            } else {
                this.config = configuration;
            }
            this.reportValidateConfig();
            Bootstrap.reportCrashFiles(this.config.getCairoConfiguration(), this.log);
        }
        catch (Throwable e) {
            this.log.errorW().$(e).$();
            throw new BootstrapException(e);
        }
        if (this.config.getMetricsConfiguration().isEnabled()) {
            this.metrics = Metrics.enabled();
        } else {
            this.metrics = Metrics.disabled();
            this.log.advisoryW().$("Metrics are disabled, health check endpoint will not consider unhandled errors").$();
        }
    }

    public static CharSequenceObjHashMap<String> processArgs(String ... args) {
        int n = args.length;
        if (n == 0) {
            throw new BootstrapException("Arguments expected, non provided");
        }
        CharSequenceObjHashMap<String> optHash = new CharSequenceObjHashMap<String>();
        for (int i = 0; i < n; ++i) {
            String arg = args[i];
            if (arg.length() > 1 && arg.charAt(0) == '-') {
                if (i + 1 < n) {
                    String nextArg = args[i + 1];
                    if (nextArg.length() > 1 && nextArg.charAt(0) == '-') {
                        optHash.put(arg, "");
                        continue;
                    }
                    optHash.put(arg, nextArg);
                    ++i;
                    continue;
                }
                optHash.put(arg, "");
                continue;
            }
            optHash.put("$" + i, arg);
        }
        return optHash;
    }

    public static void reportCrashFiles(CairoConfiguration cairoConfiguration, Log log) {
        String dbRoot = cairoConfiguration.getRoot();
        FilesFacade ff = cairoConfiguration.getFilesFacade();
        int maxFiles = cairoConfiguration.getMaxCrashFiles();
        NativeLPSZ name = new NativeLPSZ();
        try (Path path = new Path().of(dbRoot).slash$();
             Path other = new Path().of(dbRoot).slash$();){
            int plen = path.length();
            AtomicInteger counter = new AtomicInteger(0);
            FilesFacadeImpl.INSTANCE.iterateDir(path, (pUtf8NameZ, type) -> {
                if (Files.notDots(pUtf8NameZ)) {
                    name.of(pUtf8NameZ);
                    if (Chars.startsWith((CharSequence)name, cairoConfiguration.getOGCrashFilePrefix()) && type == 8) {
                        path.trimTo(plen).concat(pUtf8NameZ).$();
                        boolean shouldRename = false;
                        do {
                            other.trimTo(plen).concat(cairoConfiguration.getArchivedCrashFilePrefix()).put(counter.getAndIncrement()).put(".log").$();
                            if (ff.exists(other)) continue;
                            shouldRename = counter.get() <= maxFiles;
                            break;
                        } while (counter.get() < maxFiles);
                        if (shouldRename && ff.rename(path, other) == 0) {
                            log.criticalW().$("found crash file [path=").$(other).I$();
                        } else {
                            log.criticalW().$("could not rename crash file [path=").$(path).$(", errno=").$(ff.errno()).$(", index=").$(counter.get()).$(", max=").$(maxFiles).I$();
                        }
                    }
                }
            });
        }
    }

    public void extractSite() throws IOException {
        URL resource = ServerMain.class.getResource(PUBLIC_ZIP);
        if (resource == null) {
            this.log.infoW().$("Web Console build [").$(PUBLIC_ZIP).$("] not found").$();
        } else {
            long thisVersion = resource.openConnection().getLastModified();
            String publicDir = this.rootDirectory + Files.SEPARATOR + "public";
            byte[] buffer = new byte[0x100000];
            boolean extracted = false;
            String oldVersionStr = Bootstrap.getPublicVersion(publicDir);
            CharSequence dbVersion = buildInformation.getQuestDbVersion();
            if (oldVersionStr == null) {
                if (thisVersion != 0L) {
                    this.extractSite0(publicDir, buffer, Long.toString(thisVersion));
                } else {
                    this.extractSite0(publicDir, buffer, Chars.toString(dbVersion));
                }
                extracted = true;
            } else if (thisVersion == 0L) {
                if (!Chars.equals((CharSequence)oldVersionStr, dbVersion)) {
                    this.extractSite0(publicDir, buffer, Chars.toString(dbVersion));
                    extracted = true;
                }
            } else {
                try {
                    long oldVersion = Numbers.parseLong(oldVersionStr);
                    if (thisVersion > oldVersion) {
                        this.extractSite0(publicDir, buffer, Long.toString(thisVersion));
                        extracted = true;
                    }
                }
                catch (NumericException e) {
                    this.extractSite0(publicDir, buffer, Long.toString(thisVersion));
                    extracted = true;
                }
            }
            if (!extracted) {
                this.log.infoW().$("Web Console is up to date").$();
            }
        }
    }

    public String getBanner() {
        return this.banner;
    }

    public BuildInformation getBuildInformation() {
        return buildInformation;
    }

    public ServerConfiguration getConfiguration() {
        return this.config;
    }

    public Log getLog() {
        return this.log;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    @NotNull
    public Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        java.nio.file.Path configFile = Paths.get(this.rootDirectory, "conf", CONFIG_FILE);
        this.log.advisoryW().$("Server config: ").$(configFile).$();
        try (InputStream is = java.nio.file.Files.newInputStream(configFile, new OpenOption[0]);){
            properties.load(is);
        }
        return properties;
    }

    private static void copyConfResource(String dir, boolean force, byte[] buffer, String res, Log log) throws IOException {
        File out = new File(dir, res);
        try (InputStream is = ServerMain.class.getResourceAsStream("/io/questdb/site/" + res);){
            if (is != null) {
                Bootstrap.copyInputStream(force, buffer, out, is, log);
            }
        }
    }

    private static void copyInputStream(boolean force, byte[] buffer, File out, InputStream is, Log log) throws IOException {
        boolean exists = out.exists();
        if (force || !exists) {
            File dir = out.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                if (log != null) {
                    log.errorW().$("could not create directory [path=").$(dir).I$();
                }
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(out);){
                int n;
                while ((n = is.read(buffer, 0, buffer.length)) > 0) {
                    fos.write(buffer, 0, n);
                }
            }
            if (log != null) {
                log.infoW().$("extracted [path=").$(out).I$();
            }
            return;
        }
        if (log != null) {
            log.debugW().$("skipped [path=").$(out).I$();
        }
    }

    private static String getPublicVersion(String publicDir) throws IOException {
        File f = new File(publicDir, PUBLIC_VERSION_TXT);
        if (f.exists()) {
            try (FileInputStream fis = new FileInputStream(f);){
                byte[] buf = new byte[128];
                int len = fis.read(buf);
                String string = new String(buf, 0, len);
                return string;
            }
        }
        return null;
    }

    private static void setPublicVersion(String publicDir, String version) throws IOException {
        File f = new File(publicDir, PUBLIC_VERSION_TXT);
        File publicFolder = f.getParentFile();
        if (!publicFolder.exists() && !publicFolder.mkdirs()) {
            throw new BootstrapException("Cannot create folder: " + publicFolder);
        }
        try (FileOutputStream fos = new FileOutputStream(f);){
            byte[] buf = version.getBytes();
            fos.write(buf, 0, buf.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyFileOpts(Path path, CairoConfiguration cairoConfiguration) {
        FilesFacade ff;
        block6: {
            ff = cairoConfiguration.getFilesFacade();
            path.of(cairoConfiguration.getRoot()).concat("_verify_").put(cairoConfiguration.getRandom().nextPositiveInt()).put(".d").$();
            int fd = ff.openRW(path, cairoConfiguration.getWriterFileOpenOpts());
            try {
                if (fd <= -1) break block6;
                long mem = Unsafe.malloc(8L, 1);
                try {
                    TableUtils.writeLongOrFail(ff, fd, 0L, 123456789L, mem, path);
                }
                finally {
                    Unsafe.free(mem, 8L, 1);
                }
            }
            finally {
                ff.close(fd);
            }
        }
        ff.remove(path);
    }

    private void extractSite0(String publicDir, byte[] buffer, String thisVersion) throws IOException {
        block17: {
            block16: {
                try (InputStream is = ServerMain.class.getResourceAsStream(PUBLIC_ZIP);){
                    if (is != null) {
                        try (ZipInputStream zip = new ZipInputStream(is);){
                            ZipEntry ze;
                            while ((ze = zip.getNextEntry()) != null) {
                                File dest = new File(publicDir, ze.getName());
                                if (!ze.isDirectory()) {
                                    Bootstrap.copyInputStream(true, buffer, dest, zip, this.log);
                                }
                                zip.closeEntry();
                            }
                            break block16;
                        }
                    }
                    this.log.errorW().$("could not find site [resource=").$(PUBLIC_ZIP).$(']').$();
                }
            }
            Bootstrap.setPublicVersion(publicDir, thisVersion);
            Bootstrap.copyConfResource(this.rootDirectory, false, buffer, "conf/date.formats", this.log);
            try {
                Bootstrap.copyConfResource(this.rootDirectory, true, buffer, "conf/mime.types", this.log);
            }
            catch (IOException exception) {
                if (exception.getMessage() != null && (exception.getMessage().contains("Read-only file system") || exception.getMessage().contains("Permission denied"))) break block17;
                throw exception;
            }
        }
        Bootstrap.copyConfResource(this.rootDirectory, false, buffer, "conf/server.conf", this.log);
        Bootstrap.copyConfResource(this.rootDirectory, false, buffer, "conf/log.conf", this.log);
    }

    private void reportValidateConfig() {
        boolean httpEnabled = this.config.getHttpServerConfiguration().isEnabled();
        boolean httpReadOnly = this.config.getHttpServerConfiguration().getHttpContextConfiguration().readOnlySecurityContext();
        String httpReadOnlyHint = httpEnabled && httpReadOnly ? " [read-only]" : "";
        boolean pgEnabled = this.config.getPGWireConfiguration().isEnabled();
        boolean pgReadOnly = this.config.getPGWireConfiguration().readOnlySecurityContext();
        String pgReadOnlyHint = pgEnabled && pgReadOnly ? " [read-only]" : "";
        CairoConfiguration cairoConfig = this.config.getCairoConfiguration();
        this.log.advisoryW().$("Config:").$();
        this.log.advisoryW().$(" - http.enabled : ").$(httpEnabled).$(httpReadOnlyHint).$();
        this.log.advisoryW().$(" - tcp.enabled  : ").$(this.config.getLineTcpReceiverConfiguration().isEnabled()).$();
        this.log.advisoryW().$(" - pg.enabled   : ").$(pgEnabled).$(pgReadOnlyHint).$();
        this.log.advisoryW().$(" - attach partition suffix: ").$(this.config.getCairoConfiguration().getAttachPartitionSuffix()).$();
        this.log.advisoryW().$(" - open database [id=").$(cairoConfig.getDatabaseIdLo()).$('.').$(cairoConfig.getDatabaseIdHi()).I$();
        if (cairoConfig.isReadOnlyInstance()) {
            this.log.advisoryW().$(" - THIS IS READ ONLY INSTANCE").$();
        }
        try (Path path = new Path();){
            this.verifyFileSystem(path, cairoConfig.getRoot(), "db");
            this.verifyFileSystem(path, cairoConfig.getBackupRoot(), "backup");
            this.verifyFileSystem(path, cairoConfig.getSnapshotRoot(), "snapshot");
            this.verifyFileSystem(path, cairoConfig.getSqlCopyInputRoot(), "sql copy input");
            this.verifyFileSystem(path, cairoConfig.getSqlCopyInputWorkRoot(), "sql copy input worker");
            Bootstrap.verifyFileOpts(path, cairoConfig);
            cairoConfig.getVolumeDefinitions().forEach((alias, volumePath) -> this.verifyFileSystem(path, (CharSequence)volumePath, "create table allowed volume [" + alias + "]"));
        }
        if (JitUtil.isJitSupported()) {
            int jitMode = cairoConfig.getSqlJitMode();
            switch (jitMode) {
                case 0: {
                    this.log.advisoryW().$(" - SQL JIT compiler mode: on").$();
                    break;
                }
                case 1: {
                    this.log.advisoryW().$(" - SQL JIT compiler mode: scalar").$();
                    break;
                }
                case 2: {
                    this.log.advisoryW().$(" - SQL JIT compiler mode: off").$();
                    break;
                }
                default: {
                    this.log.errorW().$(" - Unknown SQL JIT compiler mode: ").$(jitMode).$();
                }
            }
        }
    }

    private void verifyFileSystem(Path path, CharSequence rootDir, String kind) {
        if (rootDir == null) {
            this.log.advisoryW().$(" - ").$(kind).$(" root: NOT SET").$();
            return;
        }
        path.of(rootDir).$();
        long fsStatus = Files.getFileSystemStatus(path);
        path.seekZ();
        LogRecord rec = this.log.advisoryW().$(" - ").$(kind).$(" root: [path=").$(rootDir).$(", magic=0x");
        if (fsStatus < 0L || fsStatus == 0L && Os.type == 6) {
            rec.$hex(-fsStatus).$("] -> SUPPORTED").$();
        } else {
            rec.$hex(fsStatus).$("] -> UNSUPPORTED (SYSTEM COULD BE UNSTABLE)").$();
        }
    }

    static void logWebConsoleUrls(ServerConfiguration config, Log log, String banner) {
        if (config.getHttpServerConfiguration().isEnabled()) {
            LogRecord r = log.infoW().$('\n').$(banner).$("Web Console URL(s):").$("\n\n");
            IODispatcherConfiguration httpConf = config.getHttpServerConfiguration().getDispatcherConfiguration();
            int bindIP = httpConf.getBindIPv4Address();
            int bindPort = httpConf.getBindPort();
            if (bindIP == 0) {
                try {
                    Enumeration<NetworkInterface> ni = NetworkInterface.getNetworkInterfaces();
                    while (ni.hasMoreElements()) {
                        Enumeration<InetAddress> addr = ni.nextElement().getInetAddresses();
                        while (addr.hasMoreElements()) {
                            InetAddress inetAddress = addr.nextElement();
                            if (!(inetAddress instanceof Inet4Address)) continue;
                            r.$('\t').$("http://").$(inetAddress.getHostAddress()).$(':').$(bindPort).$('\n');
                        }
                    }
                }
                catch (SocketException se) {
                    throw new BootstrapException("Cannot access network interfaces");
                }
                r.$('\n').$();
            } else {
                r.$('\t').$("http://").$ip(bindIP).$(':').$(bindPort).$('\n').$();
            }
        }
    }

    static {
        if (Os.type == -2) {
            throw new Error("QuestDB requires 64-bit JVM");
        }
    }

    public static class BootstrapException
    extends RuntimeException {
        public BootstrapException(String message) {
            super(message);
        }

        public BootstrapException(Throwable thr) {
            super(thr);
        }
    }
}

