/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.component.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.c2.protocol.component.api.BuildInfo;
import org.apache.nifi.c2.protocol.component.api.Bundle;
import org.apache.nifi.c2.protocol.component.api.SchedulingDefaults;

@ApiModel
public class RuntimeManifest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private String agentType;
    private String version;
    private BuildInfo buildInfo;
    private List<Bundle> bundles;
    private SchedulingDefaults schedulingDefaults;

    @ApiModelProperty(value="A unique identifier for the manifest")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @ApiModelProperty(value="The type of the runtime binary, e.g., 'minifi-java' or 'minifi-cpp'", notes="Usually set when the runtime is built.")
    public String getAgentType() {
        return this.agentType;
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    @ApiModelProperty(value="The version of the runtime binary, e.g., '1.0.1'", notes="Usually set when the runtime is built.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @ApiModelProperty(value="Build summary for this runtime binary")
    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    @ApiModelProperty(value="All extension bundles included with this runtime")
    public List<Bundle> getBundles() {
        return this.bundles != null ? Collections.unmodifiableList(this.bundles) : null;
    }

    public void setBundles(List<Bundle> bundles) {
        this.bundles = bundles;
    }

    @ApiModelProperty(value="Scheduling defaults for components defined in this manifest")
    public SchedulingDefaults getSchedulingDefaults() {
        return this.schedulingDefaults;
    }

    public void setSchedulingDefaults(SchedulingDefaults schedulingDefaults) {
        this.schedulingDefaults = schedulingDefaults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeManifest that = (RuntimeManifest)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.agentType, that.agentType) && Objects.equals(this.version, that.version) && Objects.equals(this.buildInfo, that.buildInfo);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.agentType, this.version, this.buildInfo);
    }

    public String toString() {
        return "RuntimeManifest{identifier='" + this.identifier + "', runtimeType='" + this.agentType + "', version='" + this.version + "', buildInfo=" + String.valueOf(this.buildInfo) + "}";
    }
}

