/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.bundle;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleVersionDependency;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.registry.link.LinkableEntity;

@ApiModel
@XmlRootElement
public class BundleVersion
extends LinkableEntity {
    @Valid
    @NotNull
    private BundleVersionMetadata versionMetadata;
    private Set<BundleVersionDependency> dependencies;
    private Bundle bundle;
    private Bucket bucket;

    @ApiModelProperty(value="The metadata about this version of the extension bundle")
    public BundleVersionMetadata getVersionMetadata() {
        return this.versionMetadata;
    }

    public void setVersionMetadata(BundleVersionMetadata versionMetadata) {
        this.versionMetadata = versionMetadata;
    }

    @ApiModelProperty(value="The set of other bundle versions that this version is dependent on", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Set<BundleVersionDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<BundleVersionDependency> dependencies) {
        this.dependencies = dependencies;
    }

    @ApiModelProperty(value="The bundle this version is for", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    @ApiModelProperty(value="The bucket that the extension bundle belongs to")
    public Bucket getBucket() {
        return this.bucket;
    }

    public void setBucket(Bucket bucket) {
        this.bucket = bucket;
    }

    @XmlTransient
    public String getFilename() {
        String filename = this.bundle.getArtifactId() + "-" + this.versionMetadata.getVersion();
        switch (this.bundle.getBundleType()) {
            case NIFI_NAR: {
                return filename + ".nar";
            }
            case MINIFI_CPP: {
                return filename;
            }
        }
        throw new IllegalStateException("Unknown bundle type: " + String.valueOf((Object)this.bundle.getBundleType()));
    }
}

