/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.ReconstitutedSerializedRepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordSerde;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.SerializedRepositoryRecord;
import org.apache.nifi.controller.repository.StandardFlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wali.SerDe;
import org.wali.UpdateType;

public class WriteAheadRepositoryRecordSerde
extends RepositoryRecordSerde
implements SerDe<SerializedRepositoryRecord> {
    private static final Logger logger = LoggerFactory.getLogger(WriteAheadRepositoryRecordSerde.class);
    private static final int CURRENT_ENCODING_VERSION = 9;
    public static final byte ACTION_CREATE = 0;
    public static final byte ACTION_UPDATE = 1;
    public static final byte ACTION_DELETE = 2;
    public static final byte ACTION_SWAPPED_OUT = 3;
    public static final byte ACTION_SWAPPED_IN = 4;
    private long recordsRestored = 0L;
    private final ResourceClaimManager claimManager;

    public WriteAheadRepositoryRecordSerde(ResourceClaimManager claimManager) {
        this.claimManager = claimManager;
    }

    public void serializeEdit(SerializedRepositoryRecord previousRecordState, SerializedRepositoryRecord record, DataOutputStream out) throws IOException {
        this.serializeEdit(previousRecordState, record, out, false);
    }

    public void serializeEdit(SerializedRepositoryRecord previousRecordState, SerializedRepositoryRecord record, DataOutputStream out, boolean forceAttributesWritten) throws IOException {
        if (record.isMarkedForAbort()) {
            logger.warn("Repository Record {} is marked to be aborted; it will be persisted in the FlowFileRepository as a DELETE record", (Object)record);
            out.write(2);
            out.writeLong(this.getRecordIdentifier(record));
            this.serializeContentClaim(record.getContentClaim(), record.getClaimOffset(), out);
            return;
        }
        UpdateType updateType = this.getUpdateType(record);
        if (updateType.equals((Object)UpdateType.DELETE)) {
            out.write(2);
            out.writeLong(this.getRecordIdentifier(record));
            this.serializeContentClaim(record.getContentClaim(), record.getClaimOffset(), out);
            return;
        }
        String associatedQueueId = record.getQueueIdentifier();
        if (updateType.equals((Object)UpdateType.SWAP_OUT)) {
            out.write(3);
            out.writeLong(this.getRecordIdentifier(record));
            out.writeUTF(associatedQueueId);
            out.writeUTF(this.getLocation(record));
            return;
        }
        FlowFileRecord flowFile = record.getFlowFileRecord();
        ContentClaim claim = record.getContentClaim();
        switch (updateType) {
            case UPDATE: {
                out.write(1);
                break;
            }
            case CREATE: {
                out.write(0);
                break;
            }
            case SWAP_IN: {
                out.write(4);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        out.writeLong(this.getRecordIdentifier(record));
        out.writeLong(flowFile.getEntryDate());
        out.writeLong(flowFile.getLineageStartDate());
        out.writeLong(flowFile.getLineageStartIndex());
        Long queueDate = flowFile.getLastQueueDate();
        out.writeLong(queueDate == null ? System.currentTimeMillis() : queueDate);
        out.writeLong(flowFile.getQueueDateIndex());
        out.writeLong(flowFile.getSize());
        if (associatedQueueId == null) {
            logger.warn("{} Repository Record {} has no Connection associated with it; it will be destroyed on restart", new Object[]{this, record});
            this.writeString("", out);
        } else {
            this.writeString(associatedQueueId, out);
        }
        this.serializeContentClaim(claim, record.getClaimOffset(), out);
        if (forceAttributesWritten || record.isAttributesChanged() || updateType == UpdateType.CREATE || updateType == UpdateType.SWAP_IN) {
            out.write(1);
            Map attributes = flowFile.getAttributes();
            out.writeInt(attributes.size());
            for (Map.Entry entry : attributes.entrySet()) {
                this.writeString((String)entry.getKey(), out);
                this.writeString((String)entry.getValue(), out);
            }
        } else {
            out.write(0);
        }
        if (updateType == UpdateType.SWAP_IN) {
            out.writeUTF(record.getSwapLocation());
        }
    }

    public SerializedRepositoryRecord deserializeEdit(DataInputStream in, Map<Object, SerializedRepositoryRecord> currentRecordStates, int version) throws IOException {
        int action = in.read();
        long recordId = in.readLong();
        if (action == 2) {
            StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder().id(recordId);
            if (version > 4) {
                this.deserializeClaim(in, version, ffBuilder);
            }
            FlowFileRecord flowFileRecord = ffBuilder.build();
            ReconstitutedSerializedRepositoryRecord record = new ReconstitutedSerializedRepositoryRecord.Builder().type(RepositoryRecordType.DELETE).flowFileRecord(flowFileRecord).build();
            return record;
        }
        if (action == 3) {
            String queueId = in.readUTF();
            String location = in.readUTF();
            FlowFileRecord flowFileRecord = new StandardFlowFileRecord.Builder().id(recordId).build();
            ReconstitutedSerializedRepositoryRecord record = new ReconstitutedSerializedRepositoryRecord.Builder().type(RepositoryRecordType.SWAP_OUT).queueIdentifier(queueId).swapLocation(location).flowFileRecord(flowFileRecord).build();
            return record;
        }
        StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder();
        SerializedRepositoryRecord record = currentRecordStates.get(recordId);
        ffBuilder.id(recordId);
        if (record != null) {
            ffBuilder.fromFlowFile(record.getFlowFileRecord());
        }
        ffBuilder.entryDate(in.readLong());
        if (version > 1) {
            if (version < 9) {
                int numLineageIds = in.readInt();
                for (int i = 0; i < numLineageIds; ++i) {
                    in.readUTF();
                }
            }
            long lineageStartDate = in.readLong();
            long lineageStartIndex = version > 7 ? in.readLong() : 0L;
            ffBuilder.lineageStart(lineageStartDate, lineageStartIndex);
            if (version > 5) {
                long lastQueueDate = in.readLong();
                long queueDateIndex = version > 7 ? in.readLong() : 0L;
                ffBuilder.lastQueued(lastQueueDate, queueDateIndex);
            }
        }
        ffBuilder.size(in.readLong());
        String connectionId = this.readString(in);
        logger.debug("{} -> {}", new Object[]{recordId, connectionId});
        this.deserializeClaim(in, version, ffBuilder);
        int attributesChanged = in.read();
        if (attributesChanged == -1) {
            throw new EOFException();
        }
        if (attributesChanged == 1) {
            int numAttributes = in.readInt();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (int i = 0; i < numAttributes; ++i) {
                String key = this.readString(in);
                String value = this.readString(in);
                attributes.put(key, value);
            }
            ffBuilder.addAttributes(attributes);
        } else if (attributesChanged != 0) {
            throw new IOException("Attribute Change Qualifier not found in stream; found value: " + attributesChanged + " after successfully restoring " + this.recordsRestored + " records. The FlowFile Repository appears to be corrupt!");
        }
        FlowFileRecord flowFile = ffBuilder.build();
        String swapLocation = null;
        if (action == 4) {
            swapLocation = in.readUTF();
        }
        RepositoryRecordType recordType = this.getRecordType(action);
        ReconstitutedSerializedRepositoryRecord repositoryRecord = new ReconstitutedSerializedRepositoryRecord.Builder().flowFileRecord(flowFile).queueIdentifier(connectionId).swapLocation(swapLocation).type(recordType).build();
        ++this.recordsRestored;
        return repositoryRecord;
    }

    public SerializedRepositoryRecord deserializeRecord(DataInputStream in, int version) throws IOException {
        int action = in.read();
        if (action == -1) {
            return null;
        }
        long recordId = in.readLong();
        if (action == 2) {
            StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder().id(recordId);
            if (version > 4) {
                this.deserializeClaim(in, version, ffBuilder);
            }
            FlowFileRecord flowFileRecord = ffBuilder.build();
            ReconstitutedSerializedRepositoryRecord record = new ReconstitutedSerializedRepositoryRecord.Builder().type(RepositoryRecordType.DELETE).flowFileRecord(flowFileRecord).build();
            return record;
        }
        StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder();
        long entryDate = in.readLong();
        if (version > 1) {
            if (version < 9) {
                int numLineageIds = in.readInt();
                for (int i = 0; i < numLineageIds; ++i) {
                    in.readUTF();
                }
            }
            long lineageStartDate = in.readLong();
            long lineageStartIndex = version > 7 ? in.readLong() : 0L;
            ffBuilder.lineageStart(lineageStartDate, lineageStartIndex);
            if (version > 5) {
                long lastQueueDate = in.readLong();
                long queueDateIndex = version > 7 ? in.readLong() : 0L;
                ffBuilder.lastQueued(lastQueueDate, queueDateIndex);
            }
        }
        long size = in.readLong();
        String connectionId = this.readString(in);
        logger.debug("{} -> {}", new Object[]{recordId, connectionId});
        ffBuilder.id(recordId);
        ffBuilder.entryDate(entryDate);
        ffBuilder.size(size);
        this.deserializeClaim(in, version, ffBuilder);
        int attributesChanged = in.read();
        if (attributesChanged == 1) {
            int numAttributes = in.readInt();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (int i = 0; i < numAttributes; ++i) {
                String key = this.readString(in);
                String value = this.readString(in);
                attributes.put(key, value);
            }
            ffBuilder.addAttributes(attributes);
        } else {
            if (attributesChanged == -1) {
                throw new EOFException();
            }
            if (attributesChanged != 0) {
                throw new IOException("Attribute Change Qualifier not found in stream; found value: " + attributesChanged + " after successfully restoring " + this.recordsRestored + " records");
            }
        }
        FlowFileRecord flowFile = ffBuilder.build();
        String swapLocation = null;
        if (action == 4) {
            swapLocation = in.readUTF();
        }
        ReconstitutedSerializedRepositoryRecord record = new ReconstitutedSerializedRepositoryRecord.Builder().queueIdentifier(connectionId).flowFileRecord(flowFile).swapLocation(swapLocation).type(this.getRecordType(action)).build();
        ++this.recordsRestored;
        return record;
    }

    private RepositoryRecordType getRecordType(int serializedUpdateType) {
        switch (serializedUpdateType) {
            case 0: {
                return RepositoryRecordType.CREATE;
            }
            case 4: {
                return RepositoryRecordType.SWAP_IN;
            }
            case 3: {
                return RepositoryRecordType.SWAP_OUT;
            }
        }
        return RepositoryRecordType.UPDATE;
    }

    public void serializeRecord(SerializedRepositoryRecord record, DataOutputStream out) throws IOException {
        this.serializeEdit(null, record, out, true);
    }

    private void serializeContentClaim(ContentClaim claim, long offset, DataOutputStream out) throws IOException {
        if (claim == null) {
            out.write(0);
        } else {
            out.write(1);
            ResourceClaim resourceClaim = claim.getResourceClaim();
            this.writeString(resourceClaim.getId(), out);
            this.writeString(resourceClaim.getContainer(), out);
            this.writeString(resourceClaim.getSection(), out);
            out.writeLong(claim.getOffset());
            out.writeLong(claim.getLength());
            out.writeLong(offset);
            out.writeBoolean(resourceClaim.isLossTolerant());
        }
    }

    private void deserializeClaim(DataInputStream in, int serializationVersion, StandardFlowFileRecord.Builder ffBuilder) throws IOException {
        int claimExists = in.read();
        if (claimExists == 1) {
            long resourceLength;
            long resourceOffset;
            String claimId = serializationVersion < 4 ? String.valueOf(in.readLong()) : this.readString(in);
            String container = this.readString(in);
            String section = this.readString(in);
            if (serializationVersion < 7) {
                resourceOffset = 0L;
                resourceLength = -1L;
            } else {
                resourceOffset = in.readLong();
                resourceLength = in.readLong();
            }
            long claimOffset = in.readLong();
            boolean lossTolerant = serializationVersion >= 3 ? in.readBoolean() : false;
            ResourceClaim resourceClaim = this.claimManager.newResourceClaim(container, section, claimId, lossTolerant, false);
            StandardContentClaim contentClaim = new StandardContentClaim(resourceClaim, resourceOffset);
            contentClaim.setLength(resourceLength);
            ffBuilder.contentClaim((ContentClaim)contentClaim);
            ffBuilder.contentClaimOffset(claimOffset);
        } else {
            if (claimExists == -1) {
                throw new EOFException();
            }
            if (claimExists != 0) {
                throw new IOException("Claim Existence Qualifier not found in stream; found value: " + claimExists + " after successfully restoring " + this.recordsRestored + " records");
            }
        }
    }

    private void writeString(String toWrite, OutputStream out) throws IOException {
        byte[] bytes = toWrite.getBytes(StandardCharsets.UTF_8);
        int utflen = bytes.length;
        if (utflen < 65535) {
            out.write(utflen >>> 8);
            out.write(utflen);
            out.write(bytes);
        } else {
            out.write(255);
            out.write(255);
            out.write(utflen >>> 24);
            out.write(utflen >>> 16);
            out.write(utflen >>> 8);
            out.write(utflen);
            out.write(bytes);
        }
    }

    private String readString(InputStream in) throws IOException {
        Integer numBytes = this.readFieldLength(in);
        if (numBytes == null) {
            throw new EOFException();
        }
        byte[] bytes = new byte[numBytes.intValue()];
        this.fillBuffer(in, bytes, numBytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private Integer readFieldLength(InputStream in) throws IOException {
        int firstValue = in.read();
        int secondValue = in.read();
        if (firstValue < 0) {
            return null;
        }
        if (secondValue < 0) {
            throw new EOFException();
        }
        if (firstValue == 255 && secondValue == 255) {
            int ch4;
            int ch3;
            int ch2;
            int ch1 = in.read();
            if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
                throw new EOFException();
            }
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }
        return (firstValue << 8) + secondValue;
    }

    private void fillBuffer(InputStream in, byte[] buffer, int length) throws IOException {
        int bytesRead;
        int totalBytesRead = 0;
        while ((bytesRead = in.read(buffer, totalBytesRead, length - totalBytesRead)) > 0) {
            totalBytesRead += bytesRead;
        }
        if (totalBytesRead != length) {
            throw new EOFException();
        }
    }

    public int getVersion() {
        return 9;
    }
}

