/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessPolicyProviderFactory;
import org.apache.nifi.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.authorization.AccessPolicyProviderLookup;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerFactory;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.AuthorizerLookup;
import org.apache.nifi.authorization.StandardAuthorizerConfigurationContext;
import org.apache.nifi.authorization.StandardAuthorizerInitializationContext;
import org.apache.nifi.authorization.UserGroupProviderFactory;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.UserGroupProviderLookup;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.authorization.generated.AccessPolicyProvider;
import org.apache.nifi.authorization.generated.Authorizers;
import org.apache.nifi.authorization.generated.Property;
import org.apache.nifi.authorization.generated.UserGroupProvider;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.properties.scheme.ProtectionScheme;
import org.apache.nifi.properties.scheme.ProtectionSchemeResolver;
import org.apache.nifi.property.protection.loader.PropertyProtectionURLClassLoader;
import org.apache.nifi.property.protection.loader.PropertyProviderFactoryLoader;
import org.apache.nifi.property.protection.loader.ProtectionSchemeResolverLoader;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.StandardXMLStreamReaderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.xml.sax.SAXException;

public class AuthorizerFactoryBean
implements FactoryBean<Authorizer>,
DisposableBean,
UserGroupProviderLookup,
AccessPolicyProviderLookup,
AuthorizerLookup {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizerFactoryBean.class);
    private static final String AUTHORIZERS_XSD = "/authorizers.xsd";
    private static final String JAXB_GENERATED_PATH = "org.apache.nifi.authorization.generated";
    private static final JAXBContext JAXB_CONTEXT = AuthorizerFactoryBean.initializeJaxbContext();
    private NiFiProperties properties;
    private Authorizer authorizer;
    private ExtensionManager extensionManager;
    private final Map<String, org.apache.nifi.authorization.UserGroupProvider> userGroupProviders = new HashMap<String, org.apache.nifi.authorization.UserGroupProvider>();
    private final Map<String, org.apache.nifi.authorization.AccessPolicyProvider> accessPolicyProviders = new HashMap<String, org.apache.nifi.authorization.AccessPolicyProvider>();
    private final Map<String, Authorizer> authorizers = new HashMap<String, Authorizer>();

    private static JAXBContext initializeJaxbContext() {
        try {
            return JAXBContext.newInstance((String)JAXB_GENERATED_PATH, (ClassLoader)AuthorizerFactoryBean.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.");
        }
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public org.apache.nifi.authorization.UserGroupProvider getUserGroupProvider(String identifier) {
        return this.userGroupProviders.get(identifier);
    }

    public org.apache.nifi.authorization.AccessPolicyProvider getAccessPolicyProvider(String identifier) {
        return this.accessPolicyProviders.get(identifier);
    }

    public Authorizer getAuthorizer(String identifier) {
        return this.authorizers.get(identifier);
    }

    public Authorizer getObject() throws Exception {
        if (this.authorizer == null) {
            if (this.properties.getSslPort() == null) {
                this.authorizer = this.createDefaultAuthorizer();
            } else {
                String authorizerIdentifier = this.properties.getProperty("nifi.security.user.authorizer");
                if (StringUtils.isBlank((CharSequence)authorizerIdentifier)) {
                    throw new Exception("When running securely, the authorizer identifier must be specified in the nifi properties file.");
                }
                Authorizers authorizerConfiguration = this.loadAuthorizersConfiguration();
                for (UserGroupProvider userGroupProvider : authorizerConfiguration.getUserGroupProvider()) {
                    if (this.userGroupProviders.containsKey(userGroupProvider.getIdentifier())) {
                        throw new Exception("Duplicate User Group Provider identifier in Authorizers configuration: " + userGroupProvider.getIdentifier());
                    }
                    this.userGroupProviders.put(userGroupProvider.getIdentifier(), this.createUserGroupProvider(userGroupProvider.getIdentifier(), userGroupProvider.getClazz()));
                }
                for (AccessPolicyProvider accessPolicyProvider : authorizerConfiguration.getAccessPolicyProvider()) {
                    if (this.accessPolicyProviders.containsKey(accessPolicyProvider.getIdentifier())) {
                        throw new Exception("Duplicate Access Policy Provider identifier in Authorizers configuration: " + accessPolicyProvider.getIdentifier());
                    }
                    this.accessPolicyProviders.put(accessPolicyProvider.getIdentifier(), this.createAccessPolicyProvider(accessPolicyProvider.getIdentifier(), accessPolicyProvider.getClazz()));
                }
                for (org.apache.nifi.authorization.generated.Authorizer authorizer : authorizerConfiguration.getAuthorizer()) {
                    if (this.authorizers.containsKey(authorizer.getIdentifier())) {
                        throw new Exception("Duplicate Authorizer identifier in Authorizers configuration: " + authorizer.getIdentifier());
                    }
                    this.authorizers.put(authorizer.getIdentifier(), this.createAuthorizer(authorizer.getIdentifier(), authorizer.getClazz(), authorizer.getClasspath()));
                }
                this.authorizer = this.getAuthorizer(authorizerIdentifier);
                if (this.authorizer == null) {
                    throw new Exception(String.format("The specified authorizer '%s' could not be found.", authorizerIdentifier));
                }
                this.authorizer = AuthorizerFactory.installIntegrityChecks(this.authorizer);
                this.loadProviderProperties(authorizerConfiguration, authorizerIdentifier);
            }
        }
        return this.authorizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProviderProperties(Authorizers authorizerConfiguration, String authorizerIdentifier) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            AuthorizerConfigurationContext configurationContext;
            org.apache.nifi.authorization.UserGroupProvider instance;
            PropertyProtectionURLClassLoader protectionClassLoader = new PropertyProtectionURLClassLoader(contextClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)protectionClassLoader);
            ProtectionSchemeResolverLoader resolverLoader = new ProtectionSchemeResolverLoader();
            ProtectionSchemeResolver protectionSchemeResolver = resolverLoader.getProtectionSchemeResolver();
            PropertyProviderFactoryLoader factoryLoader = new PropertyProviderFactoryLoader();
            SensitivePropertyProviderFactory sensitivePropertyProviderFactory = factoryLoader.getPropertyProviderFactory();
            for (UserGroupProvider userGroupProvider : authorizerConfiguration.getUserGroupProvider()) {
                instance = this.userGroupProviders.get(userGroupProvider.getIdentifier());
                configurationContext = this.getConfigurationContext(userGroupProvider.getIdentifier(), userGroupProvider.getProperty(), sensitivePropertyProviderFactory, protectionSchemeResolver);
                instance.onConfigured(configurationContext);
            }
            for (AccessPolicyProvider accessPolicyProvider : authorizerConfiguration.getAccessPolicyProvider()) {
                instance = this.accessPolicyProviders.get(accessPolicyProvider.getIdentifier());
                configurationContext = this.getConfigurationContext(accessPolicyProvider.getIdentifier(), accessPolicyProvider.getProperty(), sensitivePropertyProviderFactory, protectionSchemeResolver);
                instance.onConfigured(configurationContext);
            }
            AuthorizerConfigurationContext authorizerConfigurationContext = null;
            for (org.apache.nifi.authorization.generated.Authorizer provider : authorizerConfiguration.getAuthorizer()) {
                if (provider.getIdentifier().equals(authorizerIdentifier)) {
                    authorizerConfigurationContext = this.getConfigurationContext(provider.getIdentifier(), provider.getProperty(), sensitivePropertyProviderFactory, protectionSchemeResolver);
                    continue;
                }
                Authorizer instance2 = this.authorizers.get(provider.getIdentifier());
                AuthorizerConfigurationContext configurationContext2 = this.getConfigurationContext(provider.getIdentifier(), provider.getProperty(), sensitivePropertyProviderFactory, protectionSchemeResolver);
                instance2.onConfigured(configurationContext2);
            }
            if (authorizerConfigurationContext == null) {
                throw new IllegalStateException("Unable to load configuration for authorizer with id: " + authorizerIdentifier);
            }
            this.authorizer.onConfigured(authorizerConfigurationContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private Authorizers loadAuthorizersConfiguration() throws Exception {
        File authorizersConfigurationFile = this.properties.getAuthorizerConfigurationFile();
        if (authorizersConfigurationFile.exists()) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(Authorizers.class.getResource(AUTHORIZERS_XSD));
                StandardXMLStreamReaderProvider provider = new StandardXMLStreamReaderProvider();
                XMLStreamReader xsr = provider.getStreamReader(new StreamSource(authorizersConfigurationFile));
                Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
                unmarshaller.setSchema(schema);
                JAXBElement element = unmarshaller.unmarshal(xsr, Authorizers.class);
                return (Authorizers)element.getValue();
            }
            catch (JAXBException | ProcessingException | SAXException e) {
                throw new Exception("Unable to load the authorizer configuration file at: " + authorizersConfigurationFile.getAbsolutePath(), e);
            }
        }
        throw new Exception("Unable to find the authorizer configuration file at " + authorizersConfigurationFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.nifi.authorization.UserGroupProvider createUserGroupProvider(String identifier, String userGroupProviderClassName) throws Exception {
        org.apache.nifi.authorization.UserGroupProvider instance;
        List userGroupProviderBundles = this.extensionManager.getBundles(userGroupProviderClassName);
        if (userGroupProviderBundles.size() == 0) {
            throw new Exception(String.format("The specified user group provider class '%s' is not known to this nifi.", userGroupProviderClassName));
        }
        if (userGroupProviderBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified user group provider class '%s', only one is allowed.", userGroupProviderClassName));
        }
        Bundle userGroupProviderBundle = (Bundle)userGroupProviderBundles.get(0);
        ClassLoader userGroupProviderClassLoader = userGroupProviderBundle.getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(userGroupProviderClassLoader);
            Class<?> rawUserGroupProviderClass = Class.forName(userGroupProviderClassName, true, userGroupProviderClassLoader);
            Class<org.apache.nifi.authorization.UserGroupProvider> userGroupProviderClass = rawUserGroupProviderClass.asSubclass(org.apache.nifi.authorization.UserGroupProvider.class);
            Constructor<org.apache.nifi.authorization.UserGroupProvider> constructor = userGroupProviderClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, userGroupProviderClass);
            this.performFieldInjection(instance, userGroupProviderClass);
            instance.initialize((UserGroupProviderInitializationContext)new StandardAuthorizerInitializationContext(identifier, (UserGroupProviderLookup)this, (AccessPolicyProviderLookup)this, (AuthorizerLookup)this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return UserGroupProviderFactory.withNarLoader(instance, userGroupProviderClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.nifi.authorization.AccessPolicyProvider createAccessPolicyProvider(String identifier, String accessPolicyProviderClassName) throws Exception {
        org.apache.nifi.authorization.AccessPolicyProvider instance;
        List accessPolicyProviderBundles = this.extensionManager.getBundles(accessPolicyProviderClassName);
        if (accessPolicyProviderBundles.size() == 0) {
            throw new Exception(String.format("The specified access policy provider class '%s' is not known to this nifi.", accessPolicyProviderClassName));
        }
        if (accessPolicyProviderBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified access policy provider class '%s', only one is allowed.", accessPolicyProviderClassName));
        }
        Bundle accessPolicyProviderBundle = (Bundle)accessPolicyProviderBundles.get(0);
        ClassLoader accessPolicyProviderClassLoader = accessPolicyProviderBundle.getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(accessPolicyProviderClassLoader);
            Class<?> rawAccessPolicyProviderClass = Class.forName(accessPolicyProviderClassName, true, accessPolicyProviderClassLoader);
            Class<org.apache.nifi.authorization.AccessPolicyProvider> accessPolicyClass = rawAccessPolicyProviderClass.asSubclass(org.apache.nifi.authorization.AccessPolicyProvider.class);
            Constructor<org.apache.nifi.authorization.AccessPolicyProvider> constructor = accessPolicyClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, accessPolicyClass);
            this.performFieldInjection(instance, accessPolicyClass);
            instance.initialize((AccessPolicyProviderInitializationContext)new StandardAuthorizerInitializationContext(identifier, (UserGroupProviderLookup)this, (AccessPolicyProviderLookup)this, (AuthorizerLookup)this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return AccessPolicyProviderFactory.withNarLoader(instance, accessPolicyProviderClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Authorizer createAuthorizer(String identifier, String authorizerClassName, String classpathResources) throws Exception {
        Authorizer instance;
        List authorizerBundles = this.extensionManager.getBundles(authorizerClassName);
        if (authorizerBundles.size() == 0) {
            throw new Exception(String.format("The specified authorizer class '%s' is not known to this nifi.", authorizerClassName));
        }
        if (authorizerBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified authorizer class '%s', only one is allowed.", authorizerClassName));
        }
        Bundle authorizerBundle = (Bundle)authorizerBundles.get(0);
        ClassLoader authorizerClassLoader = authorizerBundle.getClassLoader();
        if (StringUtils.isNotEmpty((CharSequence)classpathResources)) {
            logger.info(String.format("Replacing Authorizer ClassLoader for '%s' to include additional resources: %s", identifier, classpathResources));
            URL[] urls = ClassLoaderUtils.getURLsForClasspath((String)classpathResources, null, (boolean)true);
            authorizerClassLoader = new URLClassLoader(urls, authorizerClassLoader);
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(authorizerClassLoader);
            Class<?> rawAuthorizerClass = Class.forName(authorizerClassName, true, authorizerClassLoader);
            Class<Authorizer> authorizerClass = rawAuthorizerClass.asSubclass(Authorizer.class);
            Constructor<Authorizer> constructor = authorizerClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, authorizerClass);
            this.performFieldInjection(instance, authorizerClass);
            instance.initialize((AuthorizerInitializationContext)new StandardAuthorizerInitializationContext(identifier, (UserGroupProviderLookup)this, (AccessPolicyProviderLookup)this, (AuthorizerLookup)this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return AuthorizerFactory.withNarLoader(instance, authorizerClassLoader);
    }

    private AuthorizerConfigurationContext getConfigurationContext(String identifier, List<Property> properties, SensitivePropertyProviderFactory sensitivePropertyProviderFactory, ProtectionSchemeResolver protectionSchemeResolver) {
        HashMap<String, String> authorizerProperties = new HashMap<String, String>();
        for (Property property : properties) {
            String encryption = property.getEncryption();
            if (StringUtils.isBlank((CharSequence)encryption)) {
                authorizerProperties.put(property.getName(), property.getValue());
                continue;
            }
            String propertyDecrypted = this.getPropertyDecrypted(identifier, property, sensitivePropertyProviderFactory, protectionSchemeResolver);
            authorizerProperties.put(property.getName(), propertyDecrypted);
        }
        return new StandardAuthorizerConfigurationContext(identifier, authorizerProperties);
    }

    private String getPropertyDecrypted(String providerIdentifier, Property property, SensitivePropertyProviderFactory sensitivePropertyProviderFactory, ProtectionSchemeResolver protectionSchemeResolver) {
        String scheme = property.getEncryption();
        ProtectionScheme protectionScheme = protectionSchemeResolver.getProtectionScheme(scheme);
        SensitivePropertyProvider propertyProvider = sensitivePropertyProviderFactory.getProvider(protectionScheme);
        ProtectedPropertyContext protectedPropertyContext = sensitivePropertyProviderFactory.getPropertyContext(providerIdentifier, property.getName());
        String protectedProperty = property.getValue();
        return propertyProvider.unprotect(protectedProperty, protectedPropertyContext);
    }

    private void performMethodInjection(Object instance, Class<?> authorizerClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : authorizerClass.getMethods()) {
            Class<?> argumentType;
            if (!method.isAnnotationPresent(AuthorizerContext.class)) continue;
            method.setAccessible(true);
            Class<?>[] argumentTypes = method.getParameterTypes();
            if (argumentTypes.length != 1 || !NiFiProperties.class.isAssignableFrom(argumentType = argumentTypes[0])) continue;
            method.invoke(instance, this.properties);
        }
        Class<?> parentClass = authorizerClass.getSuperclass();
        if (parentClass != null && Authorizer.class.isAssignableFrom(parentClass)) {
            this.performMethodInjection(instance, parentClass);
        }
    }

    private void performFieldInjection(Object instance, Class<?> authorizerClass) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : authorizerClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(AuthorizerContext.class)) continue;
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (field.get(instance) != null || !NiFiProperties.class.isAssignableFrom(fieldType)) continue;
            field.set(instance, this.properties);
        }
        Class<?> parentClass = authorizerClass.getSuperclass();
        if (parentClass != null && Authorizer.class.isAssignableFrom(parentClass)) {
            this.performFieldInjection(instance, parentClass);
        }
    }

    private Authorizer createDefaultAuthorizer() {
        return new Authorizer(this){

            public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
                return AuthorizationResult.approved();
            }

            public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
            }

            public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
            }

            public void preDestruction() throws AuthorizerDestructionException {
            }
        };
    }

    public Class<Authorizer> getObjectType() {
        return Authorizer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        ArrayList errors = new ArrayList();
        this.authorizers.forEach((identifier, object) -> {
            try {
                object.preDestruction();
            }
            catch (Exception e) {
                errors.add(e);
                logger.error("Authorizer [{}] destruction failed", identifier, (Object)e);
            }
        });
        this.accessPolicyProviders.forEach((identifier, object) -> {
            try {
                object.preDestruction();
            }
            catch (Exception e) {
                errors.add(e);
                logger.error("Access Policy Provider [{}] destruction failed", identifier, (Object)e);
            }
        });
        this.userGroupProviders.forEach((identifier, object) -> {
            try {
                object.preDestruction();
            }
            catch (Exception e) {
                errors.add(e);
                logger.error("User Group Provider [{}] destruction failed", identifier, (Object)e);
            }
        });
        if (!errors.isEmpty()) {
            List errorMessages = errors.stream().map(Throwable::toString).collect(Collectors.toList());
            throw new AuthorizerDestructionException("One or more providers encountered a pre-destruction error: " + StringUtils.join(errorMessages, (String)"; "), (Throwable)errors.get(0));
        }
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

