/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.BindingUtils;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public final class DoubleBinding
extends ComparableBinding {
    public static final DoubleBinding BINDING = new DoubleBinding();

    private DoubleBinding() {
    }

    @Override
    public Double readObject(@NotNull ByteArrayInputStream stream) {
        return BindingUtils.readUnsignedDouble(stream);
    }

    @Override
    public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable object) {
        double value = (Double)object;
        if (value < 0.0) {
            throw new ExodusException("DoubleBinding can be used only for unsigned non-negative values.");
        }
        output.writeUnsignedLong(Double.doubleToLongBits(value));
    }

    public static double entryToDouble(@NotNull ByteIterable entry) {
        return (Double)BINDING.entryToObject(entry);
    }

    public static ArrayByteIterable doubleToEntry(double object) {
        return BINDING.objectToEntry(Double.valueOf(object));
    }
}

