/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.nifi.io.socket.ServerSocketConfiguration;
import org.apache.nifi.io.socket.SocketConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.security.util.TlsPlatform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketUtils {
    private static final Logger logger = LoggerFactory.getLogger(SocketUtils.class);

    public static Socket createSocket(InetSocketAddress address, SocketConfiguration config) throws IOException {
        Socket socket;
        SSLContext sslContext;
        if (address == null) {
            throw new IllegalArgumentException("Socket address may not be null.");
        }
        if (config == null) {
            throw new IllegalArgumentException("Configuration may not be null.");
        }
        try {
            sslContext = config.createSSLContext();
        }
        catch (Exception e) {
            throw new IOException("Could not create SSLContext", e);
        }
        if (sslContext == null) {
            socket = new Socket(address.getHostName(), address.getPort());
        } else {
            Socket tempSocket = sslContext.getSocketFactory().createSocket(address.getHostName(), address.getPort());
            SSLSocket sslSocket = (SSLSocket)tempSocket;
            sslSocket.setEnabledProtocols(TlsPlatform.getPreferredProtocols().toArray(new String[0]));
            socket = sslSocket;
        }
        if (config.getSocketTimeout() != null) {
            socket.setSoTimeout(config.getSocketTimeout());
        }
        if (config.getReuseAddress() != null) {
            socket.setReuseAddress(config.getReuseAddress());
        }
        if (config.getReceiveBufferSize() != null) {
            socket.setReceiveBufferSize(config.getReceiveBufferSize());
        }
        if (config.getSendBufferSize() != null) {
            socket.setSendBufferSize(config.getSendBufferSize());
        }
        if (config.getTrafficClass() != null) {
            socket.setTrafficClass(config.getTrafficClass());
        }
        if (config.getKeepAlive() != null) {
            socket.setKeepAlive(config.getKeepAlive());
        }
        if (config.getOobInline() != null) {
            socket.setOOBInline(config.getOobInline());
        }
        if (config.getTcpNoDelay() != null) {
            socket.setTcpNoDelay(config.getTcpNoDelay());
        }
        return socket;
    }

    public static ServerSocket createServerSocket(int port, ServerSocketConfiguration config) throws IOException, TlsException {
        ServerSocket serverSocket;
        if (config == null) {
            throw new NullPointerException("Configuration may not be null.");
        }
        SSLContext sslContext = config.createSSLContext();
        if (sslContext == null) {
            serverSocket = new ServerSocket(port);
        } else {
            serverSocket = sslContext.getServerSocketFactory().createServerSocket(port);
            SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket;
            sslServerSocket.setNeedClientAuth(config.getNeedClientAuth());
            sslServerSocket.setEnabledProtocols(TlsPlatform.getPreferredProtocols().toArray(new String[0]));
        }
        if (config.getSocketTimeout() != null) {
            serverSocket.setSoTimeout(config.getSocketTimeout());
        }
        if (config.getReuseAddress() != null) {
            serverSocket.setReuseAddress(config.getReuseAddress());
        }
        if (config.getReceiveBufferSize() != null) {
            serverSocket.setReceiveBufferSize(config.getReceiveBufferSize());
        }
        return serverSocket;
    }

    public static void closeQuietly(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            try {
                if (!(socket instanceof SSLSocket)) {
                    if (!socket.isInputShutdown()) {
                        socket.shutdownInput();
                    }
                    if (!socket.isOutputShutdown()) {
                        socket.shutdownOutput();
                    }
                }
            }
            finally {
                if (!socket.isClosed()) {
                    socket.close();
                }
            }
        }
        catch (Exception ex) {
            logger.debug("Failed to close socket", (Throwable)ex);
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket == null) {
            return;
        }
        try {
            serverSocket.close();
        }
        catch (Exception ex) {
            logger.debug("Failed to close server socket", (Throwable)ex);
        }
    }

    public static boolean isTlsError(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof CertificateException || e instanceof TlsException || e instanceof SSLException) {
            return true;
        }
        if (e.getCause() != null) {
            return SocketUtils.isTlsError(e.getCause());
        }
        return false;
    }
}

