/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.minifi.toolkit.configuration.ConfigMain;
import org.apache.nifi.minifi.toolkit.configuration.ConfigTransformException;
import org.apache.nifi.minifi.toolkit.configuration.PathInputStreamFactory;
import org.apache.nifi.minifi.toolkit.configuration.PathOutputStreamFactory;
import org.apache.nifi.minifi.toolkit.configuration.json.ConfigSchemaToVersionedDataFlowTransformer;
import org.apache.nifi.minifi.toolkit.schema.ConfigSchema;
import org.apache.nifi.minifi.toolkit.schema.common.ConvertableSchema;
import org.apache.nifi.minifi.toolkit.schema.common.Schema;
import org.apache.nifi.minifi.toolkit.schema.exception.SchemaInstantiatonException;
import org.apache.nifi.minifi.toolkit.schema.exception.SchemaLoaderException;
import org.apache.nifi.minifi.toolkit.schema.serialization.SchemaLoader;

public class TransformYamlCommandFactory {
    public static final String TRANSFORM_YML = "transform-yml";
    private static final String COMMAND_DESCRIPTION = "Transform MiNiFi config YAML into NiFi flow JSON format";
    private static final String PROPERTY_KEY_VALUE_DELIMITER = "=";
    private final PathInputStreamFactory pathInputStreamFactory;
    private final PathOutputStreamFactory pathOutputStreamFactory;

    public TransformYamlCommandFactory(PathInputStreamFactory pathInputStreamFactory, PathOutputStreamFactory pathOutputStreamFactory) {
        this.pathInputStreamFactory = pathInputStreamFactory;
        this.pathOutputStreamFactory = pathOutputStreamFactory;
    }

    public ConfigMain.Command create() {
        return new ConfigMain.Command(this::transformYamlToJson, COMMAND_DESCRIPTION);
    }

    private int transformYamlToJson(String[] args) {
        if (args.length != 5) {
            this.printTransformYmlUsage();
            return 1;
        }
        String sourceMiNiFiConfigYamlPath = args[1];
        String sourceBootstrapConfigPath = args[2];
        String targetFlowJsonPath = args[3];
        String targetBootstrapConfigPath = args[4];
        try {
            ConfigSchema configSchema = this.readMiNiFiConfig(sourceMiNiFiConfigYamlPath);
            Properties sourceBootstrapProperties = this.loadProperties(sourceBootstrapConfigPath);
            Properties targetBootstrapProperties = this.loadProperties(targetBootstrapConfigPath);
            ConfigSchemaToVersionedDataFlowTransformer transformer = new ConfigSchemaToVersionedDataFlowTransformer(configSchema);
            VersionedDataflow convertedFlow = transformer.convert();
            Map<String, String> extractedProperties = transformer.extractProperties();
            targetBootstrapProperties.putAll(sourceBootstrapProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            targetBootstrapProperties.putAll(extractedProperties);
            this.persistFlowJson(convertedFlow, targetFlowJsonPath);
            this.persistProperties(targetBootstrapProperties, targetBootstrapConfigPath);
        }
        catch (ConfigTransformException e) {
            System.out.println("Unable to convert MiNiFi config YAML to flow JSON: " + String.valueOf(e));
            return e.getErrorCode();
        }
        return 0;
    }

    private void printTransformYmlUsage() {
        System.out.println("Transform YML Usage:");
        System.out.println();
        System.out.println(" transform-yml SOURCE_MINIFI_CONFIG_YAML_FILE SOURCE_BOOTSTRAP_PROPERTIES_FILE TARGET_FLOW_JSON_FILE TARGET_BOOTSTRAP_PROPERTIES_FILE");
        System.out.println();
    }

    private ConfigSchema readMiNiFiConfig(String miNiFiConfigPath) throws ConfigTransformException {
        ConfigSchema configSchema;
        block9: {
            InputStream inputStream = this.pathInputStreamFactory.create(miNiFiConfigPath);
            try {
                ConvertableSchema convertableSchema = this.throwIfInvalid(SchemaLoader.loadConvertableSchemaFromYaml((InputStream)inputStream));
                configSchema = this.throwIfInvalid((ConfigSchema)convertableSchema.convert());
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigTransformException("Error when read MiNiFi config file", 4, e);
                }
                catch (SchemaLoaderException e) {
                    throw new ConfigTransformException("Error when parsing MiNiFi config file", 6, e);
                }
            }
            inputStream.close();
        }
        return configSchema;
    }

    private <T extends Schema> T throwIfInvalid(T schema) throws SchemaLoaderException {
        if (!schema.isValid()) {
            throw new SchemaInstantiatonException("Failed to transform config file due to:[" + schema.getValidationIssues().stream().sorted().collect(Collectors.joining("], [")) + "]");
        }
        return schema;
    }

    private Properties loadProperties(String propertiesFilePath) throws ConfigTransformException {
        Properties properties;
        block8: {
            InputStream inputStream = this.pathInputStreamFactory.create(propertiesFilePath);
            try {
                Properties properties2 = new Properties();
                properties2.load(inputStream);
                properties = properties2;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigTransformException("Error when read properties file: " + propertiesFilePath, 3, e);
                }
            }
            inputStream.close();
        }
        return properties;
    }

    private void persistFlowJson(VersionedDataflow flow, String flowJsonPath) throws ConfigTransformException {
        try (OutputStream outputStream = this.pathOutputStreamFactory.create(flowJsonPath);){
            ObjectMapper objectMapper = this.createObjectMapper();
            objectMapper.writeValue(outputStream, (Object)flow);
        }
        catch (IOException e) {
            throw new ConfigTransformException("Error when persisting flow JSON file: " + flowJsonPath, 9, e);
        }
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(objectMapper.getTypeFactory()));
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    private void persistProperties(Properties properties, String bootstrapPropertiesPath) throws ConfigTransformException {
        try (OutputStream outputStream = this.pathOutputStreamFactory.create(bootstrapPropertiesPath);){
            IOUtils.write((String)properties.entrySet().stream().map(entry -> String.valueOf(entry.getKey()) + PROPERTY_KEY_VALUE_DELIMITER + String.valueOf(entry.getValue())).sorted().collect(Collectors.joining(System.lineSeparator())), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ConfigTransformException("Error when persisting bootstrap properties file: " + bootstrapPropertiesPath, 9, e);
        }
    }
}

