/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.documentation.html;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.MultiProcessorUseCase;
import org.apache.nifi.annotation.documentation.ProcessorConfiguration;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDependency;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceDefinition;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.documentation.DocumentationWriter;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlDocumentationWriter
implements DocumentationWriter {
    public static final Logger LOGGER = LoggerFactory.getLogger(HtmlDocumentationWriter.class);
    public static final String ADDITIONAL_DETAILS_HTML = "additionalDetails.html";
    private final ExtensionManager extensionManager;

    public HtmlDocumentationWriter(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Override
    public void write(ConfigurableComponent configurableComponent, OutputStream streamToWriteTo, boolean includesAdditionalDocumentation) throws IOException {
        try {
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(streamToWriteTo, "UTF-8");
            xmlStreamWriter.writeDTD("<!DOCTYPE html>");
            xmlStreamWriter.writeStartElement("html");
            xmlStreamWriter.writeAttribute("lang", "en");
            this.writeHead(configurableComponent, xmlStreamWriter);
            this.writeBody(configurableComponent, xmlStreamWriter, includesAdditionalDocumentation);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.close();
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IOException("Unable to create XMLOutputStream", e);
        }
    }

    protected void writeHead(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("head");
        xmlStreamWriter.writeStartElement("meta");
        xmlStreamWriter.writeAttribute("charset", "utf-8");
        xmlStreamWriter.writeEndElement();
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "title", this.getTitle(configurableComponent));
        xmlStreamWriter.writeStartElement("link");
        xmlStreamWriter.writeAttribute("rel", "stylesheet");
        xmlStreamWriter.writeAttribute("href", "../../../../../css/component-usage.css");
        xmlStreamWriter.writeAttribute("type", "text/css");
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("script");
        xmlStreamWriter.writeAttribute("type", "text/javascript");
        xmlStreamWriter.writeCharacters("window.onload = function(){if(self==top) { document.getElementById('nameHeader').style.display = \"inherit\"; } }");
        xmlStreamWriter.writeEndElement();
    }

    protected String getTitle(ConfigurableComponent configurableComponent) {
        return configurableComponent.getClass().getSimpleName();
    }

    private void writeBody(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter, boolean hasAdditionalDetails) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("body");
        this.writeHeader(configurableComponent, xmlStreamWriter);
        this.writeDeprecationWarning(configurableComponent, xmlStreamWriter);
        this.writeDescription(configurableComponent, xmlStreamWriter, hasAdditionalDetails);
        this.writeTags(configurableComponent, xmlStreamWriter);
        this.writeProperties(configurableComponent, xmlStreamWriter);
        this.writeDynamicProperties(configurableComponent, xmlStreamWriter);
        this.writeAdditionalBodyInfo(configurableComponent, xmlStreamWriter);
        this.writeStatefulInfo(configurableComponent, xmlStreamWriter);
        this.writeRestrictedInfo(configurableComponent, xmlStreamWriter);
        this.writeInputRequirementInfo(configurableComponent, xmlStreamWriter);
        this.writeUseCases(configurableComponent, xmlStreamWriter);
        this.writeMultiComponentUseCases(configurableComponent, xmlStreamWriter);
        this.writeSystemResourceConsiderationInfo(configurableComponent, xmlStreamWriter);
        this.writeSeeAlso(configurableComponent, xmlStreamWriter);
        xmlStreamWriter.writeEndElement();
    }

    private void writeHeader(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("h1");
        xmlStreamWriter.writeAttribute("id", "nameHeader");
        xmlStreamWriter.writeAttribute("style", "display: none;");
        xmlStreamWriter.writeCharacters(this.getTitle(configurableComponent));
        xmlStreamWriter.writeEndElement();
    }

    private void writeInputRequirementInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        InputRequirement inputRequirement = configurableComponent.getClass().getAnnotation(InputRequirement.class);
        if (inputRequirement != null) {
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Input requirement: ");
            switch (inputRequirement.value()) {
                case INPUT_FORBIDDEN: {
                    xmlStreamWriter.writeCharacters("This component does not allow an incoming relationship.");
                    break;
                }
                case INPUT_ALLOWED: {
                    xmlStreamWriter.writeCharacters("This component allows an incoming relationship.");
                    break;
                }
                case INPUT_REQUIRED: {
                    xmlStreamWriter.writeCharacters("This component requires an incoming relationship.");
                    break;
                }
                default: {
                    xmlStreamWriter.writeCharacters("This component does not have input requirement.");
                }
            }
        }
    }

    private void writeStatefulInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        Stateful stateful = configurableComponent.getClass().getAnnotation(Stateful.class);
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "State management: ");
        if (stateful != null) {
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "stateful");
            xmlStreamWriter.writeStartElement("tr");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Scope");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("tr");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", HtmlDocumentationWriter.join(stateful.scopes()));
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", stateful.description());
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
        } else {
            xmlStreamWriter.writeCharacters("This component does not store state.");
        }
    }

    private void writeRestrictedInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        Restricted restricted = configurableComponent.getClass().getAnnotation(Restricted.class);
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Restricted: ");
        if (restricted != null) {
            Restriction[] restrictions;
            String value = restricted.value();
            if (!StringUtils.isBlank((String)value)) {
                xmlStreamWriter.writeCharacters(restricted.value());
            }
            if ((restrictions = restricted.restrictions()) != null && restrictions.length > 0) {
                xmlStreamWriter.writeStartElement("table");
                xmlStreamWriter.writeAttribute("id", "restrictions");
                xmlStreamWriter.writeStartElement("tr");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Required Permission");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Explanation");
                xmlStreamWriter.writeEndElement();
                for (Restriction restriction : restrictions) {
                    xmlStreamWriter.writeStartElement("tr");
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", restriction.requiredPermission().getPermissionLabel());
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", restriction.explanation());
                    xmlStreamWriter.writeEndElement();
                }
                xmlStreamWriter.writeEndElement();
            } else {
                xmlStreamWriter.writeCharacters("This component requires access to restricted components regardless of restriction.");
            }
        } else {
            xmlStreamWriter.writeCharacters("This component is not restricted.");
        }
    }

    private void writeDeprecationWarning(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        DeprecationNotice deprecationNotice = configurableComponent.getClass().getAnnotation(DeprecationNotice.class);
        if (deprecationNotice != null) {
            xmlStreamWriter.writeStartElement("h2");
            xmlStreamWriter.writeCharacters("Deprecation notice: ");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("");
            if (!StringUtils.isEmpty((String)deprecationNotice.reason())) {
                xmlStreamWriter.writeCharacters(deprecationNotice.reason());
            } else {
                xmlStreamWriter.writeCharacters("Please be aware this processor is deprecated and may be removed in the near future.");
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("Please consider using one the following alternatives: ");
            Class[] componentNames = deprecationNotice.alternatives();
            String[] classNames = deprecationNotice.classNames();
            if (componentNames.length > 0 || classNames.length > 0) {
                this.iterateAndLinkComponents(xmlStreamWriter, componentNames, classNames, ",", configurableComponent.getClass().getSimpleName());
            } else {
                xmlStreamWriter.writeCharacters("No alternative components suggested.");
            }
            xmlStreamWriter.writeEndElement();
        }
    }

    private void writeSeeAlso(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        SeeAlso seeAlso = configurableComponent.getClass().getAnnotation(SeeAlso.class);
        if (seeAlso != null) {
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "See Also:");
            xmlStreamWriter.writeStartElement("p");
            Class[] componentNames = seeAlso.value();
            String[] classNames = seeAlso.classNames();
            if (componentNames.length > 0 || classNames.length > 0) {
                this.iterateAndLinkComponents(xmlStreamWriter, componentNames, classNames, ", ", configurableComponent.getClass().getSimpleName());
            } else {
                xmlStreamWriter.writeCharacters("No tags provided.");
            }
            xmlStreamWriter.writeEndElement();
        }
    }

    protected void writeAdditionalBodyInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
    }

    private void writeTags(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        Tags tags = configurableComponent.getClass().getAnnotation(Tags.class);
        xmlStreamWriter.writeStartElement("h3");
        xmlStreamWriter.writeCharacters("Tags: ");
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("p");
        if (tags != null) {
            String tagString = HtmlDocumentationWriter.join(tags.value());
            xmlStreamWriter.writeCharacters(tagString);
        } else {
            xmlStreamWriter.writeCharacters("No tags provided.");
        }
        xmlStreamWriter.writeEndElement();
    }

    static String join(Object[] objects) {
        return Arrays.stream(objects).map(Object::toString).collect(Collectors.joining(", "));
    }

    protected void writeDescription(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter, boolean hasAdditionalDetails) throws XMLStreamException {
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h2", "Description: ");
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "p", this.getDescription(configurableComponent));
        if (hasAdditionalDetails) {
            xmlStreamWriter.writeStartElement("p");
            this.writeLink(xmlStreamWriter, "Additional Details...", ADDITIONAL_DETAILS_HTML);
            xmlStreamWriter.writeEndElement();
        }
    }

    protected String getDescription(ConfigurableComponent configurableComponent) {
        CapabilityDescription capabilityDescription = configurableComponent.getClass().getAnnotation(CapabilityDescription.class);
        String description = capabilityDescription != null ? capabilityDescription.value() : "No description provided.";
        return description;
    }

    protected void writeUseCases(ConfigurableComponent component, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        UseCase[] useCases = (UseCase[])component.getClass().getAnnotationsByType(UseCase.class);
        if (useCases.length == 0) {
            return;
        }
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h2", "Example Use Cases:");
        for (UseCase useCase : useCases) {
            InputRequirement.Requirement inputRequirement;
            CharSequence[] keywords;
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Use Case:");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "p", useCase.description());
            String notes = useCase.notes();
            if (!StringUtils.isEmpty((String)notes)) {
                String[] splits;
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h4", "Notes:");
                for (String split : splits = notes.split("\\n")) {
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "p", split);
                }
            }
            if ((keywords = useCase.keywords()).length > 0) {
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h4", "Keywords:");
                xmlStreamWriter.writeCharacters(String.join((CharSequence)", ", keywords));
            }
            if ((inputRequirement = useCase.inputRequirement()) != InputRequirement.Requirement.INPUT_ALLOWED) {
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h4", "Input Requirement:");
                xmlStreamWriter.writeCharacters(inputRequirement.toString());
            }
            String configuration = useCase.configuration();
            this.writeUseCaseConfiguration(configuration, xmlStreamWriter);
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "br", null);
        }
    }

    protected void writeMultiComponentUseCases(ConfigurableComponent component, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        MultiProcessorUseCase[] useCases = (MultiProcessorUseCase[])component.getClass().getAnnotationsByType(MultiProcessorUseCase.class);
        if (useCases.length == 0) {
            return;
        }
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h2", "Example Use Cases Involving Other Components:");
        for (MultiProcessorUseCase useCase : useCases) {
            ProcessorConfiguration[] processorConfigurations;
            CharSequence[] keywords;
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Use Case:");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "p", useCase.description());
            String notes = useCase.notes();
            if (!StringUtils.isEmpty((String)notes)) {
                String[] splits;
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h4", "Notes:");
                for (String split : splits = notes.split("\\n")) {
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "p", split);
                }
            }
            if ((keywords = useCase.keywords()).length > 0) {
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h4", "Keywords:");
                xmlStreamWriter.writeCharacters(String.join((CharSequence)", ", keywords));
            }
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h4", "Components involved:");
            for (ProcessorConfiguration processorConfiguration : processorConfigurations = useCase.configurations()) {
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "Component Type: ");
                String extensionClassName = processorConfiguration.processorClassName().isEmpty() ? processorConfiguration.processorClass().getName() : processorConfiguration.processorClassName();
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "span", extensionClassName);
                String configuration = processorConfiguration.configuration();
                this.writeUseCaseConfiguration(configuration, xmlStreamWriter);
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "br", null);
            }
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "br", null);
        }
    }

    private void writeUseCaseConfiguration(String configuration, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        String[] splits;
        if (StringUtils.isEmpty((String)configuration)) {
            return;
        }
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h4", "Configuration:");
        for (String split : splits = configuration.split("\\n")) {
            xmlStreamWriter.writeStartElement("p");
            Matcher matcher = Pattern.compile("`(.*?)`").matcher(split);
            int startIndex = 0;
            while (matcher.find()) {
                int start = matcher.start();
                if (start > 0) {
                    xmlStreamWriter.writeCharacters(split.substring(startIndex, start));
                }
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "code", matcher.group(1));
                startIndex = matcher.end();
            }
            if (split.length() > startIndex) {
                if (startIndex == 0) {
                    xmlStreamWriter.writeCharacters(split);
                } else {
                    xmlStreamWriter.writeCharacters(split.substring(startIndex));
                }
            }
            xmlStreamWriter.writeEndElement();
        }
    }

    protected void writeProperties(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List properties = configurableComponent.getPropertyDescriptors();
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Properties: ");
        if (properties.size() > 0) {
            boolean containsExpressionLanguage = this.containsExpressionLanguage(configurableComponent);
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("In the list below, the names of required properties appear in ");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "bold");
            xmlStreamWriter.writeCharacters(". Any other properties (not in bold) are considered optional. The table also indicates any default values");
            if (containsExpressionLanguage) {
                xmlStreamWriter.writeCharacters(", and whether a property supports the ");
                this.writeLink(xmlStreamWriter, "NiFi Expression Language", "../../../../../html/expression-language-guide.html");
            }
            xmlStreamWriter.writeCharacters(".");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "properties");
            xmlStreamWriter.writeStartElement("tr");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Display Name");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "API Name");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Default Value");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Allowable Values");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (PropertyDescriptor property : properties) {
                Set dependencies;
                ResourceDefinition resourceDefinition;
                xmlStreamWriter.writeStartElement("tr");
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeAttribute("id", "name");
                if (property.isRequired()) {
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", property.getDisplayName());
                } else {
                    xmlStreamWriter.writeCharacters(property.getDisplayName());
                }
                xmlStreamWriter.writeEndElement();
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", property.getName());
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", this.getDefaultValue(property), "default-value");
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeAttribute("id", "allowable-values");
                this.writeValidValues(xmlStreamWriter, property);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeAttribute("id", "description");
                if (property.getDescription() != null && property.getDescription().trim().length() > 0) {
                    xmlStreamWriter.writeCharacters(property.getDescription());
                } else {
                    xmlStreamWriter.writeCharacters("No Description Provided.");
                }
                if (property.isSensitive()) {
                    xmlStreamWriter.writeEmptyElement("br");
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "Sensitive Property: true");
                }
                if ((resourceDefinition = property.getResourceDefinition()) != null) {
                    xmlStreamWriter.writeEmptyElement("br");
                    xmlStreamWriter.writeEmptyElement("br");
                    xmlStreamWriter.writeStartElement("strong");
                    ResourceCardinality cardinality = resourceDefinition.getCardinality();
                    Set resourceTypes = resourceDefinition.getResourceTypes();
                    if (cardinality == ResourceCardinality.MULTIPLE) {
                        if (resourceTypes.size() == 1) {
                            xmlStreamWriter.writeCharacters("This property expects a comma-separated list of " + String.valueOf(resourceTypes.iterator().next()) + " resources");
                        } else {
                            xmlStreamWriter.writeCharacters("This property expects a comma-separated list of resources. Each of the resources may be of any of the following types: " + StringUtils.join((Collection)resourceDefinition.getResourceTypes(), (String)", "));
                        }
                    } else if (resourceTypes.size() == 1) {
                        xmlStreamWriter.writeCharacters("This property requires exactly one " + String.valueOf(resourceTypes.iterator().next()) + " to be provided.");
                    } else {
                        xmlStreamWriter.writeCharacters("This property requires exactly one resource to be provided. That resource may be any of the following types: " + StringUtils.join((Collection)resourceDefinition.getResourceTypes(), (String)", "));
                    }
                    xmlStreamWriter.writeCharacters(".");
                    xmlStreamWriter.writeEndElement();
                    xmlStreamWriter.writeEmptyElement("br");
                }
                if (property.isExpressionLanguageSupported()) {
                    xmlStreamWriter.writeEmptyElement("br");
                    Object text = "Supports Expression Language: true";
                    String perFF = " (will be evaluated using flow file attributes and Environment variables)";
                    String registry = " (will be evaluated using Environment variables only)";
                    InputRequirement inputRequirement = configurableComponent.getClass().getAnnotation(InputRequirement.class);
                    switch (property.getExpressionLanguageScope()) {
                        case FLOWFILE_ATTRIBUTES: {
                            if (inputRequirement != null && inputRequirement.value().equals((Object)InputRequirement.Requirement.INPUT_FORBIDDEN)) {
                                text = (String)text + " (will be evaluated using Environment variables only)";
                                break;
                            }
                            text = (String)text + " (will be evaluated using flow file attributes and Environment variables)";
                            break;
                        }
                        case ENVIRONMENT: {
                            text = (String)text + " (will be evaluated using Environment variables only)";
                            break;
                        }
                        default: {
                            text = (String)text + " (undefined scope)";
                        }
                    }
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", (String)text);
                }
                if (!(dependencies = property.getDependencies()).isEmpty()) {
                    boolean capitalizeThe;
                    xmlStreamWriter.writeEmptyElement("br");
                    xmlStreamWriter.writeEmptyElement("br");
                    if (dependencies.size() == 1) {
                        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "This Property is only considered if ");
                        capitalizeThe = false;
                    } else {
                        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "This Property is only considered if all of the following conditions are met:");
                        xmlStreamWriter.writeStartElement("ul");
                        capitalizeThe = true;
                    }
                    for (PropertyDependency dependency : dependencies) {
                        Set dependentValues = dependency.getDependentValues();
                        String prefix = (capitalizeThe ? "The" : "the") + " [" + dependency.getPropertyDisplayName() + "] Property ";
                        Object suffix = "";
                        if (dependentValues == null) {
                            suffix = "has a value specified.";
                        } else {
                            PropertyDescriptor dependencyProperty = null;
                            for (PropertyDescriptor prop : properties) {
                                if (!prop.getName().equals(dependency.getPropertyName())) continue;
                                dependencyProperty = prop;
                                break;
                            }
                            if (null == dependencyProperty) {
                                throw new XMLStreamException("No property was found matching the name '" + dependency.getPropertyName() + "'");
                            }
                            if (dependentValues.size() == 1) {
                                String requiredValue = (String)dependentValues.iterator().next();
                                List allowableValues = dependencyProperty.getAllowableValues();
                                if (allowableValues != null) {
                                    for (AllowableValue av : allowableValues) {
                                        if (!requiredValue.equals(av.getValue())) continue;
                                        suffix = "has a value of \"" + av.getDisplayName() + "\".";
                                        break;
                                    }
                                }
                            } else {
                                StringBuilder sb = new StringBuilder("is set to one of the following values: ");
                                block8: for (String dependentValue : dependentValues) {
                                    List allowableValues = dependencyProperty.getAllowableValues();
                                    if (allowableValues == null) {
                                        sb.append("[").append(dependentValue).append("], ");
                                        continue;
                                    }
                                    for (AllowableValue av : allowableValues) {
                                        if (!dependentValue.equals(av.getValue())) continue;
                                        sb.append("[").append(av.getDisplayName()).append("], ");
                                        continue block8;
                                    }
                                }
                                sb.setLength(sb.length() - 2);
                                suffix = sb.toString();
                            }
                        }
                        String elementName = dependencies.size() > 1 ? "li" : "strong";
                        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, elementName, prefix + (String)suffix);
                    }
                    if (dependencies.size() > 1) {
                        xmlStreamWriter.writeEndElement();
                    }
                }
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else {
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "p", "This component has no required or optional properties.");
        }
    }

    private String getDefaultValue(PropertyDescriptor propertyDescriptor) {
        String descriptorDefaultValue = propertyDescriptor.getDefaultValue();
        List allowableValues = propertyDescriptor.getAllowableValues();
        String defaultValue = allowableValues != null ? allowableValues.stream().filter(allowableValue -> allowableValue.getValue().equals(descriptorDefaultValue)).findFirst().map(AllowableValue::getDisplayName).orElse(descriptorDefaultValue) : descriptorDefaultValue;
        return defaultValue;
    }

    private boolean containsExpressionLanguage(ConfigurableComponent component) {
        for (PropertyDescriptor descriptor : component.getPropertyDescriptors()) {
            if (!descriptor.isExpressionLanguageSupported()) continue;
            return true;
        }
        return false;
    }

    private void writeDynamicProperties(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List<DynamicProperty> dynamicProperties = this.getDynamicProperties(configurableComponent);
        if (dynamicProperties.size() > 0) {
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Dynamic Properties: ");
            this.writeSupportsSensitiveDynamicProperties(configurableComponent, xmlStreamWriter);
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("Dynamic Properties allow the user to specify both the name and value of a property.");
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "dynamic-properties");
            xmlStreamWriter.writeStartElement("tr");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Name");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Value");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (DynamicProperty dynamicProperty : dynamicProperties) {
                xmlStreamWriter.writeStartElement("tr");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", dynamicProperty.name(), "name");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", dynamicProperty.value(), "value");
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeCharacters(dynamicProperty.description());
                xmlStreamWriter.writeEmptyElement("br");
                String text = switch (dynamicProperty.expressionLanguageScope()) {
                    case ExpressionLanguageScope.FLOWFILE_ATTRIBUTES -> "Supports Expression Language: true (will be evaluated using flow file attributes and Environment variables)";
                    case ExpressionLanguageScope.ENVIRONMENT -> "Supports Expression Language: true (will be evaluated using Environment variables only)";
                    default -> "Supports Expression Language: false";
                };
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", text);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
        }
    }

    private void writeSupportsSensitiveDynamicProperties(ConfigurableComponent configurableComponent, XMLStreamWriter writer) throws XMLStreamException {
        boolean supportsSensitiveDynamicProperties = configurableComponent.getClass().isAnnotationPresent(SupportsSensitiveDynamicProperties.class);
        String sensitiveDynamicPropertiesLabel = supportsSensitiveDynamicProperties ? "Yes" : "No";
        writer.writeStartElement("p");
        writer.writeCharacters("Supports Sensitive Dynamic Properties: ");
        HtmlDocumentationWriter.writeSimpleElement(writer, "strong", sensitiveDynamicPropertiesLabel);
        writer.writeEndElement();
    }

    private List<DynamicProperty> getDynamicProperties(ConfigurableComponent configurableComponent) {
        DynamicProperty dynProp;
        ArrayList<DynamicProperty> dynamicProperties = new ArrayList<DynamicProperty>();
        DynamicProperties dynProps = configurableComponent.getClass().getAnnotation(DynamicProperties.class);
        if (dynProps != null) {
            Collections.addAll(dynamicProperties, dynProps.value());
        }
        if ((dynProp = configurableComponent.getClass().getAnnotation(DynamicProperty.class)) != null) {
            dynamicProperties.add(dynProp);
        }
        return dynamicProperties;
    }

    private void writeValidValueDescription(XMLStreamWriter xmlStreamWriter, String description) throws XMLStreamException {
        xmlStreamWriter.writeCharacters(" ");
        xmlStreamWriter.writeStartElement("img");
        xmlStreamWriter.writeAttribute("src", "../../../../../html/images/iconInfo.png");
        xmlStreamWriter.writeAttribute("alt", description);
        xmlStreamWriter.writeAttribute("title", description);
        xmlStreamWriter.writeEndElement();
    }

    protected void writeValidValues(XMLStreamWriter xmlStreamWriter, PropertyDescriptor property) throws XMLStreamException {
        if (property.getAllowableValues() != null && property.getAllowableValues().size() > 0) {
            xmlStreamWriter.writeStartElement("ul");
            for (AllowableValue value : property.getAllowableValues()) {
                xmlStreamWriter.writeStartElement("li");
                xmlStreamWriter.writeCharacters(value.getDisplayName());
                if (value.getDescription() != null) {
                    this.writeValidValueDescription(xmlStreamWriter, value.getDescription());
                }
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else if (property.getControllerServiceDefinition() != null) {
            Class controllerServiceClass = property.getControllerServiceDefinition();
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "Controller Service API: ");
            xmlStreamWriter.writeEmptyElement("br");
            xmlStreamWriter.writeCharacters(controllerServiceClass.getSimpleName());
            Class<? extends ControllerService>[] serviceImplementations = this.lookupControllerServiceImpls(controllerServiceClass);
            xmlStreamWriter.writeEmptyElement("br");
            if (serviceImplementations.length > 0) {
                String title = serviceImplementations.length > 1 ? "Implementations: " : "Implementation: ";
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", title);
                this.iterateAndLinkComponents(xmlStreamWriter, serviceImplementations, null, "<br>", controllerServiceClass.getSimpleName());
            } else {
                xmlStreamWriter.writeCharacters("No implementations found.");
            }
        }
    }

    protected static void writeSimpleElement(XMLStreamWriter writer, String elementName, String characters, String id) throws XMLStreamException {
        writer.writeStartElement(elementName);
        if (characters != null) {
            if (id != null) {
                writer.writeAttribute("id", id);
            }
            writer.writeCharacters(characters);
        }
        writer.writeEndElement();
    }

    protected static void writeSimpleElement(XMLStreamWriter writer, String elementName, String characters) throws XMLStreamException {
        HtmlDocumentationWriter.writeSimpleElement(writer, elementName, characters, null);
    }

    protected void writeLink(XMLStreamWriter xmlStreamWriter, String text, String location) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("a");
        xmlStreamWriter.writeAttribute("href", location);
        xmlStreamWriter.writeCharacters(text);
        xmlStreamWriter.writeEndElement();
    }

    private void writeSystemResourceConsiderationInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        SystemResourceConsideration[] systemResourceConsiderations = (SystemResourceConsideration[])configurableComponent.getClass().getAnnotationsByType(SystemResourceConsideration.class);
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "System Resource Considerations:");
        if (systemResourceConsiderations.length > 0) {
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "system-resource-considerations");
            xmlStreamWriter.writeStartElement("tr");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Resource");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (SystemResourceConsideration systemResourceConsideration : systemResourceConsiderations) {
                xmlStreamWriter.writeStartElement("tr");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", systemResourceConsideration.resource().name());
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", systemResourceConsideration.description().trim().isEmpty() ? "Not Specified" : systemResourceConsideration.description());
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else {
            xmlStreamWriter.writeCharacters("None specified.");
        }
    }

    private Class<? extends ControllerService>[] lookupControllerServiceImpls(Class<? extends ControllerService> parent) {
        ArrayList<Class> implementations = new ArrayList<Class>();
        Set controllerServices = this.extensionManager.getExtensions(ControllerService.class);
        for (ExtensionDefinition extensionDefinition : controllerServices) {
            Class controllerServiceClass = this.extensionManager.getClass(extensionDefinition);
            if (!parent.isAssignableFrom(controllerServiceClass)) continue;
            implementations.add(controllerServiceClass);
        }
        return implementations.toArray(new Class[0]);
    }

    protected void iterateAndLinkComponents(XMLStreamWriter xmlStreamWriter, Class<? extends ConfigurableComponent>[] linkedComponents, String[] classNames, String separator, String sourceContextName) throws XMLStreamException {
        String effectiveSeparator = separator;
        boolean separatorIsElement = effectiveSeparator.startsWith("<") && effectiveSeparator.endsWith(">");
        effectiveSeparator = effectiveSeparator.replaceAll("<([^>]*)>", "$1");
        int index = 0;
        for (Class<? extends ConfigurableComponent> linkedComponent : linkedComponents) {
            String linkedComponentName = linkedComponent.getName();
            List linkedComponentBundles = this.extensionManager.getBundles(linkedComponentName);
            if (linkedComponentBundles != null && linkedComponentBundles.size() > 0) {
                Bundle firstLinkedComponentBundle = (Bundle)linkedComponentBundles.get(0);
                BundleCoordinate coordinate = firstLinkedComponentBundle.getBundleDetails().getCoordinate();
                String group = coordinate.getGroup();
                String id = coordinate.getId();
                String version = coordinate.getVersion();
                if (index != 0) {
                    if (separatorIsElement) {
                        xmlStreamWriter.writeEmptyElement(effectiveSeparator);
                    } else {
                        xmlStreamWriter.writeCharacters(effectiveSeparator);
                    }
                }
                this.writeLink(xmlStreamWriter, linkedComponent.getSimpleName(), "../../../../../components/" + group + "/" + id + "/" + version + "/" + linkedComponent.getCanonicalName() + "/index.html");
                ++index;
                continue;
            }
            LOGGER.warn("Could not link to {} because no bundles were found for {}", (Object)linkedComponentName, (Object)sourceContextName);
        }
        if (classNames != null) {
            for (String className : classNames) {
                List linkedComponentBundles;
                if (index != 0) {
                    if (separatorIsElement) {
                        xmlStreamWriter.writeEmptyElement(effectiveSeparator);
                    } else {
                        xmlStreamWriter.writeCharacters(effectiveSeparator);
                    }
                }
                if ((linkedComponentBundles = this.extensionManager.getBundles(className)) != null && linkedComponentBundles.size() > 0) {
                    Bundle firstBundle = (Bundle)linkedComponentBundles.get(0);
                    BundleCoordinate firstCoordinate = firstBundle.getBundleDetails().getCoordinate();
                    String group = firstCoordinate.getGroup();
                    String id = firstCoordinate.getId();
                    String version = firstCoordinate.getVersion();
                    String link = "../../../../../components/" + group + "/" + id + "/" + version + "/" + (String)className + "/index.html";
                    int indexOfLastPeriod = className.lastIndexOf(".") + 1;
                    this.writeLink(xmlStreamWriter, className.substring(indexOfLastPeriod), link);
                    ++index;
                    continue;
                }
                LOGGER.warn("Could not link to {} because no bundles were found for {}", (Object)className, (Object)sourceContextName);
            }
        }
    }
}

