/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import jetbrains.exodus.core.dataStructures.IntObjectCacheBase;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000  *\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u001f B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0017\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\u0017\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u001d\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016R\u001e\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ljetbrains/exodus/core/dataStructures/ConcurrentIntObjectCache;", "V", "Ljetbrains/exodus/core/dataStructures/IntObjectCacheBase;", "size", "", "numberOfGenerations", "(II)V", "cache", "", "Ljetbrains/exodus/core/dataStructures/ConcurrentIntObjectCache$CacheEntry;", "[Ljetbrains/exodus/core/dataStructures/ConcurrentIntObjectCache$CacheEntry;", "generationSize", "mask", "cacheObject", "key", "x", "(ILjava/lang/Object;)Ljava/lang/Object;", "cacheObjectLocked", "clear", "", "count", "getObject", "(I)Ljava/lang/Object;", "getObjectLocked", "indexFor", "lock", "remove", "removeLocked", "tryKey", "tryKeyLocked", "unlock", "CacheEntry", "Companion", "xodus-utils"})
public class ConcurrentIntObjectCache<V>
extends IntObjectCacheBase<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int numberOfGenerations;
    private final int generationSize;
    private final int mask;
    @NotNull
    private final CacheEntry<V>[] cache;
    public static final int DEFAULT_NUMBER_OF_GENERATIONS = 3;
    @NotNull
    private static final CacheEntry<?> NULL_OBJECT = new CacheEntry<Object>(Integer.MIN_VALUE, null);

    @JvmOverloads
    public ConcurrentIntObjectCache(int size, int numberOfGenerations) {
        super(size);
        this.numberOfGenerations = numberOfGenerations;
        this.generationSize = HashUtil.getFloorPrime(size / this.numberOfGenerations);
        this.mask = (1 << MathUtil.integerLogarithm(this.generationSize)) - 1;
        int n = 0;
        int n2 = this.numberOfGenerations * this.generationSize;
        CacheEntry[] cacheEntryArray = new CacheEntry[n2];
        ConcurrentIntObjectCache concurrentIntObjectCache = this;
        while (n < n2) {
            int n3 = n++;
            cacheEntryArray[n3] = NULL_OBJECT;
        }
        concurrentIntObjectCache.cache = cacheEntryArray;
    }

    public /* synthetic */ ConcurrentIntObjectCache(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 8192;
        }
        if ((n3 & 2) != 0) {
            n2 = 3;
        }
        this(n, n2);
    }

    @Override
    @Nullable
    public V tryKeyLocked(int key) {
        return this.tryKey(key);
    }

    @Override
    @Nullable
    public V getObjectLocked(int key) {
        return this.getObject(key);
    }

    @Override
    @Nullable
    public V cacheObjectLocked(int key, V x) {
        return this.cacheObject(key, x);
    }

    @Override
    @Nullable
    public V removeLocked(int key) {
        return this.remove(key);
    }

    @Override
    public void clear() {
        int n = 0;
        int n2 = this.cache.length;
        while (n < n2) {
            int i = n++;
            this.cache[i] = NULL_OBJECT;
        }
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    @Nullable
    public V cacheObject(int key, V x) {
        int cacheIndex = 0;
        cacheIndex = this.indexFor(key);
        int n = this.numberOfGenerations;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int it = n3 = n2++;
            boolean bl = false;
            CacheEntry<V> entry = this.cache[cacheIndex];
            if (entry.getKey() == key) {
                this.cache[cacheIndex] = new CacheEntry<V>(key, x);
                return null;
            }
            ++cacheIndex;
        }
        this.cache[cacheIndex - 1] = new CacheEntry<V>(key, x);
        return null;
    }

    @Override
    @Nullable
    public V remove(int key) {
        int cacheIndex = 0;
        cacheIndex = this.indexFor(key);
        int n = this.numberOfGenerations;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int it = n3 = n2++;
            boolean bl = false;
            CacheEntry<V> entry = this.cache[cacheIndex];
            if (entry.getKey() == key) {
                V result = entry.getValue();
                entry.setValue(null);
                return result;
            }
            ++cacheIndex;
        }
        return null;
    }

    @Override
    @Nullable
    public V tryKey(int key) {
        this.incAttempts();
        int cacheIndex = 0;
        cacheIndex = this.indexFor(key);
        CacheEntry<V> entry = null;
        entry = this.cache[cacheIndex];
        if (entry.getKey() == key) {
            this.incHits();
            return entry.getValue();
        }
        int n = this.numberOfGenerations - 1;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int it = n3 = n2++;
            boolean bl = false;
            if ((entry = this.cache[++cacheIndex]).getKey() != key) continue;
            this.incHits();
            CacheEntry<V> temp = this.cache[cacheIndex - 1];
            this.cache[cacheIndex - 1] = entry;
            this.cache[cacheIndex] = temp;
            return entry.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    public V getObject(int key) {
        int cacheIndex = 0;
        cacheIndex = this.indexFor(key);
        int n = this.numberOfGenerations;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int it = n3 = n2++;
            boolean bl = false;
            CacheEntry<V> entry = this.cache[cacheIndex];
            if (entry.getKey() == key) {
                return entry.getValue();
            }
            ++cacheIndex;
        }
        return null;
    }

    @Override
    public int count() {
        throw new UnsupportedOperationException();
    }

    private final int indexFor(int key) {
        return HashUtil.indexFor(key, this.generationSize, this.mask) * this.numberOfGenerations;
    }

    @JvmOverloads
    public ConcurrentIntObjectCache(int size) {
        this(size, 0, 2, null);
    }

    @JvmOverloads
    public ConcurrentIntObjectCache() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/core/dataStructures/ConcurrentIntObjectCache$Companion;", "", "()V", "DEFAULT_NUMBER_OF_GENERATIONS", "", "NULL_OBJECT", "Ljetbrains/exodus/core/dataStructures/ConcurrentIntObjectCache$CacheEntry;", "xodus-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u0005\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Ljetbrains/exodus/core/dataStructures/ConcurrentIntObjectCache$CacheEntry;", "V", "", "key", "", "value", "(ILjava/lang/Object;)V", "getKey", "()I", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "xodus-utils"})
    private static final class CacheEntry<V> {
        private final int key;
        @Nullable
        private V value;

        public CacheEntry(int key, @Nullable V value) {
            this.key = key;
            this.value = value;
        }

        public final int getKey() {
            return this.key;
        }

        @Nullable
        public final V getValue() {
            return this.value;
        }

        public final void setValue(@Nullable V v) {
            this.value = v;
        }
    }
}

