/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.cache.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.minifi.c2.api.InvalidParameterException;
import org.apache.nifi.minifi.c2.api.cache.ConfigurationCache;
import org.apache.nifi.minifi.c2.api.cache.ConfigurationCacheFileInfo;
import org.apache.nifi.minifi.c2.cache.s3.S3CacheFileInfoImpl;

public class S3ConfigurationCache
implements ConfigurationCache {
    private final AmazonS3 s3;
    private final String bucket;
    private final String prefix;
    private final String pathPattern;

    public S3ConfigurationCache(String bucket, String prefix, String pathPattern, String accessKey, String secretKey, String region) throws IOException {
        this.bucket = bucket;
        this.prefix = prefix;
        this.pathPattern = pathPattern;
        this.s3 = !StringUtils.isEmpty((CharSequence)accessKey) ? (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)))).withRegion(Regions.fromName((String)region))).build() : (AmazonS3)((AmazonS3ClientBuilder)AmazonS3Client.builder().withRegion(Regions.fromName((String)region))).build();
    }

    public ConfigurationCacheFileInfo getCacheFileInfo(String contentType, Map<String, List<String>> parameters) throws InvalidParameterException {
        String[] split;
        Object pathString = this.pathPattern;
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            if (entry.getValue().size() != 1) {
                throw new InvalidParameterException("Multiple values for same parameter are not supported by this provider.");
            }
            pathString = ((String)pathString).replaceAll(Pattern.quote("${" + entry.getKey() + "}"), entry.getValue().get(0));
        }
        pathString = (String)pathString + "." + contentType.replace('/', '.');
        for (String s1 : split = ((String)pathString).split("/")) {
            int closeBrace;
            int openBrace = s1.indexOf("${");
            if (openBrace < 0 || openBrace >= s1.length() + 2 || (closeBrace = s1.indexOf("}", openBrace + 2)) < 0) continue;
            throw new InvalidParameterException("Found unsubstituted variable " + s1.substring(openBrace + 2, closeBrace));
        }
        return new S3CacheFileInfoImpl(this.s3, this.bucket, this.prefix, (String)pathString + ".v");
    }
}

