/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.python;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PythonProcessConfig {
    private final String pythonCommand;
    private final File pythonFrameworkDirectory;
    private final List<File> pythonExtensionsDirectories;
    private final File pythonWorkingDirectory;
    private final File pythonLogsDirectory;
    private final Duration commsTimeout;
    private final int maxPythonProcesses;
    private final int maxPythonProcessesPerType;
    private final boolean debugController;
    private final String debugHost;
    private final int debugPort;
    private final File debugLogsDirectory;

    private PythonProcessConfig(Builder builder) {
        this.pythonCommand = builder.pythonCommand;
        this.pythonFrameworkDirectory = builder.pythonFrameworkDirectory;
        this.pythonExtensionsDirectories = builder.pythonExtensionsDirectories;
        this.pythonLogsDirectory = builder.pythonLogsDirectory;
        this.pythonWorkingDirectory = builder.pythonWorkingDirectory;
        this.commsTimeout = builder.commsTimeout;
        this.maxPythonProcesses = builder.maxProcesses;
        this.maxPythonProcessesPerType = builder.maxProcessesPerType;
        this.debugController = builder.debugController;
        this.debugPort = builder.debugPort;
        this.debugHost = builder.debugHost;
        this.debugLogsDirectory = builder.debugLogsDirectory;
    }

    public String getPythonCommand() {
        return this.pythonCommand;
    }

    public File getPythonFrameworkDirectory() {
        return this.pythonFrameworkDirectory;
    }

    public List<File> getPythonExtensionsDirectories() {
        return this.pythonExtensionsDirectories;
    }

    public File getPythonLogsDirectory() {
        return this.pythonLogsDirectory;
    }

    public File getPythonWorkingDirectory() {
        return this.pythonWorkingDirectory;
    }

    public Duration getCommsTimeout() {
        return this.commsTimeout;
    }

    public int getMaxPythonProcesses() {
        return this.maxPythonProcesses;
    }

    public int getMaxPythonProcessesPerType() {
        return this.maxPythonProcessesPerType;
    }

    public boolean isDebugController() {
        return this.debugController;
    }

    public String getDebugHost() {
        return this.debugHost;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public File getDebugLogsDirectory() {
        return this.debugLogsDirectory;
    }

    public static class Builder {
        private String pythonCommand = "python3";
        private File pythonFrameworkDirectory = new File("python/framework");
        private List<File> pythonExtensionsDirectories = Collections.singletonList(new File("python/extensions"));
        private File pythonLogsDirectory = new File("./logs");
        private File pythonWorkingDirectory = new File("python");
        private Duration commsTimeout = Duration.ofSeconds(0L);
        private int maxProcesses;
        private int maxProcessesPerType;
        private boolean debugController = false;
        private String debugHost = "localhost";
        private int debugPort = 5678;
        private File debugLogsDirectory = new File("logs/");

        public Builder pythonCommand(String command) {
            this.pythonCommand = command;
            return this;
        }

        public Builder pythonFrameworkDirectory(File pythonFrameworkDirectory) {
            this.pythonFrameworkDirectory = pythonFrameworkDirectory;
            return this;
        }

        public Builder pythonExtensionsDirectories(Collection<File> pythonExtensionsDirectories) {
            this.pythonExtensionsDirectories = new ArrayList<File>(pythonExtensionsDirectories);
            return this;
        }

        public Builder pythonWorkingDirectory(File pythonWorkingDirectory) {
            this.pythonWorkingDirectory = pythonWorkingDirectory;
            return this;
        }

        public Builder commsTimeout(Duration duration) {
            if (duration == null) {
                return this;
            }
            this.commsTimeout = duration;
            return this;
        }

        public Builder maxPythonProcesses(int maxProcesses) {
            if (maxProcesses < 0) {
                throw new IllegalArgumentException("Cannot configure max number of Python Processes to be less than 0");
            }
            this.maxProcesses = maxProcesses;
            return this;
        }

        public Builder maxPythonProcessesPerType(int maxProcessesPerType) {
            if (maxProcessesPerType < 1) {
                throw new IllegalArgumentException("Cannot configure max number of Python Processes to be less than 1");
            }
            this.maxProcessesPerType = maxProcessesPerType;
            return this;
        }

        public Builder pythonLogsDirectory(File logsDirectory) {
            this.pythonLogsDirectory = logsDirectory;
            return this;
        }

        public Builder enableControllerDebug(boolean enableDebug) {
            this.debugController = enableDebug;
            return this;
        }

        public Builder debugPort(int debugPort) {
            this.debugPort = debugPort;
            return this;
        }

        public Builder debugHost(String debugHost) {
            this.debugHost = debugHost;
            return this;
        }

        public Builder debugLogsDirectory(File debugLogsDirectory) {
            this.debugLogsDirectory = debugLogsDirectory;
            return this;
        }

        public PythonProcessConfig build() {
            return new PythonProcessConfig(this);
        }
    }
}

