/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.cluster.protocol.StandardDataFlow;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.util.FlowInfo;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowParser {
    private static final Logger logger = LoggerFactory.getLogger(FlowParser.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public FlowInfo parse(File flowConfigurationFile) {
        if (flowConfigurationFile == null) {
            logger.debug("Flow Configuration file was null");
            return null;
        }
        Path flowPath = flowConfigurationFile.toPath();
        try {
            if (!Files.exists(flowPath, new LinkOption[0]) || Files.size(flowPath) == 0L) {
                logger.warn("Flow Configuration does not exist or was empty");
                return null;
            }
        }
        catch (IOException e) {
            logger.error("An error occurred determining the size of the Flow Configuration file");
            return null;
        }
        try (InputStream in = Files.newInputStream(flowPath, StandardOpenOption.READ);){
            byte[] flowBytes;
            GZIPInputStream gzipIn;
            block19: {
                FlowInfo flowInfo;
                gzipIn = new GZIPInputStream(in);
                try {
                    flowBytes = IOUtils.toByteArray((InputStream)gzipIn);
                    if (flowBytes != null && flowBytes.length != 0) break block19;
                    logger.warn("Could not extract root group id because Flow Configuration File was empty");
                    flowInfo = null;
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)gzipIn).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ((InputStream)gzipIn).close();
                return flowInfo;
            }
            FlowInfo flowInfo = this.parseJson(flowBytes);
            ((InputStream)gzipIn).close();
            return flowInfo;
        }
        catch (IOException ex) {
            logger.error("Unable to parse flow {}", (Object)flowPath.toAbsolutePath(), (Object)ex);
            return null;
        }
    }

    private FlowInfo parseJson(byte[] flowBytes) {
        StandardDataFlow standardDataFlow = new StandardDataFlow(flowBytes, new byte[0], null, Collections.emptySet());
        VersionedDataflow dataflow = standardDataFlow.getVersionedDataflow();
        VersionedProcessGroup rootGroup = dataflow.getRootGroup();
        if (rootGroup == null) {
            return null;
        }
        ArrayList<PortDTO> ports = new ArrayList<PortDTO>();
        this.mapPorts(rootGroup.getInputPorts(), ports);
        this.mapPorts(rootGroup.getOutputPorts(), ports);
        return new FlowInfo(rootGroup.getInstanceIdentifier(), ports);
    }

    private void mapPorts(Set<VersionedPort> versionedPorts, List<PortDTO> portDtos) {
        if (versionedPorts == null || versionedPorts.isEmpty()) {
            return;
        }
        for (VersionedPort port : versionedPorts) {
            PortDTO portDto = this.mapPort(port);
            portDtos.add(portDto);
        }
    }

    private PortDTO mapPort(VersionedPort port) {
        PortDTO dto = new PortDTO();
        dto.setAllowRemoteAccess(port.isAllowRemoteAccess());
        dto.setComments(port.getComments());
        dto.setConcurrentlySchedulableTaskCount(port.getConcurrentlySchedulableTaskCount());
        dto.setId(port.getIdentifier());
        dto.setName(port.getName());
        dto.setParentGroupId(port.getGroupIdentifier());
        dto.setPosition(new PositionDTO(Double.valueOf(port.getPosition().getX()), Double.valueOf(port.getPosition().getY())));
        dto.setState(port.getScheduledState().name());
        dto.setType(port.getType().name());
        return dto;
    }
}

