/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.spring;

import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.heartbeat.HeartbeatMonitor;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.validation.RuleViolationsManager;
import org.apache.nifi.web.revision.RevisionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FlowControllerFactoryBean
implements FactoryBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private FlowController flowController;
    private NiFiProperties properties;
    private Authorizer authorizer;
    private AuditService auditService;
    private PropertyEncryptor encryptor;
    private BulletinRepository bulletinRepository;
    private ClusterCoordinator clusterCoordinator;
    private LeaderElectionManager leaderElectionManager;
    private ExtensionDiscoveringManager extensionManager;
    private RevisionManager revisionManager;
    private RuleViolationsManager ruleViolationsManager;
    private StatusHistoryRepository statusHistoryRepository;

    public Object getObject() throws Exception {
        if (this.flowController == null) {
            FlowFileEventRepository flowFileEventRepository = (FlowFileEventRepository)this.applicationContext.getBean("flowFileEventRepository", FlowFileEventRepository.class);
            if (this.properties.isNode()) {
                NodeProtocolSender nodeProtocolSender = (NodeProtocolSender)this.applicationContext.getBean("nodeProtocolSender", NodeProtocolSender.class);
                HeartbeatMonitor heartbeatMonitor = (HeartbeatMonitor)this.applicationContext.getBean("heartbeatMonitor", HeartbeatMonitor.class);
                this.flowController = FlowController.createClusteredInstance(flowFileEventRepository, this.properties, this.authorizer, this.auditService, this.encryptor, nodeProtocolSender, this.bulletinRepository, this.clusterCoordinator, heartbeatMonitor, this.leaderElectionManager, this.extensionManager, this.revisionManager, this.statusHistoryRepository, this.ruleViolationsManager);
            } else {
                this.flowController = FlowController.createStandaloneInstance(flowFileEventRepository, this.properties, this.authorizer, this.auditService, this.encryptor, this.bulletinRepository, this.extensionManager, this.statusHistoryRepository, this.ruleViolationsManager);
            }
        }
        return this.flowController;
    }

    public Class getObjectType() {
        return FlowController.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setEncryptor(PropertyEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.bulletinRepository = bulletinRepository;
    }

    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    public void setLeaderElectionManager(LeaderElectionManager leaderElectionManager) {
        this.leaderElectionManager = leaderElectionManager;
    }

    public void setExtensionManager(ExtensionDiscoveringManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void setRevisionManager(RevisionManager revisionManager) {
        this.revisionManager = revisionManager;
    }

    public void setRuleViolationsManager(RuleViolationsManager ruleViolationsManager) {
        this.ruleViolationsManager = ruleViolationsManager;
    }

    public void setStatusHistoryRepository(StatusHistoryRepository statusHistoryRepository) {
        this.statusHistoryRepository = statusHistoryRepository;
    }
}

