/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.Severity;

public class FlowAnalysisRuleLogObserver
implements LogObserver {
    private final BulletinRepository bulletinRepository;
    private final FlowAnalysisRuleNode flowAnalysisRuleNode;

    public FlowAnalysisRuleLogObserver(BulletinRepository bulletinRepository, FlowAnalysisRuleNode flowAnalysisRuleNode) {
        this.bulletinRepository = bulletinRepository;
        this.flowAnalysisRuleNode = flowAnalysisRuleNode;
    }

    public void onLogMessage(LogMessage message) {
        String bulletinLevel = message.getLogLevel() == LogLevel.WARN ? Severity.WARNING.name() : message.getLogLevel().toString();
        Bulletin bulletin = BulletinFactory.createBulletin(null, (String)this.flowAnalysisRuleNode.getIdentifier(), (ComponentType)ComponentType.FLOW_ANALYSIS_RULE, (String)this.flowAnalysisRuleNode.getName(), (String)"Log Message", (String)bulletinLevel, (String)message.getMessage());
        this.bulletinRepository.addBulletin(bulletin);
    }

    public String getComponentDescription() {
        return this.flowAnalysisRuleNode.toString();
    }
}

