/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.flowanalysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.VersionedControllerServiceLookup;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisUtil;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flowanalysis.FlowAnalysisContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;

public class StandardFlowAnalysisContext
implements FlowAnalysisContext {
    private final FlowController flowController;

    public StandardFlowAnalysisContext(FlowController flowController) {
        this.flowController = flowController;
    }

    public VersionedControllerServiceLookup getVersionedControllerServiceLookup() {
        VersionedControllerServiceLookup versionedControllerServiceLookup = id -> {
            ControllerServiceProvider controllerServiceProvider = this.flowController.getControllerServiceProvider();
            ExtensionManager extensionManager = this.flowController.getExtensionManager();
            NiFiRegistryFlowMapper mapper = FlowAnalysisUtil.createMapper(extensionManager);
            ControllerServiceNode controllerServiceNode = controllerServiceProvider.getControllerServiceNode(id);
            VersionedControllerService versionedControllerService = mapper.mapControllerService(controllerServiceNode, controllerServiceProvider, Collections.emptySet(), new HashMap());
            return versionedControllerService;
        };
        return versionedControllerServiceLookup;
    }

    public int getMaxTimerDrivenThreadCount() {
        return this.flowController.getMaxTimerDrivenThreadCount();
    }

    public boolean isClustered() {
        return this.flowController.isConfiguredForClustering();
    }

    public Optional<String> getClusterNodeIdentifier() {
        NodeIdentifier nodeId = this.flowController.getNodeId();
        Optional<String> nodeIdOptional = Optional.ofNullable(nodeId).map(NodeIdentifier::getId);
        return nodeIdOptional;
    }
}

