/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.tasks;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.SqlCompiler;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ObjectFactory;
import io.questdb.tasks.AbstractTelemetryTask;
import org.jetbrains.annotations.NotNull;

public class TelemetryWalTask
implements AbstractTelemetryTask {
    public static final String TABLE_NAME = "telemetry_wal";
    public static final Telemetry.TelemetryTypeBuilder<TelemetryWalTask> WAL_TELEMETRY = configuration -> {
        final String tableName = configuration.getSystemTableNamePrefix() + TABLE_NAME;
        return new Telemetry.TelemetryType<TelemetryWalTask>(){

            @Override
            public SqlCompiler.QueryBuilder getCreateSql(SqlCompiler.QueryBuilder builder) {
                return builder.$("CREATE TABLE IF NOT EXISTS \"").$(tableName).$("\" (created timestamp, event short, tableId int, walId int, seqTxn long, rowCount long,physicalRowCount long,latency float) timestamp(created) partition by MONTH BYPASS WAL");
            }

            @Override
            public String getTableName() {
                return tableName;
            }

            @Override
            public ObjectFactory<TelemetryWalTask> getTaskFactory() {
                return () -> new TelemetryWalTask();
            }
        };
    };
    private static final Log LOG = LogFactory.getLog(TelemetryWalTask.class);
    private short event;
    private float latency;
    private long physicalRowCount;
    private long rowCount;
    private long seqTxn;
    private int tableId;
    private int walId;

    private TelemetryWalTask() {
    }

    public static void store(@NotNull Telemetry<TelemetryWalTask> telemetry, short event, int tableId, int walId, long seqTxn, long rowCount, long physicalRowCount, long latencyUs) {
        TelemetryWalTask task = telemetry.nextTask();
        if (task != null) {
            task.event = event;
            task.tableId = tableId;
            task.walId = walId;
            task.seqTxn = seqTxn;
            task.rowCount = rowCount;
            task.physicalRowCount = physicalRowCount;
            task.latency = (float)latencyUs / 1000.0f;
            telemetry.store();
        }
    }

    @Override
    public void writeTo(TableWriter writer, long timestamp) {
        try {
            TableWriter.Row row = writer.newRow(timestamp);
            row.putShort(1, this.event);
            row.putInt(2, this.tableId);
            row.putInt(3, this.walId);
            row.putLong(4, this.seqTxn);
            row.putLong(5, this.rowCount);
            row.putLong(6, this.physicalRowCount);
            row.putFloat(7, this.latency);
            row.append();
        }
        catch (CairoException e) {
            LOG.error().$("Could not insert a new ").$(TABLE_NAME).$(" row [errno=").$(e.getErrno()).$(", error=").$(e.getFlyweightMessage()).$(']').$();
        }
    }
}

