/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.tasks;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.SqlCompiler;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ObjectFactory;
import io.questdb.tasks.AbstractTelemetryTask;

public class TelemetryTask
implements AbstractTelemetryTask {
    public static final String TABLE_NAME = "telemetry";
    private static final Log LOG = LogFactory.getLog(TelemetryTask.class);
    public static final Telemetry.TelemetryTypeBuilder<TelemetryTask> TELEMETRY = configuration -> new Telemetry.TelemetryType<TelemetryTask>(){
        private final TelemetryTask systemStatusTask = new TelemetryTask();

        @Override
        public SqlCompiler.QueryBuilder getCreateSql(SqlCompiler.QueryBuilder builder) {
            return builder.$("CREATE TABLE IF NOT EXISTS \"").$(TelemetryTask.TABLE_NAME).$("\" (created timestamp, event short, origin short) timestamp(created)");
        }

        @Override
        public String getTableName() {
            return TelemetryTask.TABLE_NAME;
        }

        @Override
        public ObjectFactory<TelemetryTask> getTaskFactory() {
            return () -> new TelemetryTask();
        }

        @Override
        public void logStatus(TableWriter writer, short systemStatus, long micros) {
            this.systemStatusTask.origin = 1;
            this.systemStatusTask.event = systemStatus;
            this.systemStatusTask.writeTo(writer, micros);
            writer.commit();
        }

        @Override
        public boolean shouldLogClasses() {
            return true;
        }
    };
    private short event;
    private short origin;

    private TelemetryTask() {
    }

    public static void store(Telemetry<TelemetryTask> telemetry, short origin, short event) {
        TelemetryTask task = telemetry.nextTask();
        if (task != null) {
            task.origin = origin;
            task.event = event;
            telemetry.store();
        }
    }

    @Override
    public void writeTo(TableWriter writer, long timestamp) {
        try {
            TableWriter.Row row = writer.newRow(timestamp);
            row.putShort(1, this.event);
            row.putShort(2, this.origin);
            row.append();
        }
        catch (CairoException e) {
            LOG.error().$("Could not insert a new ").$(TABLE_NAME).$(" row [errno=").$(e.getErrno()).$(", error=").$(e.getFlyweightMessage()).$(']').$();
        }
    }
}

