/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.MutableCharSink;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class DirectCharSink
extends AbstractCharSink
implements MutableCharSink,
Closeable {
    private final long initialCapacity;
    private long capacity;
    private long hi;
    private long lo;
    private long ptr;
    private FloatingCharSequence subSequence;

    public DirectCharSink(long capacity) {
        this.ptr = Unsafe.malloc(capacity, 51);
        this.capacity = capacity;
        this.initialCapacity = capacity;
        this.lo = this.ptr;
        this.hi = this.ptr + capacity;
    }

    @Override
    public char charAt(int index) {
        return Unsafe.getUnsafe().getChar(this.ptr + (long)index * 2L);
    }

    @Override
    public void clear() {
        this.lo = this.ptr;
    }

    @Override
    public void close() {
        Unsafe.free(this.ptr, this.capacity, 51);
    }

    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public int length() {
        return (int)(this.lo - this.ptr) / 2;
    }

    @Override
    public CharSink put(CharSequence cs) {
        if (cs != null) {
            int l = cs.length();
            int l2 = l * 2;
            if (this.lo + (long)l2 >= this.hi) {
                this.resize(Math.max(this.capacity * 2L, (this.lo - this.ptr + (long)l2) * 2L));
            }
            for (int i = 0; i < l; ++i) {
                Unsafe.getUnsafe().putChar(this.lo + (long)i * 2L, cs.charAt(i));
            }
            this.lo += (long)l2;
        }
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (this.lo == this.hi) {
            this.resize(this.capacity * 2L);
        }
        Unsafe.getUnsafe().putChar(this.lo, c);
        this.lo += 2L;
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        int l2 = len * 2;
        if (this.lo + (long)l2 >= this.hi) {
            this.resize((int)Math.max(this.capacity * 2L, (this.lo - this.ptr + (long)l2) * 2L));
        }
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putChar(this.lo + (long)i * 2L, chars[i + start]);
        }
        this.lo += (long)l2;
        return this;
    }

    public void resetCapacity() {
        this.resize(this.initialCapacity);
        this.clear();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (this.subSequence == null) {
            this.subSequence = new FloatingCharSequence();
        }
        return this.subSequence.of(start, end - start);
    }

    @Override
    @NotNull
    public String toString() {
        return AbstractCharSequence.getString(this);
    }

    private void resize(long cap) {
        long temp = Unsafe.realloc(this.ptr, this.capacity, cap, 51);
        int len = (int)(this.lo - this.ptr);
        this.ptr = temp;
        this.capacity = cap;
        this.lo = this.ptr + (long)len;
        this.hi = this.ptr + cap;
    }

    private class FloatingCharSequence
    extends AbstractCharSequence {
        private int len;
        private int startIndex;

        private FloatingCharSequence() {
        }

        @Override
        public char charAt(int index) {
            return Unsafe.getUnsafe().getChar(DirectCharSink.this.ptr + (long)(this.startIndex + index) * 2L);
        }

        @Override
        public int length() {
            return this.len;
        }

        CharSequence of(int startIndex, int len) {
            this.startIndex = startIndex;
            this.len = len;
            return this;
        }
    }
}

